/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.xbartheory.worldgen;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2874;
import net.minecraft.class_4076;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_8961;
import net.minecraft.class_8963;
import org.jetbrains.annotations.Nullable;
import xyz.flirora.xbartheory.mixin.TrialSpawnerBlockEntityAccessor;
import xyz.flirora.xbartheory.mixin.TrialSpawnerLogicAccessor;
import xyz.flirora.xbartheory.worldgen.ConfigKeyPair;

public class BlockPlacementBuffer {
    private final class_1937 parent;
    private final Long2ObjectMap<byte[]> contentsBySectionPos = new Long2ObjectOpenHashMap();
    private final List<class_2680> blockStatesByOrdinal = new ArrayList<class_2680>();
    private final Object2IntMap<class_2680> ordinalsByBlockState = new Object2IntOpenHashMap();
    private final Long2ObjectMap<class_2586> blockEntitiesByBlockPos = new Long2ObjectOpenHashMap();

    public BlockPlacementBuffer(class_1937 parent) {
        this.parent = parent;
    }

    public int getMaxY() {
        class_2874 dim = this.parent.method_8597();
        return dim.comp_651() + dim.comp_652();
    }

    @Nullable
    public class_2680 getExplicitBlockState(class_2338 pos) {
        int localZ;
        byte[] section = (byte[])this.contentsBySectionPos.get(class_4076.method_18691((long)pos.method_10063()));
        if (section == null) {
            return null;
        }
        int localX = pos.method_10263() & 0xF;
        int localY = pos.method_10264() & 0xF;
        int id = section[localY << 8 | (localZ = pos.method_10260() & 0xF) << 4 | localX] & 0xFF;
        if (id == 0) {
            return null;
        }
        return this.blockStatesByOrdinal.get(id - 1);
    }

    public class_2680 getBlockState(class_2338 pos) {
        class_2680 state = this.getExplicitBlockState(pos);
        if (state != null) {
            return state;
        }
        return this.parent.method_8320(pos);
    }

    private int computeOrdinal(class_2680 state) {
        return this.ordinalsByBlockState.computeIfAbsent((Object)state, s -> {
            int ordinal = this.blockStatesByOrdinal.size();
            if (ordinal > 254) {
                throw new UnsupportedOperationException("Too many block states :(");
            }
            this.blockStatesByOrdinal.add(state);
            return ordinal;
        });
    }

    public void setBlockState(class_2338 pos, class_2680 state) {
        long sectionPos = class_4076.method_18691((long)pos.method_10063());
        byte[] section = (byte[])this.contentsBySectionPos.computeIfAbsent(sectionPos, sp -> new byte[4096]);
        int ordinal = this.computeOrdinal(state);
        int localX = pos.method_10263() & 0xF;
        int localY = pos.method_10264() & 0xF;
        int localZ = pos.method_10260() & 0xF;
        section[localY << 8 | localZ << 4 | localX] = (byte)(ordinal + 1);
    }

    public void addBlockEntity(class_2586 entity) {
        this.blockEntitiesByBlockPos.put(entity.method_11016().method_10063(), (Object)entity);
        entity.method_31662(this.parent);
    }

    public void addLootContainer(class_2338 pos, class_2680 state, class_5321<class_52> lootTable, class_5819 random) {
        this.setBlockState(pos, state);
        class_2621 blockEntity = (class_2621)((class_2237)state.method_26204()).method_10123(pos, state);
        assert (blockEntity != null);
        this.addBlockEntity((class_2586)blockEntity);
        blockEntity.method_54867(lootTable, random.method_43055());
    }

    public void addChest(class_2338 pos, class_5321<class_52> lootTable, class_5819 random) {
        this.addChest(pos, lootTable, random, class_2350.class_2353.field_11062.method_10183(random));
    }

    public void addChest(class_2338 pos, class_5321<class_52> lootTable, class_5819 random, class_2350 facing) {
        this.addLootContainer(pos, (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)facing), lootTable, random);
    }

    public void addBarrel(class_2338 pos, class_5321<class_52> lootTable, class_5819 random) {
        this.addLootContainer(pos, (class_2680)class_2246.field_16328.method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.method_10162((class_5819)random)), lootTable, random);
    }

    public void addTrialSpawner(class_2338 pos, ConfigKeyPair trialConfigs) {
        this.setBlockState(pos, class_2246.field_47336.method_9564());
        class_8961 blockEntity = new class_8961(pos, class_2246.field_47336.method_9564());
        this.addBlockEntity((class_2586)blockEntity);
        TrialSpawnerLogicAccessor logic = (TrialSpawnerLogicAccessor)((TrialSpawnerBlockEntityAccessor)blockEntity).getLogic();
        class_8963.class_11349 original = logic.getFullConfig();
        logic.setFullConfig(new class_8963.class_11349(trialConfigs.normal(), trialConfigs.ominous(), original.comp_4233(), original.comp_4234()));
    }

    public void commit() {
        for (Long2ObjectMap.Entry e : this.contentsBySectionPos.long2ObjectEntrySet()) {
            long sectionPos = e.getLongKey();
            int sectionX = class_4076.method_18686((long)sectionPos);
            int sectionY = class_4076.method_18689((long)sectionPos);
            int sectionZ = class_4076.method_18690((long)sectionPos);
            byte[] section = (byte[])e.getValue();
            for (int localY = 0; localY < 16; ++localY) {
                for (int localZ = 0; localZ < 16; ++localZ) {
                    for (int localX = 0; localX < 16; ++localX) {
                        int id = section[localY << 8 | localZ << 4 | localX] & 0xFF;
                        if (id <= 0) continue;
                        class_2680 state = this.blockStatesByOrdinal.get(id - 1);
                        this.parent.method_8501(new class_2338(sectionX << 4 | localX, sectionY << 4 | localY, sectionZ << 4 | localZ), state);
                    }
                }
            }
        }
        for (Long2ObjectMap.Entry e : this.blockEntitiesByBlockPos.long2ObjectEntrySet()) {
            this.parent.method_8438((class_2586)e.getValue());
        }
    }
}

