/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common;

import com.kwwsyk.endinv.common.EndInvAffinities;
import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.SourceInventory;
import com.kwwsyk.endinv.common.util.ItemKey;
import com.kwwsyk.endinv.common.util.ItemStackLike;
import com.kwwsyk.endinv.common.util.ItemState;
import com.kwwsyk.endinv.common.util.SortType;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public class EndlessInventory
extends SourceInventory {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<ItemStack>[] sortedViews = new List[SortType.values().length];
    private final long[] lastSortedTimes = new long[SortType.values().length];
    public final EndInvAffinities affinities;
    public List<ServerPlayer> viewers = new ArrayList<ServerPlayer>();

    public EndlessInventory() {
        this(UUID.randomUUID());
    }

    public EndlessInventory(UUID uuid) {
        super(uuid);
        this.affinities = new EndInvAffinities(this);
    }

    @Override
    protected List<ItemStack> getSortedView(SortType type, boolean reverse) {
        int idx = type.ordinal();
        if (this.lastSortedTimes[idx] != this.lastModTime || this.sortedViews[idx] == null) {
            List view = this.itemMap.entrySet().stream().map(e -> ((ItemKey)e.getKey()).toStack(((ItemState)e.getValue()).count())).sorted(ModInfo.sortHelper.getComparator(type, this)).collect(Collectors.toList());
            this.sortedViews[idx] = view;
            this.lastSortedTimes[idx] = this.lastModTime;
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(this.sortedViews[idx]);
        if (reverse) {
            Collections.reverse(ret);
        }
        return ret;
    }

    public List<ItemStackLike> getStarredItems(@Nonnegative int startIndex, @Nonnegative int length) {
        List<ItemStack> items = this.affinities.getStarredItems(startIndex, length);
        return items.stream().map(this::getStackWithZeroCount).toList();
    }

    public List<ItemStackLike> getStarredItems() {
        return this.getStarredItems(0, this.affinities.starredItems.size());
    }

    public ItemStackLike getStackWithZeroCount(ItemStack stack) {
        ItemState state = (ItemState)this.itemMap.get(ItemKey.asKey(stack));
        if (state == null) {
            return ItemStackLike.asKey(stack);
        }
        return ItemStackLike.asKey(stack, state.count());
    }

    @Nullable
    public Optional<ServerPlayer> getOwner(ServerLevel level) {
        return level.m_8795_(pl -> Objects.equals(pl.m_20148_(), this.owner)).stream().findAny();
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public void setChanged() {
        ServerLevelEndInv.levelEndInvData.m_77762_();
    }

    public long updateModState(long newState) {
        this.lastModTime = Math.max(this.lastModTime, newState);
        return this.lastModTime;
    }

    public void broadcastChanges() {
    }
}

