/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.util.Accessibility;
import com.kwwsyk.endinv.common.util.ItemKey;
import com.kwwsyk.endinv.common.util.ItemState;
import com.kwwsyk.endinv.common.util.SearchUtil;
import com.kwwsyk.endinv.common.util.SortType;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public abstract class SourceInventory {
    protected Map<ItemKey, ItemState> itemMap;
    protected List<ItemStack> items;
    protected UUID uuid;
    protected long lastModTime = Util.m_137550_();
    protected int maxStackSize;
    protected boolean infinityMode;
    @Nullable
    protected UUID owner;
    public List<UUID> white_list = new ArrayList<UUID>();
    protected Accessibility accessibility;

    public SourceInventory(UUID uuid) {
        this.items = new ArrayList<ItemStack>();
        this.itemMap = new Object2ObjectLinkedOpenHashMap();
        this.uuid = uuid;
        this.maxStackSize = ModInfo.getServerConfig().getMaxAllowedStackSize().get();
        this.infinityMode = ModInfo.getServerConfig().allowInfinityMode().get();
        this.accessibility = ModInfo.getServerConfig().defaultAccessibility().get();
    }

    public abstract boolean isRemote();

    public abstract void setChanged();

    public UUID getUuid() {
        return this.uuid;
    }

    public UUID giveNewUuid() {
        this.uuid = UUID.randomUUID();
        return this.uuid;
    }

    public Map<ItemKey, ItemState> getItemMap() {
        return this.itemMap;
    }

    public List<ItemStack> getItemsAsList() {
        this.syncItemsFromMap();
        return this.items;
    }

    public int getItemSize() {
        this.syncItemsFromMap();
        return this.items.size();
    }

    public int getMaxItemStackSize() {
        return this.maxStackSize;
    }

    public void setMaxItemStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
    }

    public boolean isInfinityMode() {
        return this.infinityMode;
    }

    public void setInfinityMode(boolean infinityMode) {
        this.infinityMode = infinityMode;
    }

    public Accessibility getAccessibility() {
        return this.accessibility;
    }

    public void setAccessibility(Accessibility accessibility) {
        this.accessibility = accessibility;
    }

    public boolean accessible(Player player) {
        return this.accessibility == Accessibility.PUBLIC || this.owner != null && this.owner.equals(player.m_20148_()) || this.white_list.contains(player.m_20148_()) && this.accessibility == Accessibility.RESTRICTED;
    }

    public boolean isOwner(Player player) {
        return Objects.equals(player.m_20148_(), this.owner);
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.owner;
    }

    public void setOwner(@Nullable UUID owner) {
        this.owner = owner;
    }

    public ItemStack takeItem(ItemStack itemStack) {
        return this.takeItem(itemStack, itemStack.m_41741_());
    }

    public ItemStack takeItem(ItemStack stack, int count) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemKey key = ItemKey.asKey(stack);
        ItemState state = this.itemMap.get(key);
        if (state == null) {
            return ItemStack.f_41583_;
        }
        if (state.count() >= this.maxStackSize && this.infinityMode) {
            this.setChanged();
            return stack.m_255036_(count);
        }
        int taken = Math.min(count, state.count());
        ItemStack result = stack.m_255036_(taken);
        if (taken == state.count()) {
            this.itemMap.remove(key);
            this.updateLastModTime();
        } else {
            this.itemMap.put(key, new ItemState(state.count() - taken, this.updateLastModTime()));
        }
        this.setChanged();
        return result;
    }

    public ItemStack addItem(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemKey key = ItemKey.asKey(itemStack);
        ItemState state = this.itemMap.get(key);
        int count = itemStack.m_41613_();
        int original = 0;
        if (state != null) {
            original = state.count();
        }
        if (original < this.maxStackSize) {
            int increased = original + count;
            if (increased <= this.maxStackSize) {
                this.itemMap.put(key, new ItemState(increased, this.updateLastModTime()));
                this.setChanged();
                return ItemStack.f_41583_;
            }
            this.itemMap.put(key, new ItemState(this.maxStackSize, this.updateLastModTime()));
            this.setChanged();
            return itemStack.m_255036_(increased - this.maxStackSize);
        }
        if (this.infinityMode) {
            this.itemMap.put(key, new ItemState(original, this.updateLastModTime()));
            this.setChanged();
            return ItemStack.f_41583_;
        }
        return itemStack.m_41777_();
    }

    public void clearContent() {
        this.itemMap.clear();
        this.setChanged();
    }

    protected List<ItemStack> getSortedView(SortType type, boolean reverse) {
        List<ItemStack> ret = this.itemMap.entrySet().stream().map(e -> ((ItemKey)e.getKey()).toStack(((ItemState)e.getValue()).count())).sorted(ModInfo.sortHelper.getComparator(type, this)).collect(Collectors.toList());
        if (reverse) {
            Collections.reverse(ret);
        }
        return ret;
    }

    public List<ItemStack> getSortedAndFilteredItemView(int startIndex, int length, SortType sortType, boolean reverse, @Nullable Predicate<ItemStack> classify, String search) {
        Stream base = this.getSortedView(sortType, reverse).stream();
        List<ItemStack> filtered = base.filter(classify != null ? classify : is -> true).filter(stack -> SearchUtil.matchesSearch(stack, search)).toList();
        if (startIndex >= filtered.size()) {
            return new ArrayList<ItemStack>();
        }
        return filtered.subList(startIndex, Math.min(startIndex + length, filtered.size()));
    }

    public void syncItemsFromMap() {
        this.items = this.itemMap.entrySet().stream().map(e -> ((ItemKey)e.getKey()).toStack(((ItemState)e.getValue()).count())).collect(Collectors.toList());
    }

    public void syncMapFromItems() {
        this.itemMap.clear();
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            long now = this.updateLastModTime();
            ItemKey key = ItemKey.asKey(stack);
            this.itemMap.put(key, new ItemState(stack.m_41613_(), now));
        }
    }

    public long updateLastModTime() {
        this.lastModTime = Util.m_137550_();
        return this.lastModTime;
    }
}

