/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.SourceInventory;
import com.kwwsyk.endinv.common.network.payloads.toClient.EndInvMetadata;
import com.kwwsyk.endinv.common.util.ItemKey;
import com.kwwsyk.endinv.common.util.ItemState;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.world.item.ItemStack;

public class CachedSrcInv
extends SourceInventory {
    public static final CachedSrcInv INSTANCE = new CachedSrcInv();

    private CachedSrcInv() {
        super(ModInfo.DEFAULT_UUID);
    }

    public void initializeContents(Map<ItemKey, ItemState> itemMap) {
        this.itemMap = new Object2ObjectLinkedOpenHashMap(itemMap);
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public ItemStack takeItem(ItemStack stack, int count) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemKey key = ItemKey.asKey(stack);
        ItemState state = (ItemState)this.itemMap.get(key);
        if (state == null) {
            return ItemStack.f_41583_;
        }
        if (state.count() >= this.maxStackSize && this.infinityMode) {
            this.setChanged();
            return stack.m_255036_(count);
        }
        int taken = Math.min(count, state.count());
        ItemStack result = stack.m_255036_(taken);
        if (taken == state.count()) {
            this.itemMap.remove(key);
            this.updateLastModTime();
        } else {
            this.itemMap.put(key, new ItemState(state.count() - taken, this.updateLastModTime()));
        }
        this.setChanged();
        return result;
    }

    @Override
    public ItemStack addItem(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemKey key = ItemKey.asKey(itemStack);
        ItemState state = (ItemState)this.itemMap.get(key);
        int count = itemStack.m_41613_();
        int original = 0;
        if (state != null) {
            original = state.count();
        }
        if (original < this.maxStackSize) {
            int increased = original + count;
            if (increased <= this.maxStackSize) {
                this.itemMap.put(key, new ItemState(increased, this.updateLastModTime()));
                this.setChanged();
                return ItemStack.f_41583_;
            }
            this.itemMap.put(key, new ItemState(this.maxStackSize, this.updateLastModTime()));
            this.setChanged();
            return itemStack.m_255036_(increased - this.maxStackSize);
        }
        if (this.infinityMode) {
            this.itemMap.put(key, new ItemState(original, this.updateLastModTime()));
            this.setChanged();
            return ItemStack.f_41583_;
        }
        return itemStack.m_41777_();
    }

    @Override
    public void setChanged() {
    }

    @Override
    public long updateLastModTime() {
        return Util.m_137550_();
    }

    public void syncMetadata(EndInvMetadata endInvMetadata) {
        this.maxStackSize = endInvMetadata.maxStackSize();
        this.infinityMode = endInvMetadata.infinityMode();
        this.accessibility = endInvMetadata.config().accessibility();
        this.owner = endInvMetadata.config().owner();
        this.white_list = endInvMetadata.config().white_list();
    }
}

