/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.client.ClientModInfo;
import com.kwwsyk.endinv.common.client.option.IClientConfig;
import com.kwwsyk.endinv.common.network.payloads.SyncedConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;

public final class ClientSyncedConfig {
    private ClientSyncedConfig() {
    }

    public static void readAndSyncClientConfigToServer(boolean ofMenu) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            SyncedConfig config = ClientSyncedConfig.readClientConfig(ofMenu);
            ClientSyncedConfig.updateSyncedConfig(config);
        }
    }

    public static void updateSyncedConfig(SyncedConfig config) {
        IClientConfig clientConfig = ClientModInfo.getClientConfig();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Screen screen;
            int columns;
            int rows = clientConfig.rows().get();
            int syncedRows = config.pageData().rows();
            if (rows == 0) {
                rows = syncedRows;
            }
            if ((columns = clientConfig.columns().get().intValue()) == 0) {
                columns = 9;
            }
            if ((screen = Minecraft.m_91087_().f_91080_) instanceof AbstractContainerScreen) {
                AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
                if (clientConfig.autoSuitColumn().get().booleanValue()) {
                    columns = Math.min(columns, clientConfig.calculateSuitInColumnCount(screen2));
                }
            }
            SyncedConfig config1 = new SyncedConfig(config.pageData().ofRowChanged(rows).ofColumnChanged(columns), config.attaching(), config.autoPicking());
            ModRegistries.NbtAttachments.getSyncedConfig().setTo((Player)player, config1);
            ModInfo.getPacketDistributor().sendToServer(config1);
        }
    }

    public static SyncedConfig readClientConfig(boolean ofMenu) {
        IClientConfig clientConfig = ClientModInfo.getClientConfig();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Screen screen;
            int columns;
            int rows = clientConfig.rows().get();
            if (rows == 0) {
                rows = clientConfig.calculateDefaultRowCount(ofMenu);
            }
            if ((columns = clientConfig.columns().get().intValue()) == 0) {
                columns = 9;
            }
            if ((screen = Minecraft.m_91087_().f_91080_) instanceof AbstractContainerScreen) {
                AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
                if (clientConfig.autoSuitColumn().get().booleanValue()) {
                    columns = Math.min(columns, clientConfig.calculateSuitInColumnCount(screen2));
                }
            }
            SyncedConfig config = ModRegistries.NbtAttachments.getSyncedConfig().getWith((Player)player);
            return new SyncedConfig(config.pageData().ofRowChanged(rows).ofColumnChanged(columns), clientConfig.attaching().get(), true);
        }
        throw new IllegalStateException("Unable to read client config, as running on server or player is not existing.");
    }
}

