/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.event;

import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;

public class AutoPickTipper {
    private static final int MAX_QUEUE_SIZE = 5;
    private static final int DISPLAY_TICKS = 60;
    private static final int MIN_DELAY_BETWEEN_REMOVALS = 10;
    private static final Deque<PickupDisplayItem> pickupQueue = new ArrayDeque<PickupDisplayItem>();
    private static int removalDelayCounter = 0;

    public static void addItem(ItemStack stack) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_12019_, 0.5f, 1.0f);
        }
        for (PickupDisplayItem item : pickupQueue) {
            if (!ItemStack.m_150942_((ItemStack)item.stack, (ItemStack)stack)) continue;
            item.stack.m_41769_(stack.m_41613_());
            item.timeLeft = 60;
            pickupQueue.remove(item);
            pickupQueue.addFirst(item);
            return;
        }
        if (pickupQueue.size() >= 5) {
            pickupQueue.pollLast();
        }
        pickupQueue.addFirst(new PickupDisplayItem(stack.m_41777_(), 60));
    }

    public static void onRenderGui(GuiGraphics guiGraphics) {
        PickupDisplayItem lastItem;
        if (pickupQueue.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ItemRenderer itemRenderer = mc.m_91291_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        int index = 0;
        for (PickupDisplayItem item : pickupQueue) {
            int x = screenWidth - 24;
            int y = screenHeight - 20 - index * 18;
            guiGraphics.m_280480_(item.stack, x, y);
            guiGraphics.m_280370_(Minecraft.m_91087_().f_91062_, item.stack, x, y);
            ++index;
        }
        if (removalDelayCounter > 0) {
            --removalDelayCounter;
        } else if (!pickupQueue.isEmpty() && (lastItem = pickupQueue.peekLast()) != null) {
            --lastItem.timeLeft;
            if (lastItem.timeLeft <= 0) {
                pickupQueue.pollLast();
                removalDelayCounter = 10;
            }
        }
    }

    private static class PickupDisplayItem {
        ItemStack stack;
        int timeLeft;

        public PickupDisplayItem(ItemStack stack, int timeLeft) {
            this.stack = stack;
            this.timeLeft = timeLeft;
        }
    }
}

