/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui;

import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.SourceInventory;
import com.kwwsyk.endinv.common.client.CachedSrcInv;
import com.kwwsyk.endinv.common.client.ClientSyncedConfig;
import com.kwwsyk.endinv.common.client.gui.IScreenEvent;
import com.kwwsyk.endinv.common.client.gui.ScreenFramework;
import com.kwwsyk.endinv.common.client.gui.SortTypeSwitcher;
import com.kwwsyk.endinv.common.client.gui.page.DisplayPage;
import com.kwwsyk.endinv.common.client.gui.page.manager.PageManager;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageQuickMoveHandler;
import com.kwwsyk.endinv.common.network.payloads.PageData;
import com.kwwsyk.endinv.common.util.SortType;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class AttachedScreen<T extends AbstractContainerMenu>
implements SortTypeSwitcher {
    public final AbstractContainerScreen<T> screen;
    private ScreenFramework frameWork;
    private final PageManager pageMetadata = new PageManager(){

        @Override
        public AbstractContainerMenu getMenu() {
            return AttachedScreen.this.screen.m_6262_();
        }

        @Override
        public SourceInventory getSourceInventory() {
            return CachedSrcInv.INSTANCE;
        }

        @Override
        public List<DisplayPage> getPages() {
            return AttachedScreen.this.pages;
        }

        @Override
        public DisplayPage getDisplayingPage() {
            return AttachedScreen.this.displayingPage;
        }

        @Override
        public void switchPageWithIndex(int index) {
            AttachedScreen.this.displayingPage = AttachedScreen.this.pages.get(index);
            ClientSyncedConfig.updateSyncedConfig(ModRegistries.NbtAttachments.getSyncedConfig().getWith(AttachedScreen.this.player).pageKeyChanged(AttachedScreen.this.displayingPage.id));
            AttachedScreen.this.displayingPage.refreshContents();
        }

        @Override
        public int rows() {
            return AttachedScreen.this.rows;
        }

        @Override
        public int columns() {
            return AttachedScreen.this.columns;
        }

        @Override
        public Player getPlayer() {
            return AttachedScreen.this.player;
        }

        @Override
        public int getItemSize() {
            return CachedSrcInv.INSTANCE.getItemSize();
        }

        @Override
        public int getMaxStackSize() {
            return CachedSrcInv.INSTANCE.getMaxItemStackSize();
        }

        @Override
        public boolean enableInfinity() {
            return CachedSrcInv.INSTANCE.isInfinityMode();
        }

        @Override
        public ItemStack quickMoveFromPage(ItemStack stack) {
            return AttachedScreen.this.quickMoveHandler.quickMoveFromPage(stack);
        }

        @Override
        public SortType sortType() {
            return AttachedScreen.this.sortType;
        }

        @Override
        public void setSortType(SortType sortType) {
            AttachedScreen.this.sortType = sortType;
        }

        @Override
        public boolean isSortReversed() {
            return AttachedScreen.this.reverseSort;
        }

        @Override
        public void switchSortReversed() {
            AttachedScreen.this.reverseSort = !AttachedScreen.this.reverseSort;
        }

        @Override
        public void setSortReversed(boolean reversed) {
            AttachedScreen.this.reverseSort = reversed;
        }

        @Override
        public String searching() {
            return AttachedScreen.this.searching;
        }

        @Override
        public void setSearching(String searching) {
            AttachedScreen.this.searching = searching;
        }

        @Override
        public void sendEndInvData() {
        }
    };
    private final PageQuickMoveHandler quickMoveHandler;
    private boolean isHoveringOnSortBox;
    private DisplayPage displayingPage;
    public final List<DisplayPage> pages;
    private final int rows;
    private final int columns;
    public SortType sortType;
    public String searching;
    private final Player player;
    private boolean reverseSort;

    public AttachedScreen(AbstractContainerScreen<T> screen) {
        this.screen = screen;
        this.pages = this.pageMetadata.buildPages();
        assert (Minecraft.m_91087_().f_91074_ != null);
        this.player = Minecraft.m_91087_().f_91074_;
        PageData data = ModRegistries.NbtAttachments.getSyncedConfig().getWith(this.player).pageData();
        this.rows = data.rows();
        this.columns = data.columns();
        this.sortType = data.sortType();
        this.searching = data.search();
        this.pageMetadata.switchPageWithId(data.pageRegKey());
        this.quickMoveHandler = new PageQuickMoveHandler(this.pageMetadata);
    }

    public void init(IScreenEvent event) {
        ScreenFramework screenFramework = this.frameWork = ScreenFramework.getInstance() == null ? new ScreenFramework(this) : ScreenFramework.getInstance();
        if (ScreenFramework.getInstance() != null || ScreenFramework.getInstance() != null) {
            // empty if block
        }
        this.frameWork.addWidgetToScreen(event::addListener);
    }

    public void renderPre(IScreenEvent event) {
        this.isHoveringOnSortBox = false;
    }

    public void render(IScreenEvent event) {
        int mouseX = (int)event.getMouseX();
        int mouseY = (int)event.getMouseY();
        GuiGraphics guiGraphics = event.getGuiGraphics();
        float partialTick = event.getPartialTick();
        this.frameWork.renderBg(guiGraphics, mouseX, mouseY, partialTick);
        this.frameWork.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void mouseClicked(IScreenEvent event) {
        double mouseX = event.getMouseX();
        double mouseY = event.getMouseY();
        int keyCode = event.getButton();
        boolean isActionOverride = this.frameWork.mouseClicked(mouseX, mouseY, keyCode);
        event.setCanceled(isActionOverride);
    }

    public void mouseReleased(IScreenEvent event) {
        double mouseX = event.getMouseX();
        double mouseY = event.getMouseY();
        int keyCode = event.getButton();
        event.setCanceled(this.frameWork.mouseReleased(mouseX, mouseY, keyCode));
    }

    public void mouseDragged(IScreenEvent event) {
        double mouseX = event.getMouseX();
        double mouseY = event.getMouseY();
        int button = event.getMouseButton();
        double dragX = event.getDragX();
        double dragY = event.getDragY();
        event.setCanceled(this.frameWork.mouseDragged(mouseX, mouseY, button, dragX, dragY));
    }

    public void mouseScrolled(IScreenEvent event) {
        double scrollY = event.getScrollDeltaY();
        this.frameWork.mouseScrolled(event.getMouseX(), event.getMouseY(), scrollY);
    }

    public void keyPressed(IScreenEvent event) {
        int keyCode = event.getKeyCode();
        int scanCode = event.getScanCode();
        int modifiers = event.getModifiers();
        event.setCanceled(this.frameWork.keyPressed(keyCode, scanCode, modifiers));
    }

    public void charTyped(IScreenEvent event) {
        char codePoint = event.getCodePoint();
        int modifiers = event.getModifiers();
        event.setCanceled(this.frameWork.charTyped(codePoint, modifiers));
    }

    public void closed(IScreenEvent event) {
        this.frameWork.onClose();
    }

    @Override
    public void switchSortTypeTo(SortType type) {
        this.sortType = type;
        ClientSyncedConfig.updateSyncedConfig(ModRegistries.NbtAttachments.getSyncedConfig().getWith(this.player).sortTypeChanged(type));
        this.pageMetadata.getDisplayingPage().release();
        this.pageMetadata.getDisplayingPage().sendChangesToServer();
    }

    @Override
    public void setHoveringOnSortBox(boolean isHovering) {
        this.isHoveringOnSortBox = isHovering;
    }

    @Override
    public boolean isHoveringOnSortBox() {
        return this.isHoveringOnSortBox;
    }

    @Override
    public PageMetaDataManager getPageManager() {
        return this.pageMetadata;
    }

    @Override
    public AbstractContainerScreen<?> getScreen() {
        return this.screen;
    }

    public ScreenFramework getFrameWork() {
        return this.frameWork;
    }

    public List<Rect2i> getArea() {
        return List.of(new Rect2i(this.frameWork.leftPos, this.frameWork.topPos, this.frameWork.imageWidth, this.frameWork.imageHeight));
    }
}

