/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.client.ClientModInfo;
import com.kwwsyk.endinv.common.client.ClientSyncedConfig;
import com.kwwsyk.endinv.common.client.KeyMappings;
import com.kwwsyk.endinv.common.client.gui.AttachedScreen;
import com.kwwsyk.endinv.common.client.gui.EndInvSettingScreen;
import com.kwwsyk.endinv.common.client.gui.EndlessInventoryScreen;
import com.kwwsyk.endinv.common.client.gui.SortTypeSwitcher;
import com.kwwsyk.endinv.common.client.gui.bg.FromResource;
import com.kwwsyk.endinv.common.client.gui.bg.ScreenBgRenderer;
import com.kwwsyk.endinv.common.client.gui.bg.ScreenRectangleWidgetParam;
import com.kwwsyk.endinv.common.client.gui.bg.Transparent;
import com.kwwsyk.endinv.common.client.gui.page.DisplayPage;
import com.kwwsyk.endinv.common.client.gui.page.ItemPage;
import com.kwwsyk.endinv.common.client.gui.page.manager.ClientPageManager;
import com.kwwsyk.endinv.common.client.gui.page.manager.PageManager;
import com.kwwsyk.endinv.common.client.gui.widget.SortTypeSwitchBox;
import com.kwwsyk.endinv.common.client.option.TextureMode;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import com.kwwsyk.endinv.common.network.payloads.toServer.CreativeItemModPayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.QuickMoveToPagePayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.StarItemPayload;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ScreenFramework {
    private static ScreenFramework INSTANCE;
    private final Minecraft mc;
    public final PageManager meta;
    public final AbstractContainerScreen<?> screen;
    public final AbstractContainerMenu menu;
    private final SortTypeSwitcher sortTypeSwitcher;
    private final ScreenRectangleWidgetParam searchBoxParam;
    private final ScreenRectangleWidgetParam sortBoxParam;
    private final ScreenRectangleWidgetParam configButtonParam;
    private final ScreenRectangleWidgetParam pageBarScrollUpButtonParam;
    private final ScreenRectangleWidgetParam pageBarScrollDownButtonParam;
    public final ScreenBgRenderer screenBgRenderer;
    public final int pageBarCount;
    public int firstPageIndex = 0;
    public final int leftPos;
    public final int topPos;
    public final int imageWidth;
    public final int imageHeight;
    public final int pageX;
    public final int pageY;
    private final int rows;
    private final int columns;
    private final int pageXSize;
    private final int pageYSize;
    private int roughMouseX;
    private int roughMouseY;
    private EditBox searchBox;
    public SortTypeSwitchBox sortTypeSwitchBox;
    private Button reverseSortButton;
    private Button configButton;
    private final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
    private boolean isHoveringOnPage;
    private ItemStack creativeQuickInsertedItem = ItemStack.f_41583_;
    private boolean ignoreTextInput;

    public ScreenFramework(EndlessInventoryScreen screen) {
        PageManager pageManager;
        this.screen = screen;
        this.mc = Minecraft.m_91087_();
        PageMetaDataManager delegate = screen.getPageManager();
        if (delegate instanceof PageManager) {
            PageManager pm = (PageManager)delegate;
            pageManager = pm;
        } else {
            pageManager = new ClientPageManager(delegate);
        }
        this.meta = pageManager;
        this.menu = screen.m_6262_();
        this.leftPos = screen.getGuiLeft();
        this.topPos = screen.getGuiTop();
        this.imageWidth = screen.getXSize();
        this.imageHeight = screen.getYSize();
        this.rows = this.meta.rows();
        this.columns = this.meta.columns();
        this.sortTypeSwitcher = screen;
        this.pageBarCount = Math.min(ClientModInfo.getClientConfig().maxPageBarCount().get(), this.meta.getPages().size());
        this.pageBarScrollUpButtonParam = new ScreenRectangleWidgetParam(this.leftPos - 32, this.topPos - 16, 30, 14);
        this.pageBarScrollDownButtonParam = new ScreenRectangleWidgetParam(this.leftPos - 32, this.topPos + 2 + 28 * this.pageBarCount, 30, 14);
        this.configButtonParam = new ScreenRectangleWidgetParam(this.leftPos + this.imageWidth, Math.min(this.topPos + this.imageHeight, screen.f_96544_ - 20), 18, 18);
        this.searchBoxParam = new ScreenRectangleWidgetParam(this.leftPos + 89, this.topPos + 5, 80, 12);
        this.sortBoxParam = new ScreenRectangleWidgetParam(this.leftPos + 8, this.topPos + 5, 60, 12);
        this.screenBgRenderer = new FromResource.MenuMode(this, new ScreenRectangleWidgetParam(this.leftPos - 32, this.topPos + 1, 32, 28));
        this.pageX = this.leftPos + 8;
        this.pageY = this.topPos + 17;
        this.pageXSize = this.columns * 18;
        this.pageYSize = this.rows * 18;
        this.addWidgets();
        INSTANCE = this;
    }

    public ScreenFramework(AttachedScreen<?> attachedScreen) {
        PageManager pageManager;
        this.screen = attachedScreen.screen;
        this.mc = Minecraft.m_91087_();
        PageMetaDataManager delegate = attachedScreen.getPageManager();
        if (delegate instanceof PageManager) {
            PageManager pm = (PageManager)delegate;
            pageManager = pm;
        } else {
            pageManager = new ClientPageManager(delegate);
        }
        this.meta = pageManager;
        this.menu = this.meta.getMenu();
        this.leftPos = 20;
        this.rows = this.meta.rows();
        this.topPos = Math.max((this.screen.f_96544_ - this.rows * 18 - 17 - 10) / 2, 20);
        this.columns = this.meta.columns();
        this.sortTypeSwitcher = attachedScreen;
        this.pageBarCount = Math.min(ClientModInfo.getClientConfig().maxPageBarCount().get(), this.meta.getPages().size());
        this.imageWidth = 13 + 18 * this.columns;
        this.imageHeight = this.screen.f_96544_;
        int searchBoxY = this.topPos + 17 + 18 * this.rows + 12;
        this.searchBoxParam = new ScreenRectangleWidgetParam(this.leftPos + 1, searchBoxY, Math.min(200, this.imageWidth), Math.min(20, this.screen.f_96544_ - searchBoxY));
        this.configButtonParam = new ScreenRectangleWidgetParam(0, Math.min(searchBoxY, this.screen.f_96544_ - 20), 20, 20);
        this.pageBarScrollUpButtonParam = new ScreenRectangleWidgetParam(0, this.topPos, 20, 14);
        this.pageBarScrollDownButtonParam = new ScreenRectangleWidgetParam(0, this.topPos + 22 + 28 * this.pageBarCount, 20, 14);
        this.sortBoxParam = new ScreenRectangleWidgetParam(this.leftPos + 6, this.topPos + 5, 77, 12);
        this.screenBgRenderer = ClientModInfo.getClientConfig().textureMode().get() == TextureMode.FROM_RESOURCE ? new FromResource.LeftLayout(this, new ScreenRectangleWidgetParam(this.leftPos - 32, this.topPos + 20, 32, 28)) : new Transparent(this, new ScreenRectangleWidgetParam(this.leftPos - 32, this.topPos + 20, 32, 28));
        this.pageX = this.leftPos + 8;
        this.pageY = this.topPos + 17;
        this.pageXSize = this.columns * 18;
        this.pageYSize = this.rows * 18;
        this.addWidgets();
        INSTANCE = this;
    }

    private void addWidgets() {
        this.configButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2699"), btn -> this.mc.m_91152_((Screen)new EndInvSettingScreen((Screen)this.screen))).m_252794_(this.configButtonParam.XPos(), this.configButtonParam.YPos()).m_253046_(this.configButtonParam.XSize(), this.configButtonParam.YSize()).m_253136_();
        this.reverseSortButton = Button.m_253074_((Component)Component.m_237113_((String)"\u21c5"), btn -> {
            this.meta.switchSortReversed();
            ClientSyncedConfig.updateSyncedConfig(ModRegistries.NbtAttachments.getSyncedConfig().getWith(this.meta.getPlayer()).ofReverseSort());
            this.meta.getDisplayingPage().sendChangesToServer();
        }).m_252794_(this.sortBoxParam.XPos() + this.sortBoxParam.XSize() + 2, this.sortBoxParam.YPos()).m_253046_(this.sortBoxParam.YSize(), this.sortBoxParam.YSize()).m_253136_();
        this.searchBox = new EditBox(this.mc.f_91062_, this.searchBoxParam.XPos(), this.searchBoxParam.YPos(), this.searchBoxParam.XSize(), this.searchBoxParam.YSize(), (Component)Component.m_237115_((String)"itemGroup.search"));
        this.sortTypeSwitchBox = new SortTypeSwitchBox(this.sortTypeSwitcher, this.sortBoxParam);
        this.searchBox.m_94144_(this.meta.searching());
        if (this.pageBarCount < this.meta.getPages().size()) {
            Button up = Button.m_253074_((Component)Component.m_237113_((String)"^"), btn -> {
                if (this.firstPageIndex > 0) {
                    --this.firstPageIndex;
                }
            }).m_252794_(this.pageBarScrollUpButtonParam.XPos(), this.pageBarScrollUpButtonParam.YPos()).m_253046_(this.pageBarScrollUpButtonParam.XSize(), this.pageBarScrollUpButtonParam.YSize()).m_253136_();
            Button down = Button.m_253074_((Component)Component.m_237113_((String)"v"), btn -> {
                if (this.firstPageIndex + this.pageBarCount < this.meta.getPages().size()) {
                    ++this.firstPageIndex;
                }
            }).m_252794_(this.pageBarScrollDownButtonParam.XPos(), this.pageBarScrollDownButtonParam.YPos()).m_253046_(this.pageBarScrollDownButtonParam.XSize(), this.pageBarScrollDownButtonParam.YSize()).m_253136_();
            this.widgets.add((AbstractWidget)up);
            this.widgets.add((AbstractWidget)down);
        }
        this.widgets.add((AbstractWidget)this.configButton);
        this.widgets.add((AbstractWidget)this.reverseSortButton);
        this.widgets.add((AbstractWidget)this.searchBox);
        this.widgets.add(this.sortTypeSwitchBox);
    }

    public void addWidgetToScreen(Consumer<AbstractWidget> installer) {
        this.widgets.forEach(installer);
    }

    public void renderPre(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.sortTypeSwitcher.setHoveringOnSortBox(false);
    }

    public void renderBg(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.screenBgRenderer.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        this.meta.getDisplayingPage().renderBg(this.screenBgRenderer, guiGraphics, partialTick, mouseX, mouseY);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.roughMouseX = mouseX;
        this.roughMouseY = mouseY;
        this.isHoveringOnPage = this.hasClickedOnPage(mouseX, mouseY);
        this.meta.getDisplayingPage().initRenderer(this, this.pageX, this.pageY);
        this.meta.getDisplayingPage().render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.searchBox.m_274382_() && !this.searchBox.m_93696_()) {
            guiGraphics.m_280677_(this.mc.f_91062_, List.of(Component.m_237115_((String)"search.endinv.prefix.sharp"), Component.m_237115_((String)"search.endinv.prefix.at"), Component.m_237115_((String)"search.endinv.prefix.xor"), Component.m_237115_((String)"search.endinv.prefix.star")), Optional.empty(), mouseX, mouseY);
        }
        if (this.reverseSortButton.m_274382_()) {
            guiGraphics.m_280557_(this.mc.f_91062_, (Component)Component.m_237115_((String)"button.endinv.reverse"), mouseX, mouseY);
        }
    }

    protected boolean hasClickedOnPage(double mouseX, double mouseY) {
        return mouseX >= (double)this.pageX && mouseX <= (double)this.pageX + (double)this.pageXSize && mouseY >= (double)this.pageY && mouseY <= (double)this.pageY + (double)this.pageYSize && !this.sortTypeSwitcher.isHoveringOnSortBox();
    }

    protected int hasClickedOnPageSwitchBar(double mouseX, double mouseY) {
        double XOffset = mouseX - (double)this.screenBgRenderer.pageSwitchBarParam().XPos();
        double YOffset = mouseY - (double)this.screenBgRenderer.pageSwitchBarParam().YPos();
        if (XOffset < 0.0 || XOffset > (double)this.screenBgRenderer.pageSwitchBarParam().XSize() || YOffset < 0.0) {
            return -1;
        }
        int index = (int)YOffset / this.screenBgRenderer.pageSwitchBarParam().YSize();
        if (index < 0 || index >= this.pageBarCount) {
            return -1;
        }
        return index;
    }

    protected void pageSwitched(int index) {
        this.meta.switchPageWithIndex(index + this.firstPageIndex);
        this.searchBox.m_94194_(this.meta.getDisplayingPage().hasSearchbox());
        this.sortTypeSwitchBox.f_93624_ = this.meta.getDisplayingPage().hasSortTypeSwitchBar();
    }

    private boolean isHovering(Slot slot, double mouseX, double mouseY) {
        return this.isHovering(slot.f_40220_, slot.f_40221_, 16, 16, mouseX, mouseY);
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        int i = ClientModInfo.containerScreenHelper.getGuiLeft(this.screen);
        int j = ClientModInfo.containerScreenHelper.getGuiTop(this.screen);
        return (mouseX -= (double)i) >= (double)(x - 1) && mouseX < (double)(x + width + 1) && (mouseY -= (double)j) >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    public boolean notHoveringOnSortBox() {
        return !this.sortTypeSwitcher.isHoveringOnSortBox();
    }

    @Nullable
    private Slot findSlot(double mouseX, double mouseY) {
        for (int i = 0; i < this.menu.f_38839_.size(); ++i) {
            Slot slot = (Slot)this.menu.f_38839_.get(i);
            if (!this.isHovering(slot, mouseX, mouseY) || !slot.m_6659_()) continue;
            return slot;
        }
        return null;
    }

    private void slotQuickMoved(Slot clicked) {
        ItemStack itemStack = clicked.m_7993_().m_41777_();
        if (this.menu instanceof CreativeModeInventoryScreen.ItemPickerMenu && clicked.f_40219_ < 45 && this.menu.f_38839_.size() >= 54) {
            if (ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)this.creativeQuickInsertedItem)) {
                return;
            }
            this.creativeQuickInsertedItem = itemStack;
            itemStack.m_41764_(itemStack.m_41741_());
            this.meta.getDisplayingPage().tryQuickMoveStackTo(itemStack);
            ModInfo.getPacketDistributor().sendToServer(new CreativeItemModPayload(itemStack, true));
        } else {
            ItemStack remain = this.meta.getDisplayingPage().tryQuickMoveStackTo(itemStack);
            clicked.m_269060_(remain);
            clicked.m_142406_(this.meta.getPlayer(), itemStack);
            ModInfo.getPacketDistributor().sendToServer(new QuickMoveToPagePayload(clicked.f_40219_));
        }
        DisplayPage displayPage = this.meta.getDisplayingPage();
        if (displayPage instanceof ItemPage) {
            ItemPage itemPage = (ItemPage)displayPage;
            itemPage.requestContents();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int keyCode) {
        Slot clicked;
        if (!this.searchBoxParam.hasClickedOn((int)mouseX, (int)mouseY)) {
            this.searchBox.m_93692_(false);
        } else {
            this.searchBox.m_93692_(true);
            if (keyCode == 1) {
                this.searchBox.m_94144_("");
                this.refreshSearchResults();
                return true;
            }
        }
        boolean flg = ClientModInfo.inputHandler.isActiveAndMatches(KeyMappings.QUICK_MOVE, InputConstants.Type.MOUSE.m_84895_(keyCode));
        if (flg && (clicked = this.findSlot(mouseX, mouseY)) != null && clicked.m_6657_()) {
            this.slotQuickMoved(clicked);
            return true;
        }
        int pageIndex = this.hasClickedOnPageSwitchBar(mouseX, mouseY);
        if (pageIndex >= 0) {
            this.pageSwitched(pageIndex);
            return true;
        }
        if (this.hasClickedOnPage(mouseX, mouseY)) {
            this.sortTypeSwitchBox.setOpen(false);
            return this.meta.getDisplayingPage().mouseClicked(mouseX - (double)this.pageX, mouseY - (double)this.pageY, keyCode);
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        Slot clicked;
        ItemStack itemstack = this.menu.m_142621_();
        if (!itemstack.m_41619_() || ((Boolean)this.mc.f_91066_.m_231828_().m_231551_()).booleanValue()) {
            return false;
        }
        if (ClientModInfo.inputHandler.isActiveAndMatches(KeyMappings.QUICK_MOVE, InputConstants.Type.MOUSE.m_84895_(button)) && (clicked = this.findSlot(mouseX, mouseY)) != null && clicked.m_6657_()) {
            this.slotQuickMoved(clicked);
            return true;
        }
        if (this.hasClickedOnPage(mouseX, mouseY)) {
            return this.meta.getDisplayingPage().mouseDragged(mouseX - (double)this.pageX, mouseY - (double)this.pageY, button, dragX, dragY);
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int keyCode) {
        this.creativeQuickInsertedItem = ItemStack.f_41583_;
        DisplayPage displayingPage = this.meta.getDisplayingPage();
        displayingPage.release();
        if (this.hasClickedOnPage(mouseX, mouseY)) {
            return displayingPage.mouseReleased(mouseX - (double)this.pageX, mouseY - (double)this.pageY, keyCode);
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollY) {
        if (this.hasClickedOnPage(mouseX, mouseY)) {
            mouseY = this.pageY;
            return this.meta.getDisplayingPage().mouseScrolled(mouseX - (double)this.pageX, mouseY, scrollY);
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        Slot clicked;
        this.ignoreTextInput = false;
        if (ClientModInfo.inputHandler.isActiveAndMatches(KeyMappings.STAR_ITEM, InputConstants.m_84827_((int)keyCode, (int)scanCode)) && (clicked = this.findSlot(this.roughMouseX, this.roughMouseY)) != null && clicked.m_6657_()) {
            ItemStack itemStack = clicked.m_7993_();
            ModInfo.getPacketDistributor().sendToServer(new StarItemPayload(itemStack, true));
            this.meta.getDisplayingPage().sendChangesToServer();
            return true;
        }
        boolean flag = false;
        if (this.isHoveringOnPage) {
            flag = this.meta.getDisplayingPage().keyPressed(keyCode, scanCode, modifiers, this.roughMouseX - this.pageX, this.roughMouseY - this.pageY);
        }
        if (flag) {
            this.ignoreTextInput = true;
            return true;
        }
        if (this.meta.getDisplayingPage().hasSearchbox() && this.searchBox.m_93696_()) {
            String s = this.searchBox.m_94155_();
            if (this.searchBox.m_7933_(keyCode, scanCode, modifiers)) {
                if (!Objects.equals(s, this.searchBox.m_94155_())) {
                    this.refreshSearchResults();
                }
                return true;
            }
            return this.searchBox.m_93696_() && this.searchBox.m_94213_() && keyCode != 256;
        }
        return false;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.ignoreTextInput || !this.meta.getDisplayingPage().hasSearchbox()) {
            return false;
        }
        String s = this.searchBox.m_94155_();
        if (this.searchBox.m_5534_(codePoint, modifiers)) {
            if (!Objects.equals(s, this.searchBox.m_94155_())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return false;
    }

    public void onClose() {
        INSTANCE = null;
    }

    public void refreshSearchResults() {
        String searching = this.searchBox.m_94155_();
        this.meta.setSearching(searching);
        ClientSyncedConfig.updateSyncedConfig(ModRegistries.NbtAttachments.getSyncedConfig().getWith(this.meta.getPlayer()).searchingChanged(searching));
        this.meta.getDisplayingPage().release();
        this.meta.getDisplayingPage().sendChangesToServer();
    }

    @Nullable
    public static ScreenFramework getInstance() {
        return INSTANCE;
    }
}

