/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui.bg;

import com.kwwsyk.endinv.common.client.gui.ScreenFramework;
import com.kwwsyk.endinv.common.client.gui.bg.ScreenBgRenderer;
import com.kwwsyk.endinv.common.client.gui.bg.ScreenBgRendererImpl;
import com.kwwsyk.endinv.common.client.gui.bg.ScreenRectangleWidgetParam;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class FromResource
extends ScreenBgRendererImpl {
    private static final ResourceLocation CONTAINER_TEXTURE_LOCATION = new ResourceLocation("minecraft", "textures/gui/container/generic_54.png");
    private static final ResourceLocation TABS = new ResourceLocation("minecraft", "textures/gui/advancements/tabs.png");

    public FromResource(ScreenFramework frameWork) {
        super(frameWork);
    }

    @Override
    public Optional<ScreenBgRenderer.BgRenderer> getDefaultPageBgRenderer() {
        return Optional.of(new GridPageRenderer());
    }

    @Override
    public void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int pageX = this.pageSwitchTabParam.XPos();
        int pageY = this.pageSwitchTabParam.YPos();
        int selectedPageIndex = this.manager.getDisplayingPageIndex();
        for (int i = this.frameWork.firstPageIndex; i < this.frameWork.firstPageIndex + this.frameWork.pageBarCount; ++i) {
            if (i == selectedPageIndex) {
                if (i == 0) {
                    guiGraphics.m_280218_(TABS, pageX, pageY, 0, 92, 32, 28);
                } else if (i == this.frameWork.firstPageIndex + this.frameWork.pageBarCount - 1) {
                    guiGraphics.m_280218_(TABS, pageX, pageY, 32, 91, 32, 29);
                } else {
                    guiGraphics.m_280218_(TABS, pageX, pageY, 64, 91, 32, 28);
                }
            } else {
                guiGraphics.m_280218_(TABS, pageX + 8, pageY, 4, 64, 24, 27);
            }
            pageY += 28;
        }
        this.renderPageBarContent(guiGraphics, partialTick, mouseX, mouseY);
    }

    public class GridPageRenderer
    implements ScreenBgRenderer.BgRenderer {
        @Override
        public void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
            int startX = FromResource.this.pageLeft;
            int startY = FromResource.this.pageTop;
            if (FromResource.this.columns != 9) {
                this.renderSpecialBg(guiGraphics, partialTick, mouseX, mouseY, startX, startY);
            } else {
                guiGraphics.m_280163_(CONTAINER_TEXTURE_LOCATION, startX, startY, 0.0f, 0.0f, FromResource.this.imageWidth, 17, 256, 256);
                startY += 17;
                int rowsToRender = FromResource.this.rows;
                while (rowsToRender > 0) {
                    int height = 18 * Math.min(rowsToRender, 6);
                    guiGraphics.m_280163_(CONTAINER_TEXTURE_LOCATION, startX, startY, 0.0f, 17.0f, FromResource.this.imageWidth, height, 256, 256);
                    rowsToRender -= 6;
                    startY += height;
                }
                guiGraphics.m_280163_(CONTAINER_TEXTURE_LOCATION, startX, FromResource.this.pageTop + 17 + 18 * FromResource.this.rows, 0.0f, 124.0f, FromResource.this.imageWidth, 12, 256, 256);
            }
        }

        private void renderSpecialBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY, int startX, int startY) {
            int width;
            int columnsToRender;
            int initialX = startX;
            guiGraphics.m_280163_(CONTAINER_TEXTURE_LOCATION, startX, startY, 0.0f, 0.0f, 7, 17, 256, 256);
            startX += 7;
            for (columnsToRender = FromResource.this.columns; columnsToRender > 0; columnsToRender -= 9) {
                width = 18 * Math.min(9, columnsToRender);
                guiGraphics.m_280163_(CONTAINER_TEXTURE_LOCATION, startX, startY, 7.0f, 0.0f, width, 17, 256, 256);
                startX += width;
            }
            guiGraphics.m_280163_(CONTAINER_TEXTURE_LOCATION, startX, startY, 168.0f, 0.0f, 8, 17, 256, 256);
            startX = initialX;
            startY += 17;
            for (int rowsToRender = FromResource.this.rows; rowsToRender > 0; rowsToRender -= 6) {
                int height = 18 * Math.min(rowsToRender, 6);
                guiGraphics.m_280163_(CONTAINER_TEXTURE_LOCATION, startX, startY, 0.0f, 17.0f, 7, height, 256, 256);
                startX += 7;
                for (int columnsToRender2 = FromResource.this.columns; columnsToRender2 > 0; columnsToRender2 -= 9) {
                    int width2 = 18 * Math.min(9, columnsToRender2);
                    guiGraphics.m_280163_(CONTAINER_TEXTURE_LOCATION, startX, startY, 7.0f, 17.0f, width2, height, 256, 256);
                    startX += width2;
                }
                guiGraphics.m_280163_(CONTAINER_TEXTURE_LOCATION, startX, startY, 168.0f, 17.0f, 8, height, 256, 256);
                startX = initialX;
                startY += height;
            }
            guiGraphics.m_280163_(CONTAINER_TEXTURE_LOCATION, startX, startY, 0.0f, 124.0f, 7, 12, 256, 256);
            startX += 7;
            for (columnsToRender = FromResource.this.columns; columnsToRender > 0; columnsToRender -= 9) {
                width = 18 * Math.min(9, columnsToRender);
                guiGraphics.m_280163_(CONTAINER_TEXTURE_LOCATION, startX, startY, 7.0f, 124.0f, width, 12, 256, 256);
                startX += width;
            }
            guiGraphics.m_280163_(CONTAINER_TEXTURE_LOCATION, startX, startY, 168.0f, 124.0f, 8, 12, 256, 256);
            startX = initialX;
        }
    }

    public static class LeftLayout
    extends FromResource {
        public LeftLayout(ScreenFramework frameWork, ScreenRectangleWidgetParam pageSwitchTabParam) {
            super(frameWork);
            this.pageSwitchTabParam = pageSwitchTabParam;
        }
    }

    public static class MenuMode
    extends FromResource {
        public MenuMode(ScreenFramework frameWork, ScreenRectangleWidgetParam pageSwitchTabParam) {
            super(frameWork);
            this.pageSwitchTabParam = pageSwitchTabParam;
        }

        @Override
        public void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
            super.renderBg(guiGraphics, partialTick, mouseX, mouseY);
            int startY = this.menuTop + 17 + this.rows * 18;
            this.renderPlayerInv(guiGraphics, partialTick, mouseX, mouseY, this.menuLeft, startY);
        }

        private void renderPlayerInv(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY, int startX, int startY) {
            guiGraphics.m_280163_(CONTAINER_TEXTURE_LOCATION, startX, startY, 0.0f, 126.0f, this.imageWidth, 96, 256, 256);
        }
    }
}

