/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui.bg;

import com.kwwsyk.endinv.common.client.ClientModInfo;
import com.kwwsyk.endinv.common.client.gui.ScreenFramework;
import com.kwwsyk.endinv.common.client.gui.bg.ScreenBgRenderer;
import com.kwwsyk.endinv.common.client.gui.bg.ScreenRectangleWidgetParam;
import com.kwwsyk.endinv.common.client.gui.page.manager.PageManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;

public abstract class ScreenBgRendererImpl
implements ScreenBgRenderer {
    protected final ScreenFramework frameWork;
    protected final int menuLeft;
    protected final int menuTop;
    protected final int pageLeft;
    protected final int pageTop;
    protected final AbstractContainerScreen<?> screen;
    public ScreenRectangleWidgetParam pageSwitchTabParam;
    protected final int imageWidth;
    protected final int rows;
    protected final int columns;
    protected final PageManager manager;

    public ScreenBgRendererImpl(ScreenFramework frameWork) {
        this.frameWork = frameWork;
        this.screen = frameWork.screen;
        this.imageWidth = 256;
        this.manager = frameWork.meta;
        this.rows = this.manager.rows();
        this.columns = this.manager.columns();
        this.menuLeft = ClientModInfo.containerScreenHelper.getGuiLeft(this.screen);
        this.menuTop = ClientModInfo.containerScreenHelper.getGuiTop(this.screen);
        this.pageLeft = frameWork.leftPos;
        this.pageTop = frameWork.topPos;
    }

    protected void renderPageBarContent(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int pageX = this.pageSwitchTabParam.XPos();
        int pageY = this.pageSwitchTabParam.YPos();
        int selectedPageIndex = this.manager.getDisplayingPageIndex();
        for (int i = this.frameWork.firstPageIndex; i < this.frameWork.firstPageIndex + this.frameWork.pageBarCount; ++i) {
            this.manager.getPages().get(i).renderPageIcon(guiGraphics, pageX + 15, pageY + 5, partialTick);
            if (mouseX > pageX && mouseX < pageX + 32 && mouseY > pageY && mouseY < pageY + 28) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 550.0f);
                guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, this.manager.getPages().get((int)i).name, mouseX, mouseY);
                guiGraphics.m_280168_().m_85849_();
            }
            pageY += 28;
        }
    }

    @Override
    public ScreenRectangleWidgetParam pageSwitchBarParam() {
        return this.pageSwitchTabParam;
    }

    @Override
    public ScreenFramework getScreenFrameWork() {
        return this.frameWork;
    }
}

