/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui.page;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.SourceInventory;
import com.kwwsyk.endinv.common.client.CachedSrcInv;
import com.kwwsyk.endinv.common.client.gui.EndlessInventoryScreen;
import com.kwwsyk.endinv.common.client.gui.page.DisplayPage;
import com.kwwsyk.endinv.common.menu.page.PageType;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import com.kwwsyk.endinv.common.network.payloads.toServer.CreativeItemModPayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.ItemClickPayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.ItemPageContext;
import com.kwwsyk.endinv.common.network.payloads.toServer.StarItemPayload;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public abstract class ItemPage
extends DisplayPage {
    protected NonNullList<ItemStack> items;
    protected int startIndex = 0;
    protected int length = this.meta.rows() * this.meta.columns();
    protected boolean suppressRefresh = false;
    protected List<ItemStack> inQueueStacks = null;

    public void extend(int rows) {
        this.length = rows * this.meta.columns();
        this.refreshContents(this.startIndex, this.length);
    }

    public void contract(int rows) {
        int newLength = rows * this.meta.columns();
        this.length = Math.max(newLength, this.meta.columns());
        this.refreshContents(this.startIndex, this.length);
    }

    public ItemPage(PageType pageType, PageMetaDataManager metaDataManager) {
        super(pageType, metaDataManager);
    }

    @Override
    public void scrollTo(float pos) {
        int startIndex = this.getRowIndexForScroll(pos) * this.meta.columns();
        this.refreshContents(startIndex, this.length);
    }

    @Override
    public void refreshContents() {
        this.refreshContents(0, this.meta.rows() * this.meta.columns());
    }

    public void refreshContents(int startIndex, int length) {
        this.startIndex = startIndex;
        this.length = Math.min(length, this.meta.rows() * this.meta.columns());
        if (this.items == null || this.items.size() != this.length) {
            this.items = NonNullList.m_122780_((int)this.length, (Object)ItemStack.f_41583_);
        }
        if (this.items == null || length != this.items.size()) {
            this.items = NonNullList.m_122780_((int)length, (Object)ItemStack.f_41583_);
        }
        this.release();
        this.refreshItems();
    }

    public abstract void refreshItems();

    public void tryRequestContents() {
        if (!this.suppressRefresh) {
            this.requestContents();
        }
    }

    public abstract void requestContents();

    public void initializeContents(@NotNull List<ItemStack> stacks) {
        if (this.holdOn) {
            this.inQueueStacks = stacks;
            return;
        }
        for (int i = 0; i < this.length; ++i) {
            if (i < stacks.size() && stacks.get(i) != null) {
                ((ItemStack)this.items.set(i, (Object)stacks.get(i))).m_41777_();
                continue;
            }
            this.items.set(i, (Object)ItemStack.f_41583_);
        }
    }

    public void initializeContents(CachedSrcInv srcInv) {
        List<ItemStack> view = srcInv.getSortedAndFilteredItemView(this.startIndex, this.length, this.meta.sortType(), this.meta.isSortReversed(), this.getClassify(), this.meta.searching());
        this.initializeContents(view);
    }

    @Override
    public void sendChangesToServer() {
        ModInfo.getPacketDistributor().sendToServer(new ItemPageContext(this.startIndex, this.length, ModRegistries.NbtAttachments.getSyncedConfig().getWith(this.meta.getPlayer()).pageData()));
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public boolean isEmpty() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    @Override
    public void setChanged() {
        this.suppressRefresh = false;
    }

    @Override
    public boolean canScroll() {
        CachedSrcInv cache;
        SourceInventory sourceInventory;
        return this.startIndex > 0 || ((sourceInventory = this.srcInv) instanceof CachedSrcInv ? this.startIndex + this.length <= (cache = (CachedSrcInv)sourceInventory).getSortedAndFilteredItemView(0, Integer.MAX_VALUE, this.meta.sortType(), this.meta.isSortReversed(), this.getClassify(), this.meta.searching()).size() : this.startIndex + this.length < this.meta.getItemSize());
    }

    @Override
    public int getSlotForMouseOffset(double XOffset, double YOffset) {
        if (XOffset < 0.0 || YOffset < 0.0 || XOffset > (double)(18 * this.meta.columns()) || YOffset > (double)(18 * this.meta.rows())) {
            return -1;
        }
        return (int)XOffset / 18 + this.meta.columns() * ((int)YOffset / 18);
    }

    @Override
    public void release() {
        if (this.holdOn) {
            this.holdOn = false;
            if (this.inQueueStacks == null) {
                return;
            }
            this.initializeContents(this.inQueueStacks);
        }
    }

    @Override
    public void handleStarItem(double XOffset, double YOffset) {
        int slot = this.getSlotForMouseOffset(XOffset, YOffset);
        if (slot >= 0 && slot < this.items.size()) {
            ItemStack clicked = (ItemStack)this.items.get(slot);
            if (clicked.m_41619_()) {
                return;
            }
            ModInfo.getPacketDistributor().sendToServer(new StarItemPayload(clicked, true));
        }
    }

    @Override
    public void renderPage(GuiGraphics guiGraphics) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        int rowIndex = 0;
        int columnIndex = 0;
        for (ItemStack stack : this.items) {
            if (stack.m_41619_() && !stack.m_150930_(Items.f_41852_)) {
                this.renderEmpty(guiGraphics, this.leftPos + columnIndex * 18, this.topPos + rowIndex * 18 + 1, stack);
            }
            guiGraphics.m_280256_(stack, this.leftPos + columnIndex * 18, this.topPos + rowIndex * 18 + 1, columnIndex + rowIndex * 180);
            if (!this.isHiddenBySortBox(rowIndex, columnIndex)) {
                guiGraphics.m_280302_(Minecraft.m_91087_().f_91062_, stack, this.leftPos + columnIndex * 18, this.topPos + rowIndex * 18 + 1, this.getDisplayAmount(stack));
            }
            if (++columnIndex < this.meta.columns()) continue;
            columnIndex = 0;
            ++rowIndex;
        }
        guiGraphics.m_280168_().m_85849_();
    }

    protected void renderEmpty(GuiGraphics guiGraphics, int x, int y, ItemStack itemStack) {
        ItemStack toRender = itemStack.m_255036_(1);
        guiGraphics.m_280256_(toRender, x, y, 0);
        guiGraphics.m_280302_(Minecraft.m_91087_().f_91062_, toRender, x, y, String.valueOf(ChatFormatting.RED) + "0");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isHiddenBySortBox(int rowIndex, int columnIndex) {
        if (rowIndex > 2) return false;
        if (columnIndex > 3) return false;
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (!(screen instanceof AbstractContainerScreen)) return false;
        AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
        if (screen2 instanceof EndlessInventoryScreen) {
            EndlessInventoryScreen EIS = (EndlessInventoryScreen)screen2;
            if (EIS.getFrameWork().sortTypeSwitchBox.isOpen()) {
                if (columnIndex <= 2) return true;
            }
        }
        if (!this.framework.sortTypeSwitchBox.isOpen()) return false;
        return true;
    }

    protected String getDisplayAmount(ItemStack stack) {
        String suffix;
        double value;
        int count = stack.m_41613_();
        if (count == this.meta.getMaxStackSize() && this.meta.enableInfinity()) {
            return "\u221e";
        }
        if (count >= 1000000000) {
            value = (double)count / 1.0E9;
            suffix = "b";
        } else if (count >= 1000000) {
            value = (double)count / 1000000.0;
            suffix = "m";
        } else if (count >= 1000) {
            value = (double)count / 1000.0;
            suffix = "k";
        } else {
            if (count == 0) {
                return String.valueOf(ChatFormatting.RED) + "0";
            }
            return String.valueOf(count);
        }
        return String.format("%.1f%s", value, suffix);
    }

    @Override
    public void renderHovering(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderSlotHighlight(graphics, mouseX, mouseY, partialTick);
        int hoveringSlot = this.getSlotForMouseOffset(mouseX - this.leftPos, mouseY - this.topPos);
        if (hoveringSlot >= 0 && hoveringSlot < this.items.size()) {
            ItemStack hovering = (ItemStack)this.items.get(hoveringSlot);
            if (hovering.m_41619_()) {
                return;
            }
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 550.0f);
            graphics.m_280677_(Minecraft.m_91087_().f_91062_, AbstractContainerScreen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)hovering), hovering.m_150921_(), mouseX, mouseY);
            graphics.m_280168_().m_85849_();
        }
    }

    protected void renderSlotHighlight(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        for (int u = 0; u < this.meta.columns(); ++u) {
            for (int v = 0; v < this.meta.rows(); ++v) {
                int x1 = this.leftPos + 18 * u - 1;
                int x2 = this.leftPos + 18 * u + 16;
                int y1 = this.topPos + 18 * v + 1;
                int y2 = this.topPos + 18 * v + 18;
                if (mouseX <= x1 || mouseX >= x2 || mouseY <= y1 || mouseY >= y2) continue;
                if (!this.meta.getMenu().m_142621_().m_41619_()) {
                    return;
                }
                graphics.m_285978_(RenderType.m_286086_(), x1, y1, x2, y2, -2130706433, -2130706433, 0);
            }
        }
    }

    @Override
    public boolean doubleClickedOnOne(double XOffset, double YOffset, double lastX, double lastY, long clickInterval) {
        return this.clickedInOneSlot(XOffset, YOffset, lastX, lastY) && clickInterval <= 250L;
    }

    protected boolean clickedInOneSlot(double XOffset, double YOffset, double lastX, double lastY) {
        return (int)XOffset / 18 == (int)lastX / 18 && (int)YOffset / 18 == (int)lastY / 18;
    }

    @Override
    public void pageClicked(double XOffset, double YOffset, int button, ClickType clickType) {
        int slot = this.getSlotForMouseOffset(XOffset, YOffset);
        if (slot >= 0 && slot < this.items.size()) {
            ItemStack clicked = ((ItemStack)this.items.get(slot)).m_41777_();
            switch (clickType) {
                case PICKUP: {
                    this.handlePickup(clicked, button);
                    break;
                }
                case QUICK_MOVE: {
                    this.handleQuickMove(clicked);
                    break;
                }
                case SWAP: {
                    this.handleSwap(clicked, button);
                    break;
                }
                case THROW: {
                    this.handleThrow(clicked);
                    break;
                }
                case PICKUP_ALL: {
                    this.handlePickupAll(clicked);
                    break;
                }
                case CLONE: {
                    this.handleClone(clicked);
                    break;
                }
            }
            ModInfo.getPacketDistributor().sendToServer(new ItemClickPayload(clicked.m_41613_() > 64 ? clicked.m_255036_(64) : clicked.m_41777_(), button, clickType));
            this.refreshItems();
        }
    }

    public ItemStack takeItem(ItemStack itemStack) {
        return this.takeItem(itemStack, itemStack.m_41741_());
    }

    public ItemStack takeItem(ItemStack itemStack, int count) {
        this.setChanged();
        return this.srcInv.takeItem(itemStack, count);
    }

    public ItemStack takeItem(int index, int count) {
        ItemStack itemStack = (ItemStack)this.items.get(index);
        this.setChanged();
        return this.srcInv.takeItem(itemStack, count);
    }

    public ItemStack addItem(ItemStack itemStack) {
        this.setChanged();
        return this.srcInv.addItem(itemStack.m_41777_());
    }

    public boolean isFull(ItemStack itemStack) {
        return itemStack.m_41613_() >= this.meta.getMaxStackSize();
    }

    public boolean isInfinite(ItemStack itemStack) {
        return this.isFull(itemStack) && this.meta.enableInfinity();
    }

    protected void handleQuickMove(ItemStack clicked) {
        ItemStack taken = this.takeItem(clicked);
        ItemStack remain = this.meta.quickMoveFromPage(taken);
        this.addItem(remain);
        this.setChanged();
    }

    @Override
    public ItemStack tryQuickMoveStackTo(ItemStack stack) {
        ItemStack remain = this.addItem(stack);
        this.refreshContents();
        return remain;
    }

    @Override
    public ItemStack tryExtractItem(ItemStack stack, int count) {
        return this.takeItem(stack, count);
    }

    protected void handlePickup(ItemStack clicked, int keyCode) {
        ItemStack carried = this.meta.getMenu().m_142621_();
        if (!carried.m_41619_()) {
            ItemStack remain = this.addItem(carried.m_41777_());
            if (ModInfo.isClientLoaded() && this.meta.getMenu() instanceof CreativeModeInventoryScreen.ItemPickerMenu) {
                ModInfo.getPacketDistributor().sendToServer(new CreativeItemModPayload(carried.m_41777_(), true));
            }
            this.meta.getMenu().m_142503_(remain);
            this.setChanged();
        } else {
            int count = Math.min(clicked.m_41613_(), clicked.m_41741_());
            int takenCount = keyCode == 0 ? count : (count + 1) / 2;
            this.meta.getMenu().m_142503_(this.takeItem(clicked, takenCount));
            if (!this.meta.getMenu().m_142621_().m_41619_()) {
                this.setChanged();
            }
        }
    }

    protected void handleSwap(ItemStack clicked, int inventorySlotId) {
        ItemStack remain;
        boolean b;
        Player player = this.meta.getPlayer();
        Inventory inventory = player.m_150109_();
        ItemStack inventoryItem = inventory.m_8020_(inventorySlotId);
        boolean a = !inventoryItem.m_41619_();
        boolean bl = b = !clicked.m_41619_();
        if (a && !b) {
            remain = this.addItem(inventoryItem);
            inventory.m_6836_(inventorySlotId, remain);
        }
        if (!a && b) {
            ItemStack swapping = this.takeItem(clicked);
            inventory.m_6836_(inventorySlotId, swapping);
        }
        if (a && b) {
            remain = this.addItem(inventoryItem);
            if (remain.m_41619_()) {
                ItemStack swapping = this.takeItem(clicked);
                inventory.m_6836_(inventorySlotId, swapping);
            } else {
                inventory.m_6836_(inventorySlotId, remain);
            }
        }
        this.setChanged();
    }

    protected void handleThrow(ItemStack clicked) {
        Player player = this.meta.getPlayer();
        ItemStack thrown = this.takeItem(clicked);
        player.m_36176_(thrown, true);
        this.setChanged();
    }

    protected void handlePickupAll(ItemStack clicked) {
        int startIndex;
        Player player = this.meta.getPlayer();
        ItemStack carried = this.meta.getMenu().m_142621_();
        for (int index = startIndex = this.meta.getMenu().f_38839_.size() - 1; index >= 0; --index) {
            Slot scanning = (Slot)this.meta.getMenu().f_38839_.get(index);
            if (!(scanning.f_40218_ instanceof Inventory)) break;
            ItemStack scanningItem = scanning.m_7993_();
            if (!ItemStack.m_150942_((ItemStack)carried, (ItemStack)scanningItem)) continue;
            ItemStack taken = scanning.m_150647_(scanningItem.m_41613_(), scanningItem.m_41613_(), player);
            ItemStack remain = this.addItem(taken);
            if (!remain.m_41619_()) {
                scanning.m_5852_(remain);
            }
            this.setChanged();
        }
    }

    protected void handleClone(ItemStack clicked) {
        Player player = this.meta.getPlayer();
        if (player.m_150110_().f_35937_ && this.meta.getMenu().m_142621_().m_41619_()) {
            this.meta.getMenu().m_142503_(clicked.m_255036_(clicked.m_41741_()));
        }
    }
}

