/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui.page.manager;

import com.kwwsyk.endinv.common.SourceInventory;
import com.kwwsyk.endinv.common.client.gui.page.DisplayPage;
import com.kwwsyk.endinv.common.client.gui.page.ItemPage;
import com.kwwsyk.endinv.common.client.gui.page.manager.PageManager;
import com.kwwsyk.endinv.common.menu.page.PageType;
import com.kwwsyk.endinv.common.menu.page.PageTypeRegistry;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import com.kwwsyk.endinv.common.network.payloads.toServer.ItemPageContext;
import com.kwwsyk.endinv.common.util.SortType;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class ClientPageManager
implements PageManager {
    private final PageMetaDataManager delegate;
    private final List<DisplayPage> pages;
    private DisplayPage displayingPage;

    public ClientPageManager(PageMetaDataManager delegate) {
        this.delegate = delegate;
        this.pages = PageTypeRegistry.getDisplayPages().stream().map(type -> type.buildPage(this)).toList();
        if (!this.pages.isEmpty()) {
            this.displayingPage = this.pages.get(0);
        }
    }

    @Override
    public List<DisplayPage> getPages() {
        return this.pages;
    }

    @Override
    public DisplayPage getDisplayingPage() {
        return this.displayingPage;
    }

    @Override
    public AbstractContainerMenu getMenu() {
        return this.delegate.getMenu();
    }

    @Override
    public SourceInventory getSourceInventory() {
        return this.delegate.getSourceInventory();
    }

    @Override
    public Player getPlayer() {
        return this.delegate.getPlayer();
    }

    @Override
    public void switchPageWithIndex(int index) {
        this.delegate.switchPageWithIndex(index);
        if (index >= 0 && index < this.pages.size()) {
            this.displayingPage = this.pages.get(index);
            this.displayingPage.refreshContents();
        }
    }

    @Override
    public int rows() {
        return this.delegate.rows();
    }

    @Override
    public int columns() {
        return this.delegate.columns();
    }

    @Override
    public int getItemSize() {
        return this.delegate.getItemSize();
    }

    @Override
    public int getMaxStackSize() {
        return this.delegate.getMaxStackSize();
    }

    @Override
    public boolean enableInfinity() {
        return this.delegate.enableInfinity();
    }

    @Override
    public ItemStack quickMoveFromPage(ItemStack stack) {
        return this.delegate.quickMoveFromPage(stack);
    }

    @Override
    public SortType sortType() {
        return this.delegate.sortType();
    }

    @Override
    public void setSortType(SortType sortType) {
        this.delegate.setSortType(sortType);
    }

    @Override
    public boolean isSortReversed() {
        return this.delegate.isSortReversed();
    }

    @Override
    public void setSortReversed(boolean reversed) {
        this.delegate.setSortReversed(reversed);
    }

    @Override
    public String searching() {
        return this.delegate.searching();
    }

    @Override
    public void setSearching(String searching) {
        this.delegate.setSearching(searching);
    }

    @Override
    public void sendEndInvData() {
        this.delegate.sendEndInvData();
    }

    @Override
    public String getDisplayingPageId() {
        return this.displayingPage != null ? this.displayingPage.id : this.delegate.getDisplayingPageId();
    }

    @Override
    public void switchPageWithId(String id) {
        for (int i = 0; i < this.pages.size(); ++i) {
            if (!Objects.equals(this.pages.get((int)i).id, id)) continue;
            this.switchPageWithIndex(i);
            return;
        }
        this.delegate.switchPageWithId(id);
    }

    @Override
    public PageType getDisplayingPageType() {
        return this.displayingPage != null ? this.displayingPage.getPageType() : this.delegate.getDisplayingPageType();
    }

    @Override
    public ItemPageContext getInPageContext() {
        int n;
        DisplayPage page = this.getDisplayingPage();
        if (page instanceof ItemPage) {
            ItemPage itemPage = (ItemPage)page;
            n = itemPage.getStartIndex();
        } else {
            n = 0;
        }
        return new ItemPageContext(n, this.rows() * this.columns(), this.getPageData());
    }

    @Override
    public void scrollTo(float pos) {
        if (this.displayingPage != null) {
            this.displayingPage.scrollTo(pos);
        }
    }

    @Override
    public int getDisplayingPageIndex() {
        for (int i = 0; i < this.pages.size(); ++i) {
            if (this.pages.get(i) != this.displayingPage) continue;
            return i;
        }
        return -1;
    }
}

