/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.data;

import com.kwwsyk.endinv.common.EndInvAffinities;
import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.util.Accessibility;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public interface EndInvCodecStrategy {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String END_INV_LIST_KEY = "endless_inventories";
    public static final String ITEM_LIST_KEY = "Items";
    public static final String SIZE_INT_KEY = "Size";
    public static final String LAST_MOD_TIME_LONG_KEY = "modState";
    public static final String UUID_KEY = "uuid";
    public static final String MAX_STACK_SIZE_INT_KEY = "maxItemStackSize";
    public static final String INFINITY_BOOL_KEY = "Infinity";
    public static final String AFFINITY_KEY = "Affinities";
    public static final String BOOKMARK_LIST_KEY = "starred_items";
    public static final String OWNER_UUID_KEY = "Owner";
    public static final String WHITE_LIST_KEY = "white_list";
    public static final String ACCESSIBILITY_KEY = "Accessibility";

    default public EndlessInventory deserializeEndInv(CompoundTag invTag) {
        EndlessInventory endlessInventory = new EndlessInventory(invTag.m_128342_(UUID_KEY));
        this.deserializeItems(endlessInventory, invTag);
        this.decodeAffinities(endlessInventory, (CompoundTag)invTag.m_128423_(AFFINITY_KEY));
        if (invTag.m_128441_(OWNER_UUID_KEY)) {
            endlessInventory.setOwner(invTag.m_128342_(OWNER_UUID_KEY));
        }
        if (invTag.m_128441_(WHITE_LIST_KEY)) {
            endlessInventory.white_list.addAll(invTag.m_128437_(WHITE_LIST_KEY, 11).stream().map(NbtUtils::m_129233_).toList());
        }
        if (invTag.m_128441_(ACCESSIBILITY_KEY)) {
            endlessInventory.setAccessibility(Accessibility.valueOf(invTag.m_128461_(ACCESSIBILITY_KEY)));
        }
        if (invTag.m_128441_(MAX_STACK_SIZE_INT_KEY)) {
            endlessInventory.setMaxItemStackSize(invTag.m_128451_(MAX_STACK_SIZE_INT_KEY));
        }
        if (invTag.m_128441_(INFINITY_BOOL_KEY)) {
            endlessInventory.setInfinityMode(invTag.m_128471_(INFINITY_BOOL_KEY));
        }
        return endlessInventory;
    }

    default public CompoundTag serializeEndInv(EndlessInventory endInv) {
        CompoundTag nbt = new CompoundTag();
        CompoundTag itemData = this.serializeItems(endInv);
        nbt.m_128391_(itemData);
        CompoundTag affTag = this.encodeAffinities(endInv.affinities);
        nbt.m_128365_(AFFINITY_KEY, (Tag)affTag);
        nbt.m_128362_(UUID_KEY, endInv.getUuid());
        if (endInv.getOwnerUUID() != null) {
            nbt.m_128362_(OWNER_UUID_KEY, endInv.getOwnerUUID());
        }
        ListTag whiteList = new ListTag();
        for (UUID uuid : endInv.white_list) {
            whiteList.add((Object)NbtUtils.m_129226_((UUID)uuid));
        }
        nbt.m_128365_(WHITE_LIST_KEY, (Tag)whiteList);
        nbt.m_128359_(ACCESSIBILITY_KEY, endInv.getAccessibility().name());
        nbt.m_128405_(MAX_STACK_SIZE_INT_KEY, endInv.getMaxItemStackSize());
        nbt.m_128379_(INFINITY_BOOL_KEY, endInv.isInfinityMode());
        return nbt;
    }

    public void deserializeItems(EndlessInventory var1, CompoundTag var2);

    public CompoundTag serializeItems(EndlessInventory var1);

    public boolean canHandle(CompoundTag var1);

    default public CompoundTag encodeAffinities(EndInvAffinities affinities) {
        CompoundTag ret = new CompoundTag();
        if (affinities == null) {
            return ret;
        }
        ListTag nbtTagList = new ListTag();
        List<ItemStack> items = affinities.starredItems;
        for (ItemStack itemStack : items) {
            if (itemStack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            nbtTagList.add((Object)EndInvCodecStrategy.saveItem(itemStack.m_255036_(1), itemTag));
        }
        ret.m_128365_(BOOKMARK_LIST_KEY, (Tag)nbtTagList);
        return ret;
    }

    default public void decodeAffinities(EndlessInventory endlessInventory, @Nullable CompoundTag nbt) {
        EndInvAffinities aff = endlessInventory.affinities;
        if (nbt == null) {
            return;
        }
        ListTag tagList = nbt.m_128437_(BOOKMARK_LIST_KEY, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTag = tagList.m_128728_(i);
            EndInvCodecStrategy.parse((Tag)itemTag).filter(it -> !it.m_41619_()).ifPresent(aff::addStarredItem);
        }
    }

    public static Optional<ItemStack> parse(Tag tag) {
        if (!(tag instanceof CompoundTag)) {
            return Optional.empty();
        }
        CompoundTag compound = (CompoundTag)tag;
        try {
            return Optional.of(EndInvCodecStrategy.load(compound));
        }
        catch (Exception e) {
            LOGGER.error("Tried to load invalid item: '{}'", (Object)compound, (Object)e);
            return Optional.empty();
        }
    }

    public static Tag saveItem(ItemStack itemStack, CompoundTag outputTag) {
        if (itemStack.m_41619_()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return EndInvCodecStrategy.save(itemStack, outputTag);
    }

    public static CompoundTag save(ItemStack stack, CompoundTag compoundTag) {
        ResourceLocation resourcelocation = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        compoundTag.m_128359_("id", resourcelocation.toString());
        compoundTag.m_128405_("Count", stack.m_41613_());
        if (stack.m_41783_() != null) {
            compoundTag.m_128365_("tag", (Tag)stack.m_41783_().m_6426_());
        }
        return compoundTag;
    }

    public static ItemStack load(CompoundTag compoundTag) {
        try {
            ItemStack ret = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(compoundTag.m_128461_("id"))), compoundTag.m_128451_("Count"));
            if (compoundTag.m_128425_("tag", 10)) {
                CompoundTag tag = compoundTag.m_128469_("tag");
                ret.m_41751_(tag);
            }
            return ret;
        }
        catch (RuntimeException runtimeexception) {
            LOGGER.debug("Tried to load invalid item: {}", (Object)compoundTag, (Object)runtimeexception);
            return ItemStack.f_41583_;
        }
    }
}

