/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.menu;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.SourceInventory;
import com.kwwsyk.endinv.common.client.CachedSrcInv;
import com.kwwsyk.endinv.common.client.ClientSyncedConfig;
import com.kwwsyk.endinv.common.client.gui.page.DisplayPage;
import com.kwwsyk.endinv.common.client.gui.page.ItemPage;
import com.kwwsyk.endinv.common.menu.MenuClickHandler;
import com.kwwsyk.endinv.common.menu.page.PageType;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import com.kwwsyk.endinv.common.network.payloads.PageData;
import com.kwwsyk.endinv.common.network.payloads.SyncedConfig;
import com.kwwsyk.endinv.common.util.SortType;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class EndlessInventoryMenu
extends AbstractContainerMenu
implements PageMetaDataManager {
    private final SourceInventory sourceInventory;
    private final CraftingContainer craftMatrix = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
    private final ResultContainer craftResult = new ResultContainer();
    private static final int CRAFT_GRID_WIDTH = 3;
    private static final int CRAFT_GRID_HEIGHT = 3;
    public final Player player;
    int quickcraftStatus;
    int quickcraftType;
    Set<Slot> quickcraftSlots = new HashSet<Slot>();
    private final DataSlot rowsData = DataSlot.m_39401_();
    private final DataSlot itemSize = DataSlot.m_39401_();
    private final DataSlot maxStackSize = DataSlot.m_39401_();
    private final DataSlot infinityMode = DataSlot.m_39401_();
    private DisplayPage displayingPage;
    private int displayingPageIndex;
    public final List<DisplayPage> pages = List.of();
    public SortType sortType;
    public String searching;
    private boolean reverseSort;

    public static EndlessInventoryMenu createClient(int id, Inventory playerInv) {
        EndlessInventoryMenu ret = new EndlessInventoryMenu(id, playerInv, null);
        SyncedConfig config = ModRegistries.NbtAttachments.getSyncedConfig().getWith(playerInv.f_35978_);
        ret.init(config.pageData());
        ret.addStandardInventorySlots(playerInv, 8, 18 * ret.rows() + 18 + 13);
        return ret;
    }

    public static AbstractContainerMenu createServer(int i, Inventory inventory, Player player) {
        EndlessInventory endlessInventory = ServerLevelEndInv.getEndInvForPlayer(player).orElse(null);
        if (endlessInventory == null) {
            return null;
        }
        SyncedConfig config = ModRegistries.NbtAttachments.getSyncedConfig().getWith(player);
        EndlessInventoryMenu ret = new EndlessInventoryMenu(i, inventory, endlessInventory);
        ret.init(config.pageData());
        ret.addStandardInventorySlots(inventory, 8, 18 * ret.rows() + 18 + 13);
        return ret;
    }

    public static EndlessInventoryMenu createWithTemp(int i, Inventory inventory, Player player) {
        EndlessInventory endInv = ServerLevelEndInv.TEMP_ENDINV_REG.get((ServerPlayer)player);
        if (endInv == null) {
            throw new IllegalStateException("Try to create tmp menu without tmp EndInv.");
        }
        EndlessInventoryMenu ret = new EndlessInventoryMenu(i, inventory, endInv);
        SyncedConfig config = ModRegistries.NbtAttachments.getSyncedConfig().getWith(player);
        ret.init(config.pageData());
        ret.addStandardInventorySlots(inventory, 8, 18 * ret.rows() + 18 + 13);
        return ret;
    }

    public EndlessInventoryMenu(int id, Inventory playerInv, EndlessInventory endlessInventory) {
        super(ModRegistries.Menus.getEndInvMenuType(), id);
        this.player = playerInv.f_35978_;
        this.sourceInventory = endlessInventory != null ? endlessInventory : CachedSrcInv.INSTANCE;
        int craftX = 8;
        int craftY = 18 * this.rows() + 18;
        int resultX = craftX + 54 + 6;
        int resultY = craftY + 18;
        this.m_38897_((Slot)new ResultSlot(this.player, this.craftMatrix, (Container)this.craftResult, 0, resultX, resultY));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.m_38897_(new Slot((Container)this.craftMatrix, col + row * 3, craftX + col * 18, craftY + row * 18));
            }
        }
        int invY = craftY + 54 + 13;
        this.addStandardInventorySlots(playerInv, 8, invY);
        this.itemSize.m_6422_(endlessInventory != null ? endlessInventory.getItemSize() : 0);
        this.maxStackSize.m_6422_(endlessInventory != null ? endlessInventory.getMaxItemStackSize() : Integer.MAX_VALUE);
        this.infinityMode.m_6422_(endlessInventory != null && endlessInventory.isInfinityMode() ? 1 : 0);
        this.m_38895_(this.rowsData);
        this.m_38895_(this.itemSize);
        this.m_38895_(this.maxStackSize);
        this.m_38895_(this.infinityMode);
    }

    private void init(int rows, SortType sortType, String searching, String key) {
        this.rowsData.m_6422_(rows);
        this.sortType = sortType;
        this.searching = searching;
        this.switchPageWithId(key);
    }

    private void init(PageData pageData) {
        this.init(pageData.rows(), pageData.sortType(), pageData.search(), pageData.pageRegKey());
    }

    public void addStandardInventorySlots(Inventory playerInventory, int x, int y) {
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.m_38897_(new Slot((Container)playerInventory, j1 + l * 9 + 9, x + j1 * 18, y + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.m_38897_(new Slot((Container)playerInventory, i1, x + i1 * 18, y + 58));
        }
    }

    public List<DisplayPage> buildPages() {
        return List.of();
    }

    @Override
    public void switchPageWithIndex(int index) {
        if (this.pages == null || this.pages.isEmpty() || index < 0 || index >= this.pages.size()) {
            return;
        }
        this.displayingPageIndex = index;
        this.displayingPage = this.pages.get(index);
        ClientSyncedConfig.updateSyncedConfig(ModRegistries.NbtAttachments.getSyncedConfig().getWith(this.player).pageKeyChanged(this.displayingPage.id));
        this.displayingPage.refreshContents();
    }

    public void scrollTo(float pos) {
        this.displayingPage.scrollTo(pos);
    }

    @Override
    public int getItemSize() {
        return this.itemSize.m_6501_();
    }

    public void setItemSize(int i) {
        this.itemSize.m_6422_(i);
    }

    public float subtractInputFromScroll(float scrollOffs, double input) {
        return Mth.m_14036_((float)(scrollOffs - (float)(input / (double)this.rowsData.m_6501_())), (float)0.0f, (float)1.0f);
    }

    @Override
    public boolean enableInfinity() {
        return this.infinityMode.m_6501_() > 0;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStackSize.m_6501_();
    }

    public DisplayPage getDisplayingPage() {
        return this.displayingPage;
    }

    public int getDisplayingPageIndex() {
        return this.displayingPageIndex;
    }

    @Override
    public AbstractContainerMenu getMenu() {
        return this;
    }

    @Override
    public SourceInventory getSourceInventory() {
        return this.sourceInventory;
    }

    public List<DisplayPage> getPages() {
        return this.pages;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public int rows() {
        return this.rowsData.m_6501_();
    }

    @Override
    public int columns() {
        return 9;
    }

    public void m_150399_(int slotId, int button, @NotNull ClickType clickType, @NotNull Player player) {
        try {
            Object object;
            if (clickType == ClickType.QUICK_CRAFT) {
                MenuClickHandler.handleQuickCraft(this, slotId, button, player);
            } else if (this.quickcraftStatus != 0) {
                this.m_38951_();
            }
            switch (clickType) {
                case PICKUP: {
                    MenuClickHandler.handlePickup(this, slotId, button, player);
                    break;
                }
                case QUICK_MOVE: {
                    MenuClickHandler.handleQuickMove(this, slotId, button, player);
                    break;
                }
                case SWAP: {
                    MenuClickHandler.handleSwap(this, slotId, button, player);
                    break;
                }
                case THROW: {
                    MenuClickHandler.handleThrow(this, slotId, button, player);
                    break;
                }
                case CLONE: {
                    MenuClickHandler.handleClone(this, slotId, button, player);
                    break;
                }
                case PICKUP_ALL: {
                    MenuClickHandler.handlePickupAll(this, slotId, button, player);
                    break;
                }
                default: {
                    return;
                }
            }
            if (this.getSourceInventory() instanceof EndlessInventory && (object = this.displayingPage) instanceof ItemPage) {
                ItemPage itemPage = (ItemPage)object;
                itemPage.refreshItems();
            }
            if ((object = this.getSourceInventory()) instanceof EndlessInventory) {
                EndlessInventory endinv = (EndlessInventory)object;
                this.setItemSize(endinv.getItemSize());
            }
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)exception, (String)"Container click");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Click info");
            crashreportcategory.m_128159_("Menu Type", (Object)"endless_inventory");
            crashreportcategory.m_128165_("Menu Class", () -> this.getClass().getCanonicalName());
            crashreportcategory.m_128159_("Slot Count", (Object)this.f_38839_.size());
            crashreportcategory.m_128159_("Slot", (Object)slotId);
            crashreportcategory.m_128159_("Button", (Object)button);
            crashreportcategory.m_128159_("Type", (Object)clickType);
            throw new ReportedException(crashreport);
        }
    }

    boolean m_246200_(Player player, ClickAction action, Slot slot, ItemStack clickedItem, ItemStack carriedItem) {
        if (ModInfo.platformContext.onItemStackedOn(clickedItem, carriedItem, slot, action, player, this.m_150446_())) {
            return true;
        }
        FeatureFlagSet featureflagset = player.m_9236_().m_246046_();
        return carriedItem.m_246617_(featureflagset) && carriedItem.m_150926_(slot, action, player) || clickedItem.m_246617_(featureflagset) && clickedItem.m_150932_(carriedItem, slot, action, player, this.m_150446_());
    }

    private SlotAccess m_150446_() {
        return new SlotAccess(){

            @NotNull
            public ItemStack m_142196_() {
                return EndlessInventoryMenu.this.m_142621_();
            }

            public boolean m_142104_(@NotNull ItemStack itemStack) {
                EndlessInventoryMenu.this.m_142503_(itemStack);
                return true;
            }
        };
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            if (itemstack1.m_41720_() == ModRegistries.Items.getTestEndInv()) {
                return ItemStack.f_41583_;
            }
            itemstack = itemstack1.m_41777_();
            ItemStack remain = this.displayingPage.tryQuickMoveStackTo(itemstack);
            itemstack1.m_41764_(remain.m_41613_());
            slot.m_269060_(ItemStack.f_41583_);
            this.displayingPage.setChanged();
        }
        return itemstack;
    }

    @Override
    public ItemStack quickMoveFromPage(ItemStack stack) {
        this.m_38903_(stack, 0, this.f_38839_.size() - 1, true);
        return stack;
    }

    @Override
    public SortType sortType() {
        return this.sortType;
    }

    @Override
    public void setSortType(SortType sortType) {
        this.sortType = sortType;
    }

    @Override
    public boolean isSortReversed() {
        return this.reverseSort;
    }

    @Override
    public void switchSortReversed() {
        this.reverseSort = !this.reverseSort;
    }

    @Override
    public void setSortReversed(boolean reversed) {
        this.reverseSort = reversed;
    }

    @Override
    public String searching() {
        return this.searching;
    }

    @Override
    public void setSearching(String searching) {
        this.searching = searching;
    }

    @Override
    public void sendEndInvData() {
        SourceInventory sourceInventory = this.sourceInventory;
        if (sourceInventory instanceof EndlessInventory) {
            EndlessInventory endlessInventory = (EndlessInventory)sourceInventory;
            this.itemSize.m_6422_(endlessInventory.getItemSize());
            this.maxStackSize.m_6422_(endlessInventory.getMaxItemStackSize());
            this.infinityMode.m_6422_(endlessInventory.isInfinityMode() ? 1 : 0);
        }
    }

    @Override
    public String getDisplayingPageId() {
        return this.getDisplayingPage().id;
    }

    @Override
    public void switchPageWithId(String id) {
        for (int i = 0; i < this.getPages().size(); ++i) {
            if (!Objects.equals(this.getPages().get((int)i).id, id)) continue;
            this.switchPageWithIndex(i);
        }
    }

    @Override
    public PageType getDisplayingPageType() {
        return this.getDisplayingPage().getPageType();
    }

    public boolean m_6875_(@NotNull Player player) {
        return true;
    }
}

