/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.menu;

import com.kwwsyk.endinv.common.menu.EndlessInventoryMenu;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class MenuClickHandler {
    public static void handleQuickCraft(EndlessInventoryMenu menu, int slotId, int button, Player player) {
        int i = menu.quickcraftStatus;
        menu.quickcraftStatus = AbstractContainerMenu.m_38947_((int)button);
        if ((i != 1 || menu.quickcraftStatus != 2) && i != menu.quickcraftStatus || menu.m_142621_().m_41619_()) {
            MenuClickHandler.resetQuickCraft(menu);
        } else {
            switch (menu.quickcraftStatus) {
                case 0: {
                    menu.quickcraftType = AbstractContainerMenu.m_38928_((int)button);
                    if (AbstractContainerMenu.m_38862_((int)menu.quickcraftType, (Player)player)) {
                        menu.quickcraftStatus = 1;
                        menu.quickcraftSlots.clear();
                        break;
                    }
                    MenuClickHandler.resetQuickCraft(menu);
                    break;
                }
                case 1: {
                    ItemStack itemstack;
                    if (slotId < 0) {
                        return;
                    }
                    Slot slot = (Slot)menu.f_38839_.get(slotId);
                    if (!AbstractContainerMenu.m_38899_((Slot)slot, (ItemStack)(itemstack = menu.m_142621_()), (boolean)true) || !slot.m_5857_(itemstack) || menu.quickcraftType != 2 && itemstack.m_41613_() <= menu.quickcraftSlots.size() || !menu.m_5622_(slot)) break;
                    menu.quickcraftSlots.add(slot);
                    break;
                }
                case 2: {
                    if (!menu.quickcraftSlots.isEmpty()) {
                        if (menu.quickcraftSlots.size() == 1) {
                            int i1 = menu.quickcraftSlots.iterator().next().f_40219_;
                            MenuClickHandler.resetQuickCraft(menu);
                            MenuClickHandler.handlePickup(menu, i1, menu.quickcraftType, player);
                            return;
                        }
                        ItemStack copiedCarried = menu.m_142621_().m_41777_();
                        if (copiedCarried.m_41619_()) {
                            MenuClickHandler.resetQuickCraft(menu);
                            return;
                        }
                        int count = menu.m_142621_().m_41613_();
                        for (Slot slot1 : menu.quickcraftSlots) {
                            ItemStack carried = menu.m_142621_();
                            if (slot1 == null || !AbstractContainerMenu.m_38899_((Slot)slot1, (ItemStack)carried, (boolean)true) || !slot1.m_5857_(carried) || menu.quickcraftType != 2 && carried.m_41613_() < menu.quickcraftSlots.size() || !menu.m_5622_(slot1)) continue;
                            int j = slot1.m_6657_() ? slot1.m_7993_().m_41613_() : 0;
                            int k = Math.min(copiedCarried.m_41741_(), slot1.m_5866_(copiedCarried));
                            int l = Math.min(AbstractContainerMenu.m_278794_(menu.quickcraftSlots, (int)menu.quickcraftType, (ItemStack)copiedCarried) + j, k);
                            count -= l - j;
                            slot1.m_269060_(copiedCarried.m_255036_(l));
                        }
                        copiedCarried.m_41764_(count);
                        menu.m_142503_(copiedCarried);
                    }
                    MenuClickHandler.resetQuickCraft(menu);
                    break;
                }
                default: {
                    MenuClickHandler.resetQuickCraft(menu);
                }
            }
        }
    }

    private static void resetQuickCraft(EndlessInventoryMenu EIM) {
        EIM.quickcraftStatus = 0;
        EIM.quickcraftSlots.clear();
    }

    public static void handlePickup(EndlessInventoryMenu EIM, int slotId, int button, Player player) {
        ClickAction clickaction;
        ClickAction clickAction = clickaction = button == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY;
        if (slotId == -999) {
            if (!EIM.m_142621_().m_41619_()) {
                if (clickaction == ClickAction.PRIMARY) {
                    player.m_36176_(EIM.m_142621_(), true);
                    EIM.m_142503_(ItemStack.f_41583_);
                } else {
                    player.m_36176_(EIM.m_142621_().m_41620_(1), true);
                }
            }
        } else if (slotId >= 0) {
            ItemStack carried;
            Slot clickedSlot = (Slot)EIM.f_38839_.get(slotId);
            Container container = clickedSlot.f_40218_;
            ItemStack clickedSlotItem = clickedSlot.m_7993_();
            if (!EIM.m_246200_(player, clickaction, clickedSlot, clickedSlotItem, carried = EIM.m_142621_())) {
                MenuClickHandler.handleVanillaPickup(EIM, slotId, clickaction, player);
                clickedSlot.m_6654_();
            }
        }
    }

    public static void handleVanillaPickup(AbstractContainerMenu menu, int slotId, ClickAction clickaction, Player player) {
        Slot clickedSlot = (Slot)menu.f_38839_.get(slotId);
        ItemStack clickedSlotItem = clickedSlot.m_7993_();
        ItemStack carried = menu.m_142621_();
        if (clickedSlotItem.m_41619_()) {
            if (!carried.m_41619_()) {
                int i3 = clickaction == ClickAction.PRIMARY ? carried.m_41613_() : 1;
                menu.m_142503_(clickedSlot.m_150656_(carried, i3));
            }
        } else if (clickedSlot.m_8010_(player)) {
            if (carried.m_41619_()) {
                int j3 = clickaction == ClickAction.PRIMARY ? clickedSlotItem.m_41613_() : (clickedSlotItem.m_41613_() + 1) / 2;
                Optional optional1 = clickedSlot.m_150641_(j3, Integer.MAX_VALUE, player);
                optional1.ifPresent(p_150421_ -> {
                    menu.m_142503_(p_150421_);
                    clickedSlot.m_142406_(player, p_150421_);
                });
            } else if (clickedSlot.m_5857_(carried)) {
                if (ItemStack.m_150942_((ItemStack)clickedSlotItem, (ItemStack)carried)) {
                    int k3 = clickaction == ClickAction.PRIMARY ? carried.m_41613_() : 1;
                    menu.m_142503_(clickedSlot.m_150656_(carried, k3));
                } else if (carried.m_41613_() <= clickedSlot.m_5866_(carried)) {
                    menu.m_142503_(clickedSlotItem);
                    clickedSlot.m_269060_(carried);
                }
            } else if (ItemStack.m_150942_((ItemStack)clickedSlotItem, (ItemStack)carried)) {
                Optional optional = clickedSlot.m_150641_(clickedSlotItem.m_41613_(), carried.m_41741_() - carried.m_41613_(), player);
                optional.ifPresent(p_150428_ -> {
                    carried.m_41769_(p_150428_.m_41613_());
                    clickedSlot.m_142406_(player, p_150428_);
                });
            }
        }
    }

    public static void handleQuickMove(AbstractContainerMenu menu, int slotId, int button, Player player) {
        ClickAction clickaction;
        ClickAction clickAction = clickaction = button == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY;
        if (slotId == -999) {
            if (!menu.m_142621_().m_41619_()) {
                if (clickaction == ClickAction.PRIMARY) {
                    player.m_36176_(menu.m_142621_(), true);
                    menu.m_142503_(ItemStack.f_41583_);
                } else {
                    player.m_36176_(menu.m_142621_().m_41620_(1), true);
                }
            }
        } else {
            if (slotId < 0) {
                return;
            }
            Slot clickedSlot = (Slot)menu.f_38839_.get(slotId);
            if (!clickedSlot.m_8010_(player)) {
                return;
            }
            ItemStack itemstack8 = menu.m_7648_(player, slotId);
            while (!itemstack8.m_41619_() && ItemStack.m_41656_((ItemStack)clickedSlot.m_7993_(), (ItemStack)itemstack8)) {
                itemstack8 = menu.m_7648_(player, slotId);
            }
        }
    }

    public static void handleSwap(EndlessInventoryMenu EIM, int slotId, int button, Player player) {
        if ((button < 0 || button >= 9) && button != 40 || slotId <= 0) {
            return;
        }
        Slot clickedSlot = (Slot)EIM.f_38839_.get(slotId);
        Container container = clickedSlot.f_40218_;
        MenuClickHandler.handleVanillaSwap(EIM, slotId, button, player);
    }

    public static void handleVanillaSwap(AbstractContainerMenu menu, int slotId, int button, Player player) {
        Inventory inventory = player.m_150109_();
        ItemStack inventoryItem = inventory.m_8020_(button);
        Slot hoveringSlot = (Slot)menu.f_38839_.get(slotId);
        ItemStack hoveringSlotItem = hoveringSlot.m_7993_();
        if (!inventoryItem.m_41619_() || !hoveringSlotItem.m_41619_()) {
            if (inventoryItem.m_41619_()) {
                if (hoveringSlot.m_8010_(player)) {
                    inventory.m_6836_(button, hoveringSlotItem);
                    hoveringSlot.m_269060_(ItemStack.f_41583_);
                    hoveringSlot.m_142406_(player, hoveringSlotItem);
                }
            } else if (hoveringSlotItem.m_41619_()) {
                if (hoveringSlot.m_5857_(inventoryItem)) {
                    int j2 = hoveringSlot.m_5866_(inventoryItem);
                    if (inventoryItem.m_41613_() > j2) {
                        hoveringSlot.m_269060_(inventoryItem.m_41620_(j2));
                    } else {
                        inventory.m_6836_(button, ItemStack.f_41583_);
                        hoveringSlot.m_269060_(inventoryItem);
                    }
                }
            } else if (hoveringSlot.m_8010_(player) && hoveringSlot.m_5857_(inventoryItem)) {
                int k2 = hoveringSlot.m_5866_(inventoryItem);
                if (inventoryItem.m_41613_() > k2) {
                    hoveringSlot.m_269060_(inventoryItem.m_41620_(k2));
                    hoveringSlot.m_142406_(player, hoveringSlotItem);
                    if (!inventory.m_36054_(hoveringSlotItem)) {
                        player.m_36176_(hoveringSlotItem, true);
                    }
                } else {
                    inventory.m_6836_(button, hoveringSlotItem);
                    hoveringSlot.m_269060_(inventoryItem);
                    hoveringSlot.m_142406_(player, hoveringSlotItem);
                }
            }
        }
    }

    public static void handleThrow(AbstractContainerMenu menu, int slotId, int button, Player player) {
        if (!menu.m_142621_().m_41619_() || slotId < 0) {
            return;
        }
        Slot throwingSlot = (Slot)menu.f_38839_.get(slotId);
        int throwingCount = button == 0 ? 1 : throwingSlot.m_7993_().m_41613_();
        ItemStack thrown = throwingSlot.m_150647_(throwingCount, Integer.MAX_VALUE, player);
        player.m_36176_(thrown, true);
        if (button == 1) {
            while (!thrown.m_41619_() && ItemStack.m_41656_((ItemStack)throwingSlot.m_7993_(), (ItemStack)thrown)) {
                thrown = throwingSlot.m_150647_(throwingCount, Integer.MAX_VALUE, player);
                player.m_36176_(thrown, true);
            }
        }
    }

    public static void handleClone(AbstractContainerMenu menu, int slotId, int button, Player player) {
        Slot slot4;
        if (player.m_150110_().f_35937_ && menu.m_142621_().m_41619_() && slotId >= 0 && (slot4 = (Slot)menu.f_38839_.get(slotId)).m_6657_()) {
            ItemStack itemstack5 = slot4.m_7993_();
            menu.m_142503_(itemstack5.m_255036_(itemstack5.m_41741_()));
        }
    }

    public static void handlePickupAll(EndlessInventoryMenu EIM, int slotId, int button, Player player) {
        if (slotId < 0) {
            return;
        }
        Slot clickedSlot = (Slot)EIM.f_38839_.get(slotId);
        Container slotContainer = clickedSlot.f_40218_;
        ItemStack carried = EIM.m_142621_();
        if (carried.m_41619_()) {
            return;
        }
        if (!clickedSlot.m_6657_() || !clickedSlot.m_8010_(player)) {
            int startIndex = button == 0 ? 0 : EIM.f_38839_.size() - 1;
            int inc = button == 0 ? 1 : -1;
            for (int l2 = 0; l2 < 2; ++l2) {
                for (int index = startIndex; index >= 0 && index < EIM.f_38839_.size() && carried.m_41613_() < carried.m_41741_(); index += inc) {
                    Slot scanningSlot = (Slot)EIM.f_38839_.get(index);
                    if (!AbstractContainerMenu.m_38899_((Slot)scanningSlot, (ItemStack)carried, (boolean)true) || !scanningSlot.m_8010_(player) || !EIM.m_5882_(carried, scanningSlot)) continue;
                    ItemStack scanningItem = scanningSlot.m_7993_();
                    if (l2 == 0 && scanningItem.m_41613_() == scanningItem.m_41741_()) continue;
                    ItemStack taken = scanningSlot.m_150647_(scanningItem.m_41613_(), carried.m_41741_() - carried.m_41613_(), player);
                    carried.m_41769_(taken.m_41613_());
                }
                if (carried.m_41613_() >= carried.m_41741_()) continue;
                ItemStack taken = EIM.getDisplayingPage().tryExtractItem(carried, carried.m_41741_() - carried.m_41613_());
                carried.m_41769_(taken.m_41613_());
                carried.m_41764_(Math.min(carried.m_41613_(), carried.m_41741_()));
            }
        }
    }

    public static void vanillaPickupAll(AbstractContainerMenu menu, int slotId, int button, Player player) {
        if (slotId >= 0) {
            Slot slot2 = (Slot)menu.f_38839_.get(slotId);
            ItemStack itemstack4 = menu.m_142621_();
            if (!(itemstack4.m_41619_() || slot2.m_6657_() && slot2.m_8010_(player))) {
                int l1 = button == 0 ? 0 : menu.f_38839_.size() - 1;
                int i2 = button == 0 ? 1 : -1;
                for (int l2 = 0; l2 < 2; ++l2) {
                    for (int l3 = l1; l3 >= 0 && l3 < menu.f_38839_.size() && itemstack4.m_41613_() < itemstack4.m_41741_(); l3 += i2) {
                        Slot slot8 = (Slot)menu.f_38839_.get(l3);
                        if (!slot8.m_6657_() || !AbstractContainerMenu.m_38899_((Slot)slot8, (ItemStack)itemstack4, (boolean)true) || !slot8.m_8010_(player) || !menu.m_5882_(itemstack4, slot8)) continue;
                        ItemStack itemstack11 = slot8.m_7993_();
                        if (l2 == 0 && itemstack11.m_41613_() == itemstack11.m_41741_()) continue;
                        ItemStack itemstack12 = slot8.m_150647_(itemstack11.m_41613_(), itemstack4.m_41741_() - itemstack4.m_41613_(), player);
                        itemstack4.m_41769_(itemstack12.m_41613_());
                    }
                }
            }
        }
    }
}

