/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.menu.page;

import com.kwwsyk.endinv.common.client.ClientModInfo;
import com.kwwsyk.endinv.common.menu.page.PageType;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectIntImmutablePair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;

public class PageTypeRegistry {
    public static final int ORDER_INTERVAL = 256;
    private static final LinkedHashMap<String, PageType> PAGE_TYPES = new LinkedHashMap();
    private static final List<String> INDEX_LIST = new ArrayList<String>();
    private static final List<Integer> ORDER = new ArrayList<Integer>();
    private static List<PageType> cache = null;

    public static void register(PageType type) {
        String id = type.registerName;
        if (PAGE_TYPES.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate page id: " + id);
        }
        PAGE_TYPES.put(id, type);
        INDEX_LIST.add(id);
        ORDER.add(PageTypeRegistry.getLastPageOrder() + 256);
        cache = null;
    }

    public static void register(PageType type, int order) {
        String id = type.registerName;
        if (PAGE_TYPES.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate page id: " + id);
        }
        PAGE_TYPES.put(id, type);
        INDEX_LIST.add(id);
        ORDER.add(order);
        cache = null;
    }

    public static List<PageType> getDisplayPages() {
        return cache != null ? cache : (cache = PageTypeRegistry.getSortedList().stream().filter(str -> !ClientModInfo.getClientConfig().hidingPageIds().contains(str)).map(PAGE_TYPES::get).toList());
    }

    public static int getLastPageOrder() {
        return ORDER.stream().filter(Objects::nonNull).max(Integer::compareTo).orElse(0);
    }

    public static List<String> getSortedList() {
        ArrayList<Object> ret = new ArrayList<Object>(PageTypeRegistry.size());
        for (int i = 0; i < PageTypeRegistry.size(); ++i) {
            ret.add(new ObjectIntImmutablePair((Object)INDEX_LIST.get(i), ORDER.get(i).intValue()));
        }
        ret.sort(Comparator.comparingInt(Pair::right));
        return ret.stream().map(Pair::left).toList();
    }

    public static PageType byId(String id) {
        return PAGE_TYPES.get(id);
    }

    public static PageType byIndex(int index) {
        return PAGE_TYPES.get(INDEX_LIST.get(index));
    }

    public static int size() {
        return INDEX_LIST.size();
    }

    public static int getIndexOf(String id) {
        return INDEX_LIST.indexOf(id);
    }

    public static Collection<PageType> values() {
        return PAGE_TYPES.values();
    }

    public static void setChanged() {
        cache = null;
    }

    public static List<String> getIdList() {
        return new ArrayList<String>(INDEX_LIST);
    }

    static {
        PageTypeRegistry.register(PageType.ALL_ITEMS, 0);
        PageTypeRegistry.register(PageType.BLOCK_ITEMS, 256);
        PageTypeRegistry.register(PageType.WEAPONS, 768);
        PageTypeRegistry.register(PageType.TOOLS, 512);
        PageTypeRegistry.register(PageType.EQUIPMENTS);
        PageTypeRegistry.register(PageType.CONSUMABLE);
        PageTypeRegistry.register(PageType.ENCHANTED_BOOKS);
        PageTypeRegistry.register(PageType.BOOKMARK);
    }
}

