/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.network.payloads;

import com.kwwsyk.endinv.common.util.SortType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;

public record PageData(String pageRegKey, int rows, int columns, SortType sortType, boolean reverseSort, String search) {
    public static final PageData DEFAULT = new PageData("all_items", 0, 9, SortType.DEFAULT, false, "");
    public static final Codec<PageData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("pageId", (Object)"all_items").forGetter(PageData::pageRegKey), (App)Codec.INT.optionalFieldOf("rows", (Object)15).forGetter(PageData::rows), (App)Codec.INT.optionalFieldOf("rows", (Object)15).forGetter(PageData::columns), (App)SortType.CODEC.optionalFieldOf("sortType", (Object)SortType.DEFAULT).forGetter(PageData::sortType), (App)Codec.BOOL.optionalFieldOf("reverseSort", (Object)false).forGetter(PageData::reverseSort), (App)Codec.STRING.optionalFieldOf("searching", (Object)"").forGetter(PageData::search)).apply((Applicative)instance, PageData::new));

    public static void encode(FriendlyByteBuf o, PageData data) {
        o.m_130070_(data.pageRegKey);
        o.writeInt(data.rows);
        o.writeInt(data.columns);
        o.m_130068_((Enum)data.sortType);
        o.writeBoolean(data.reverseSort);
        o.m_130070_(data.search);
    }

    public static PageData decode(FriendlyByteBuf o) {
        return new PageData(o.m_130277_(), o.readInt(), o.readInt(), (SortType)o.m_130066_(SortType.class), o.readBoolean(), o.m_130277_());
    }

    public PageData copy() {
        return new PageData(this.pageRegKey, this.rows, this.columns, this.sortType, this.reverseSort, this.search);
    }

    public PageData ofRowChanged(int rows) {
        return new PageData(this.pageRegKey, rows, this.columns, this.sortType, this.reverseSort, this.search);
    }

    public PageData ofColumnChanged(int columns) {
        return new PageData(this.pageRegKey, this.rows, columns, this.sortType, this.reverseSort, this.search);
    }

    public PageData sortTypeChanged(SortType sortType) {
        return new PageData(this.pageRegKey, this.rows, this.columns, sortType, this.reverseSort, this.search);
    }

    public PageData searchingChanged(String searching) {
        return new PageData(this.pageRegKey, this.rows, this.columns, this.sortType, this.reverseSort, searching);
    }

    public PageData ofReverseSort() {
        return new PageData(this.pageRegKey, this.rows, this.columns, this.sortType, !this.reverseSort, this.search);
    }

    public PageData ofPageKeyChanged(String pageRegKey) {
        return new PageData(pageRegKey, this.rows, this.columns, this.sortType, !this.reverseSort, this.search);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PageData)) return false;
        PageData pageData = (PageData)obj;
        if (!pageData.pageRegKey.equals(this.pageRegKey)) return false;
        if (pageData.rows != this.rows) return false;
        if (pageData.columns() != this.columns) return false;
        if (pageData.reverseSort != this.reverseSort) return false;
        if (this.sortType != pageData.sortType) return false;
        if (!Objects.equals(pageData.search, this.search)) return false;
        return true;
    }
}

