/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.network.payloads;

import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.network.payloads.ModPacketContext;
import com.kwwsyk.endinv.common.network.payloads.ModPacketPayload;
import com.kwwsyk.endinv.common.network.payloads.PageData;
import com.kwwsyk.endinv.common.util.SortType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.FriendlyByteBuf;

public record SyncedConfig(PageData pageData, boolean attaching, boolean autoPicking) implements ModPacketPayload
{
    public static final SyncedConfig DEFAULT = new SyncedConfig(PageData.DEFAULT, true, true);
    public static final Codec<SyncedConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PageData.CODEC.optionalFieldOf("page_data", (Object)PageData.DEFAULT).forGetter(SyncedConfig::pageData), (App)Codec.BOOL.optionalFieldOf("attaching", (Object)true).forGetter(SyncedConfig::attaching), (App)Codec.BOOL.optionalFieldOf("auto_pickup", (Object)true).forGetter(SyncedConfig::autoPicking)).apply((Applicative)instance, SyncedConfig::new));

    public static void encode(SyncedConfig config, FriendlyByteBuf o) {
        PageData.encode(o, config.pageData);
        o.writeBoolean(config.attaching);
        o.writeBoolean(config.autoPicking);
    }

    public static SyncedConfig decode(FriendlyByteBuf o) {
        return new SyncedConfig(PageData.decode(o), o.readBoolean(), o.readBoolean());
    }

    @Override
    public String id() {
        return "endinv_settings";
    }

    @Override
    public void handle(ModPacketContext context) {
        if (context.player() != null) {
            ModRegistries.NbtAttachments.getSyncedConfig().setTo(context.player(), this);
        }
    }

    public SyncedConfig searchingChanged(String searching) {
        return new SyncedConfig(this.pageData.searchingChanged(searching), this.attaching, this.autoPicking);
    }

    public SyncedConfig sortTypeChanged(SortType type) {
        return new SyncedConfig(this.pageData.sortTypeChanged(type), this.attaching, this.autoPicking);
    }

    public SyncedConfig ofReverseSort() {
        return new SyncedConfig(this.pageData.ofReverseSort(), this.attaching, this.autoPicking);
    }

    public SyncedConfig ofRowChanged(int rows) {
        return new SyncedConfig(this.pageData.ofRowChanged(rows), this.attaching, this.autoPicking);
    }

    public SyncedConfig pageKeyChanged(String regKey) {
        return new SyncedConfig(this.pageData.ofPageKeyChanged(regKey), this.attaching, this.autoPicking);
    }

    public boolean checkState() {
        return this.pageData.rows() > 0 && this.pageData.columns() > 0;
    }

    public boolean checkForAttaching() {
        return this.checkState() && this.attaching;
    }
}

