/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.util;

import com.kwwsyk.endinv.common.SourceInventory;
import com.kwwsyk.endinv.common.util.ItemKey;
import com.mojang.serialization.Codec;
import java.util.Comparator;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;

public enum SortType {
    DEFAULT("sorttype.endinv.default"),
    COUNT("sorttype.endinv.count"),
    SPACE_AND_NAME("sorttype.endinv.name"),
    ID("sorttype.endinv.id"),
    LAST_MODIFIED("sorttype.endinv.last_modified");

    public final String translationKey;
    public static final Codec<SortType> CODEC;

    private SortType(String translationKey) {
        this.translationKey = translationKey;
    }

    static {
        CODEC = Codec.STRING.xmap(name -> {
            try {
                return SortType.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return DEFAULT;
            }
        }, Enum::name);
    }

    public static interface ISortHelper {
        public static final Comparator<ItemStack> REGISTRY_ORDER_COMPARATOR = Comparator.comparingInt(stack -> BuiltInRegistries.f_257033_.m_7447_((Object)stack.m_41720_()));

        default public Comparator<ItemStack> getComparator(SortType sortType, SourceInventory srcInv) {
            return switch (sortType) {
                default -> throw new IncompatibleClassChangeError();
                case DEFAULT -> (a, b) -> 0;
                case COUNT -> Comparator.comparingInt(ItemStack::m_41613_);
                case SPACE_AND_NAME -> Comparator.comparing(it -> BuiltInRegistries.f_257033_.m_7981_((Object)it.m_41720_()).toString());
                case ID -> REGISTRY_ORDER_COMPARATOR;
                case LAST_MODIFIED -> Comparator.comparingLong(s -> srcInv.getItemMap().get(ItemKey.asKey(s)).lastModTime());
            };
        }
    }
}

