/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.forge;

import com.kwwsyk.endinv.common.options.ContentTransferMode;
import com.kwwsyk.endinv.common.options.IConfigValue;
import com.kwwsyk.endinv.common.options.IServerConfig;
import com.kwwsyk.endinv.common.options.MissingEndInvPolicy;
import com.kwwsyk.endinv.common.util.Accessibility;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ServerConfig {
    public static final ServerConfig CONFIG;
    public static final ForgeConfigSpec CONFIG_SPEC;
    public final ForgeConfigSpec.IntValue MAX_STACK_SIZE;
    public final ForgeConfigSpec.BooleanValue ENABLE_INFINITE;
    public final ForgeConfigSpec.BooleanValue ENABLE_AUTO_PICK;
    public final ForgeConfigSpec.EnumValue<ContentTransferMode> TRANSFER_MODE;
    public final ForgeConfigSpec.EnumValue<Accessibility> DEFAULT_ACCESSIBILITY;
    public final ForgeConfigSpec.EnumValue<MissingEndInvPolicy> CREATION_MODE;
    public final IServerConfig INSTANCE = new IServerConfig(){

        private static IConfigValue<Integer> convert(ForgeConfigSpec.IntValue value) {
            return IConfigValue.of(value, arg_0 -> ((ForgeConfigSpec.IntValue)value).set(arg_0));
        }

        private static IConfigValue<Boolean> convert(ForgeConfigSpec.BooleanValue value) {
            return IConfigValue.of(value, arg_0 -> ((ForgeConfigSpec.BooleanValue)value).set(arg_0));
        }

        @Override
        public IConfigValue<Integer> getMaxAllowedStackSize() {
            return 1.convert(ServerConfig.this.MAX_STACK_SIZE);
        }

        @Override
        public IConfigValue<Boolean> allowInfinityMode() {
            return 1.convert(ServerConfig.this.ENABLE_INFINITE);
        }

        @Override
        public IConfigValue<Boolean> enableAutoPick() {
            return 1.convert(ServerConfig.this.ENABLE_AUTO_PICK);
        }

        @Override
        public IConfigValue<ContentTransferMode> transferMode() {
            return IConfigValue.of(ServerConfig.this.TRANSFER_MODE, arg_0 -> ServerConfig.this.TRANSFER_MODE.set(arg_0));
        }

        @Override
        public IConfigValue<Accessibility> defaultAccessibility() {
            return IConfigValue.of(ServerConfig.this.DEFAULT_ACCESSIBILITY, arg_0 -> ServerConfig.this.DEFAULT_ACCESSIBILITY.set(arg_0));
        }

        @Override
        public IConfigValue<MissingEndInvPolicy> policyHandlingMissing() {
            return IConfigValue.of(ServerConfig.this.CREATION_MODE, arg_0 -> ServerConfig.this.CREATION_MODE.set(arg_0));
        }
    };

    private ServerConfig(ForgeConfigSpec.Builder builder) {
        this.MAX_STACK_SIZE = builder.translation("config.endinv.comment.max_stack_size").defineInRange("ItemCapacity.maxStackSize", Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
        this.ENABLE_INFINITE = builder.translation("config.endinv.comment.enable_infinite1").define("ItemCapacity.enableInfinite", false);
        this.ENABLE_AUTO_PICK = builder.comment("Will enable player to auto pick item and exp").define("autoPickUtility", false);
        this.TRANSFER_MODE = builder.defineEnum("TransferMode", (Enum)ContentTransferMode.ALL);
        this.DEFAULT_ACCESSIBILITY = builder.defineEnum("defaultAccessibility", (Enum)Accessibility.PUBLIC);
        this.CREATION_MODE = builder.defineEnum("creationMode", (Enum)MissingEndInvPolicy.CREATE_PER_PLAYER);
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        CONFIG = (ServerConfig)pair.getLeft();
        CONFIG_SPEC = (ForgeConfigSpec)pair.getRight();
    }
}

