/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.forge.events;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.network.payloads.toClient.ItemPickedUpPayload;
import com.kwwsyk.endinv.forge.ServerConfig;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="endless_inventory", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LootEvent {
    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!LootEvent.isPlayerEnabledAutoPick((Player)player)) {
            return;
        }
        if (((Boolean)ServerConfig.CONFIG.ENABLE_AUTO_PICK.get()).booleanValue()) {
            EndlessInventory endInv = ServerLevelEndInv.getEndInvForPlayer((Player)player).orElse(null);
            if (endInv == null) {
                return;
            }
            boolean flag = true;
            for (ItemEntity drop : event.getDrops()) {
                ItemStack stack = drop.m_32055_();
                ItemStack remain = endInv.addItem(stack);
                stack.m_41620_(remain.m_41613_());
                if (!stack.m_41619_()) {
                    ModInfo.getPacketDistributor().sendToPlayer(player, new ItemPickedUpPayload(stack));
                }
                if (remain.m_41619_()) {
                    drop.m_142687_(Entity.RemovalReason.DISCARDED);
                    continue;
                }
                drop.m_32045_(remain);
                flag = false;
            }
            if (flag) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!LootEvent.isPlayerEnabledAutoPick((Player)player2)) {
            return;
        }
        if (!((Boolean)ServerConfig.CONFIG.ENABLE_AUTO_PICK.get()).booleanValue()) {
            return;
        }
        EndlessInventory endInv = ServerLevelEndInv.getEndInvForPlayer((Player)player2).orElse(null);
        if (endInv == null) {
            return;
        }
        ServerLevel level = (ServerLevel)event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        LootParams.Builder builder = new LootParams.Builder(level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81463_, (Object)player2.m_21205_()).m_287286_(LootContextParams.f_81461_, (Object)state).m_287286_(LootContextParams.f_81455_, (Object)player2);
        if (event.getExpToDrop() > 0) {
            int exp = event.getExpToDrop();
            int repaired = LootEvent.repairPlayerItems((Player)player2, exp);
            player2.m_6756_(repaired);
            event.setExpToDrop(0);
        }
        List drops = state.m_287290_(builder);
        boolean allPicked = true;
        for (ItemStack drop : drops) {
            ItemStack remain = endInv.addItem(drop.m_41777_());
            drop.m_41774_(remain.m_41613_());
            if (!drop.m_41619_()) {
                ModInfo.getPacketDistributor().sendToPlayer(player2, new ItemPickedUpPayload(drop));
            }
            if (remain.m_41619_()) continue;
            allPicked = false;
            level.m_7967_((Entity)new ItemEntity((Level)level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, remain));
        }
        if (allPicked) {
            event.setCanceled(true);
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    @SubscribeEvent
    public static void onExpDrops(LivingExperienceDropEvent event) {
        Player player = event.getAttackingPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (!LootEvent.isPlayerEnabledAutoPick((Player)player2) || !((Boolean)ServerConfig.CONFIG.ENABLE_AUTO_PICK.get()).booleanValue()) {
                return;
            }
            int exp = event.getDroppedExperience();
            int newValue = LootEvent.repairPlayerItems((Player)player2, exp);
            player2.m_6756_(newValue);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPickupItem(EntityItemPickupEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer && ((Boolean)ServerConfig.CONFIG.ENABLE_AUTO_PICK.get()).booleanValue() && LootEvent.isPlayerEnabledAutoPick(player))) {
            return;
        }
        ItemEntity entity = event.getItem();
        if (entity.m_32063_()) {
            return;
        }
        ItemStack stack = entity.m_32055_();
        if (LootEvent.shouldMoveTo(player, stack)) {
            ServerLevelEndInv.getEndInvForPlayer(player).ifPresent(endInv -> {
                ItemStack remain = endInv.addItem(stack.m_41777_());
                if (!stack.m_41619_()) {
                    ModInfo.getPacketDistributor().sendToPlayer((ServerPlayer)player, new ItemPickedUpPayload(stack.m_41777_()));
                }
                if (remain.m_41619_()) {
                    stack.m_41764_(0);
                } else {
                    stack.m_41620_(remain.m_41613_());
                }
            });
        }
    }

    private static boolean shouldMoveTo(Player player, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        if (item instanceof SwordItem) {
            SwordItem swordItem = (SwordItem)item;
            return LootEvent.hasSuch(player, (Item)swordItem);
        }
        if (item instanceof AxeItem) {
            AxeItem axeItem = (AxeItem)item;
            return LootEvent.hasSuch(player, (Item)axeItem);
        }
        if (item instanceof PickaxeItem) {
            PickaxeItem such = (PickaxeItem)item;
            return LootEvent.hasSuch(player, (Item)such);
        }
        if (item instanceof ShovelItem) {
            ShovelItem such = (ShovelItem)item;
            return LootEvent.hasSuch(player, (Item)such);
        }
        if (item instanceof HoeItem) {
            HoeItem such = (HoeItem)item;
            return LootEvent.hasSuch(player, (Item)such);
        }
        if (item instanceof TridentItem) {
            TridentItem such = (TridentItem)item;
            return LootEvent.hasSuch(player, (Item)such);
        }
        if (item instanceof ShieldItem) {
            ShieldItem such = (ShieldItem)item;
            return LootEvent.hasSuch(player, (Item)such);
        }
        if (item instanceof ShearsItem) {
            ShearsItem such = (ShearsItem)item;
            return LootEvent.hasSuch(player, (Item)such);
        }
        if (item instanceof BoatItem) {
            BoatItem such = (BoatItem)item;
            return LootEvent.hasSuch(player, (Item)such);
        }
        if (item instanceof ElytraItem) {
            ElytraItem such = (ElytraItem)item;
            return LootEvent.hasSuch(player, (Item)such);
        }
        if (item instanceof BowItem) {
            BowItem such = (BowItem)item;
            return LootEvent.hasSuch(player, (Item)such);
        }
        if (item instanceof CrossbowItem) {
            CrossbowItem such = (CrossbowItem)item;
            return LootEvent.hasSuch(player, (Item)such);
        }
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return LootEvent.hasOrSwearing(player, armorItem);
        }
        return !LootEvent.canMerge(player, stack);
    }

    private static boolean canMerge(Player player, ItemStack stack) {
        return player.f_36095_.f_38839_.stream().anyMatch(slot -> ItemStack.m_150942_((ItemStack)slot.m_7993_(), (ItemStack)stack));
    }

    private static boolean hasSuch(Player player, Item item) {
        return player.f_36095_.f_38839_.stream().anyMatch(slot -> slot.m_7993_().m_41720_().getClass() == item.getClass());
    }

    private static boolean hasOrSwearing(Player player, ArmorItem armor) {
        EquipmentSlot slot = armor.m_40402_();
        ItemStack equipped = player.m_6844_(slot);
        if (equipped.m_41619_()) {
            return player.f_36095_.f_38839_.stream().anyMatch(slt -> {
                ArmorItem a1;
                Item patt9359$temp = slt.m_7993_().m_41720_();
                return patt9359$temp instanceof ArmorItem && (a1 = (ArmorItem)patt9359$temp).m_40402_() == slot;
            });
        }
        return true;
    }

    private static int repairPlayerItems(Player player, int repairAmount) {
        Map.Entry entry = EnchantmentHelper.m_44839_((Enchantment)Enchantments.f_44962_, (LivingEntity)player, ItemStack::m_41768_);
        if (entry != null) {
            ItemStack itemstack = (ItemStack)entry.getValue();
            int i = Math.min((int)((float)repairAmount * itemstack.getXpRepairRatio()), itemstack.m_41773_());
            itemstack.m_41721_(itemstack.m_41773_() - i);
            int j = repairAmount - i / 2;
            return j > 0 ? LootEvent.repairPlayerItems(player, j) : 0;
        }
        return repairAmount;
    }

    private static boolean isPlayerEnabledAutoPick(Player player) {
        return ModRegistries.NbtAttachments.getSyncedConfig().computeIfAbsent(player).autoPicking();
    }
}

