/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.forge.mixin;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.util.recipeTransferHelper.RecipeItemProvider;
import javax.annotation.Nullable;
import net.minecraft.recipebook.ServerPlaceRecipe;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ServerPlaceRecipe.class})
public class ServerPlaceRecipeMixin<C extends Container> {
    @Final
    @Shadow
    protected StackedContents f_135426_;
    @Unique
    @Nullable
    private EndlessInventory endInv;

    @Inject(method={"recipeClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/RecipeBookMenu;fillCraftSlotsStackedContents(Lnet/minecraft/world/entity/player/StackedContents;)V")})
    private void fillEndInvStackedContents(ServerPlayer player, Recipe<C> recipe, boolean placeAll, CallbackInfo ci) {
        this.endInv = ServerLevelEndInv.getEndInvForPlayer((Player)player).orElse(null);
        if (this.endInv == null) {
            return;
        }
        RecipeItemProvider.fillStackedContents(this.endInv.getItemsAsList(), this.f_135426_);
    }

    @Inject(method={"recipeClicked"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/recipebook/ServerPlaceRecipe;handleRecipeClicked(Lnet/minecraft/world/item/crafting/Recipe;Z)V")})
    private void finishHandleClick(ServerPlayer player, Recipe<C> recipe, boolean placeAll, CallbackInfo ci) {
        if (this.endInv != null) {
            this.endInv.broadcastChanges();
        }
    }

    @Inject(method={"moveItemToGrid"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void getAttachedItems(Slot slotToFill, ItemStack ingredient, CallbackInfo ci, int i, ItemStack itemstack) {
        if (i != -1 || this.endInv == null) {
            return;
        }
        ItemStack itemStack1 = this.endInv.takeItem(ingredient, 1);
        if (itemStack1.m_41619_()) {
            return;
        }
        if (slotToFill.m_7993_().m_41619_()) {
            slotToFill.m_5852_(itemStack1.m_41777_());
        } else {
            slotToFill.m_7993_().m_41769_(itemStack1.m_41613_());
        }
    }
}

