/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.SourceInventory;
import com.kwwsyk.endinv.common.network.payloads.toClient.EndInvMetadata;
import com.kwwsyk.endinv.common.options.ContentTransferMode;
import com.kwwsyk.endinv.common.util.ItemKey;
import com.kwwsyk.endinv.common.util.ItemState;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.world.item.ItemStack;

public class CachedSrcInv
extends SourceInventory {
    public static final CachedSrcInv INSTANCE = new CachedSrcInv();
    private int itemSize;
    private boolean validSize;

    private CachedSrcInv() {
        super(ModInfo.DEFAULT_UUID);
    }

    public void initializeContents(Map<ItemKey, ItemState> itemMap) {
        this.overwriteItems((Map<ItemKey, ItemState>)new Object2ObjectLinkedOpenHashMap(itemMap));
        this.itemSize = this.getItemSize();
        this.validSize = true;
    }

    @Override
    public int getItemSize() {
        if (ModInfo.getServerConfig().transferMode().get() == ContentTransferMode.PART) {
            return this.itemSize;
        }
        if (this.validSize) {
            return this.itemSize;
        }
        return super.getItemSize();
    }

    @Override
    public ItemStack takeItem(ItemStack stack, int count) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemKey key = ItemKey.asKey(stack);
        ItemState state = (ItemState)this.itemMap.get(key);
        if (state == null) {
            return ItemStack.EMPTY;
        }
        if (state.count() >= this.maxStackSize && this.infinityMode) {
            this.setChanged();
            return stack.copyWithCount(count);
        }
        int taken = Math.min(count, state.count());
        ItemStack result = stack.copyWithCount(taken);
        if (taken == state.count()) {
            this.itemMap.remove(key);
            this.updateLastModTime();
        } else {
            this.itemMap.put(key, new ItemState(state.count() - taken, this.updateLastModTime()));
        }
        this.setChanged();
        return result;
    }

    @Override
    public ItemStack addItem(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemKey key = ItemKey.asKey(itemStack);
        ItemState state = (ItemState)this.itemMap.get(key);
        int count = itemStack.getCount();
        int original = 0;
        if (state != null) {
            original = state.count();
        }
        if (original < this.maxStackSize) {
            int increased = original + count;
            if (increased <= this.maxStackSize) {
                this.itemMap.put(key, new ItemState(increased, this.updateLastModTime()));
                this.setChanged();
                return ItemStack.EMPTY;
            }
            this.itemMap.put(key, new ItemState(this.maxStackSize, this.updateLastModTime()));
            this.setChanged();
            return itemStack.copyWithCount(increased - this.maxStackSize);
        }
        if (this.infinityMode) {
            this.itemMap.put(key, new ItemState(original, this.updateLastModTime()));
            this.setChanged();
            return ItemStack.EMPTY;
        }
        return itemStack.copy();
    }

    @Override
    public void setChanged() {
        super.setChanged();
        this.validSize = false;
    }

    @Override
    public long updateLastModTime() {
        return Util.getMillis();
    }

    public void syncMetadata(EndInvMetadata endInvMetadata) {
        this.itemSize = endInvMetadata.itemSize();
        this.maxStackSize = endInvMetadata.maxStackSize();
        this.infinityMode = endInvMetadata.infinityMode();
        this.accessibility = endInvMetadata.config().accessibility();
        this.owner = endInvMetadata.config().owner();
        this.white_list = endInvMetadata.config().white_list();
    }
}

