/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui.page;

import com.kwwsyk.endinv.common.client.CachedSrcInv;
import com.kwwsyk.endinv.common.client.gui.page.ItemPage;
import com.kwwsyk.endinv.common.client.gui.page.manager.PageManager;
import com.kwwsyk.endinv.common.client.option.CachedConfig;
import com.kwwsyk.endinv.common.menu.page.PageType;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemDisplay
extends ItemPage {
    public ItemDisplay(PageType pageType, PageManager metaDataManager) {
        super(pageType, metaDataManager);
    }

    @Override
    public void refreshItems() {
        this.requestRemoteContents();
        this.readCachedItems();
    }

    public void readCachedItems() {
        List<ItemStack> view = CachedSrcInv.INSTANCE.getSortedAndFilteredItemView(this.startIndex, this.length, CachedConfig.sortType(), CachedConfig.reverseSort(), this.getClassify(), CachedConfig.searching());
        this.buildContentsWith(view);
    }

    @Override
    public void requestRemoteContents() {
        this.sendChangesToServer();
    }

    public void buildContentsWith(@NotNull List<ItemStack> stacks) {
        if (this.holdOn) {
            this.inQueueStacks = stacks;
            return;
        }
        for (int i = 0; i < this.length; ++i) {
            if (i < stacks.size() && stacks.get(i) != null) {
                this.items.set(i, (Object)stacks.get(i).copy());
                continue;
            }
            this.items.set(i, (Object)ItemStack.EMPTY);
        }
    }

    @Override
    public boolean hasSearchbox() {
        return true;
    }

    @Override
    public boolean hasSortTypeSwitchBar() {
        return true;
    }

    @Override
    public ItemStack takeItem(ItemStack itemStack, int count) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack) || this.isInfinite(stack)) continue;
            if (count < stack.getCount()) {
                stack.split(count);
            } else {
                stack.setCount(0);
                this.items.set(i, (Object)stack);
            }
            this.setChanged();
        }
        return this.srcInv.takeItem(itemStack, count);
    }

    @Override
    public ItemStack takeItem(int index, int count) {
        ItemStack itemStack = (ItemStack)this.items.get(index);
        ItemStack ret = itemStack.copy();
        if (!this.isInfinite(itemStack)) {
            if (count < itemStack.getCount()) {
                itemStack.split(count);
                ret.setCount(count);
            } else {
                itemStack = ItemStack.EMPTY;
            }
            this.items.set(index, (Object)itemStack);
        }
        return ret;
    }

    @Override
    public ItemStack addItem(ItemStack itemStack) {
        ItemStack remain;
        ItemStack ret = ItemStack.EMPTY;
        int count = itemStack.getCount();
        for (int i = 0; i < this.length; ++i) {
            ItemStack itemStack1 = (ItemStack)this.items.get(i);
            if (ItemStack.isSameItemSameComponents((ItemStack)itemStack1, (ItemStack)itemStack)) {
                if (!this.isFull(itemStack1)) {
                    int additional = itemStack1.getCount();
                    int max = this.meta.getMaxStackSize();
                    itemStack1.setCount(Math.min(count + additional, max));
                    ret = itemStack.copyWithCount(Math.max(0, count + additional - max));
                }
                if (!this.isInfinite(itemStack1)) break;
                ret = ItemStack.EMPTY;
                break;
            }
            if (!itemStack1.isEmpty()) continue;
            itemStack.setCount(Math.min(itemStack.getCount(), this.meta.getMaxStackSize()));
            this.items.set(i, (Object)itemStack);
            ret = itemStack.copyWithCount(Math.max(0, count - this.meta.getMaxStackSize()));
            break;
        }
        if (!(remain = this.srcInv.addItem(itemStack.copy())).isEmpty()) {
            ret = remain;
        }
        return ret;
    }

    @Override
    public void release() {
        if (this.holdOn) {
            this.holdOn = false;
            if (this.inQueueStacks == null) {
                return;
            }
            this.buildContentsWith(this.inQueueStacks);
        }
    }
}

