/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui.page;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.client.gui.page.ItemPage;
import com.kwwsyk.endinv.common.client.gui.page.manager.PageManager;
import com.kwwsyk.endinv.common.menu.page.PageType;
import com.kwwsyk.endinv.common.network.payloads.toServer.StarItemPayload;
import com.kwwsyk.endinv.common.util.ItemStackLike;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class StarredItemPage
extends ItemPage {
    public ResourceLocation icon = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"book");
    private int[] countArray;

    public StarredItemPage(PageType type, PageManager metaDataManager) {
        super(type, metaDataManager);
    }

    public void starItem(ItemStack stack, boolean isAdding) {
        if (stack.isEmpty()) {
            return;
        }
        ModInfo.getPacketDistributor().sendToServer(new StarItemPayload(stack, isAdding));
        this.requestRemoteContents();
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public void initializeContents(int startIndex, int length) {
        this.startIndex = startIndex;
        this.length = Math.min(length, this.meta.rows() * this.meta.columns());
        this.items = NonNullList.withSize((int)length, (Object)ItemStack.EMPTY);
        this.countArray = new int[length];
        this.refreshItems();
    }

    @Override
    public void refreshItems() {
        this.requestRemoteContents();
    }

    public void initializeContents(@NotNull List<ItemStack> stacks) {
        if (this.holdOn) {
            this.inQueueStacks = stacks;
            return;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (i < stacks.size() && stacks.get(i) != null) {
                this.items.set(i, (Object)stacks.get(i).copyWithCount(1));
                this.countArray[i] = stacks.get(i).getCount();
                continue;
            }
            this.items.set(i, (Object)ItemStack.EMPTY);
        }
    }

    public void initializeAsMap(@NotNull List<ItemStackLike> stacks) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (i < stacks.size() && stacks.get(i) != null) {
                this.items.set(i, (Object)stacks.get(i).toKey());
                this.countArray[i] = stacks.get(i).count();
                continue;
            }
            this.items.set(i, (Object)ItemStack.EMPTY);
        }
    }

    @Override
    public void requestRemoteContents() {
        this.sendChangesToServer();
    }

    @Override
    public boolean hasSearchbox() {
        return true;
    }

    @Override
    public boolean hasSortTypeSwitchBar() {
        return false;
    }

    @Override
    public void renderPage(GuiGraphics guiGraphics) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
        int rowIndex = 0;
        int columnIndex = 0;
        for (int i = 0; i < this.length; ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            int count = this.countArray[i];
            guiGraphics.renderItem(stack, this.leftPos + columnIndex * 18, this.topPos + rowIndex * 18 + 1, columnIndex + rowIndex * 180);
            if (!this.isHiddenBySortBox(rowIndex, columnIndex)) {
                guiGraphics.renderItemDecorations(Minecraft.getInstance().font, stack, this.leftPos + columnIndex * 18, this.topPos + rowIndex * 18 + 1, this.getDisplayAmount(stack.copyWithCount(count)));
            }
            if (++columnIndex < this.meta.columns()) continue;
            columnIndex = 0;
            ++rowIndex;
        }
        guiGraphics.pose().popPose();
    }

    @Override
    public void handleStarItem(double XOffset, double YOffset) {
        int slot = this.getSlotByMouseOffset(XOffset, YOffset);
        if (slot >= 0 && slot < this.items.size()) {
            ItemStack clicked = (ItemStack)this.items.get(slot);
            this.starItem(clicked, false);
        }
    }

    @Override
    public void release() {
        if (this.holdOn) {
            this.holdOn = false;
            if (this.inQueueStacks == null) {
                return;
            }
            this.initializeContents(this.inQueueStacks);
        }
    }
}

