/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui.widget;

import com.kwwsyk.endinv.common.client.gui.ScreenFramework;
import com.kwwsyk.endinv.common.client.gui.bg.ScreenRectangleWidgetParam;
import com.kwwsyk.endinv.common.client.gui.page.manager.PageManager;
import com.kwwsyk.endinv.common.client.option.CachedConfig;
import com.kwwsyk.endinv.common.util.SortType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class SortTypeSwitchBox
extends AbstractWidget {
    public ScreenFramework screen;
    private final PageManager pageManager;
    private final int singleBoxHeight;
    private boolean isOpen;

    public SortTypeSwitchBox(ScreenFramework screen, PageManager pageManager, int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.empty());
        this.screen = screen;
        this.pageManager = pageManager;
        this.singleBoxHeight = height;
    }

    public SortTypeSwitchBox(ScreenFramework screen, PageManager pageManager, ScreenRectangleWidgetParam sortTypeSwitchBoxParam) {
        this(screen, pageManager, sortTypeSwitchBoxParam.XPos(), sortTypeSwitchBoxParam.YPos(), sortTypeSwitchBoxParam.XSize(), sortTypeSwitchBoxParam.YSize());
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setOpen(boolean open) {
        this.isOpen = open;
        this.height = open ? this.singleBoxHeight * (1 + SortType.values().length) : this.singleBoxHeight;
    }

    public void onClick(double mouseX, double mouseY) {
        if (!this.isOpen) {
            this.setOpen(true);
        } else {
            int y1 = this.getY() + this.singleBoxHeight;
            for (SortType type : SortType.values()) {
                if (this.isHoveringOnSingleBox((int)mouseY, y1)) {
                    this.screen.switchSortTypeTo(type);
                    return;
                }
                y1 += this.singleBoxHeight;
            }
            this.setOpen(false);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.active && this.visible && !this.clicked(mouseX, mouseY) && this.isOpen) {
            this.setOpen(false);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 500.0f);
        guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.singleBoxHeight, -7829368);
        guiGraphics.fill(this.getX() + 1, this.getY() + 1, this.getX() + this.width - 1, this.getY() + this.singleBoxHeight - 1, -16777216);
        if (this.isHoveringOnSingleBox(mouseY, this.getY())) {
            guiGraphics.fillGradient(RenderType.guiOverlay(), this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.singleBoxHeight, -2130706433, -2130706433, 0);
        }
        SortType sortType = CachedConfig.sortType();
        String s = sortType.toString();
        guiGraphics.drawString(Minecraft.getInstance().font, s, this.getX() + 2, this.getY() + 2, -1);
        if (this.isOpen) {
            int y1 = this.getY() + this.singleBoxHeight;
            for (SortType type : SortType.values()) {
                guiGraphics.fill(RenderType.gui(), this.getX(), y1, this.getX() + this.width, y1 + this.singleBoxHeight, 0, -7829368);
                guiGraphics.fill(RenderType.gui(), this.getX() + 1, y1 + 1, this.getX() + this.width - 1, y1 + this.singleBoxHeight - 1, 0, -16777216);
                if (this.isHoveringOnSingleBox(mouseY, y1)) {
                    guiGraphics.fillGradient(RenderType.guiOverlay(), this.getX(), y1, this.getX() + this.width, y1 + this.singleBoxHeight, -2130706433, -2130706433, 0);
                    guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.translatable((String)type.translationKey), mouseX, mouseY);
                }
                s = type.toString();
                guiGraphics.drawString(Minecraft.getInstance().font, s, this.getX() + 2, y1 + 2, -1);
                y1 += this.singleBoxHeight;
            }
        }
        guiGraphics.pose().popPose();
    }

    private boolean isHoveringOnSingleBox(int mouseY, int minY) {
        return mouseY >= minY && mouseY <= minY + this.singleBoxHeight && this.isHovered;
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }
}

