/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.commands;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.data.EndlessInventoryData;
import com.kwwsyk.endinv.common.menu.EndlessInventoryMenu;
import com.kwwsyk.endinv.common.util.Accessibility;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;

public class EndInvCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"endinv").then(((LiteralArgumentBuilder)Commands.literal((String)"backup").requires(src -> src.hasPermission(1))).executes(context -> {
            EndlessInventoryData.BackupResult result = EndlessInventoryData.backup(((CommandSourceStack)context.getSource()).getLevel());
            if (result.success()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Backed up at " + result.message())), true);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Cannot backup as" + result.message())));
            return -1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"ofIndex").executes(context -> EndInvCommand.getCurrentIndex((CommandSourceStack)context.getSource()))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(context -> EndInvCommand.byIndexGet((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index")))).then(Commands.literal((String)"open").executes(context -> EndInvCommand.byIndexOpen((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"))))).then(((LiteralArgumentBuilder)Commands.literal((String)"setDefault").requires(src -> src.hasPermission(1))).executes(context -> EndInvCommand.byIndexSetDefault((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"))))).then(((LiteralArgumentBuilder)Commands.literal((String)"setOwner").requires(src -> src.hasPermission(1))).executes(context -> EndInvCommand.byIndexSetOwner((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"))))).then(Commands.literal((String)"addWhitelist").executes(context -> EndInvCommand.byIndexAddWhitelist((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"))))).then(Commands.literal((String)"removeWhitelist").executes(context -> EndInvCommand.byIndexRemoveWhitelist((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"setAccessibility").then(Commands.literal((String)"public").executes(context -> EndInvCommand.byIndexSetAccessibility((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), Accessibility.PUBLIC)))).then(Commands.literal((String)"restricted").executes(context -> EndInvCommand.byIndexSetAccessibility((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), Accessibility.RESTRICTED)))).then(Commands.literal((String)"private").executes(context -> EndInvCommand.byIndexSetAccessibility((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), Accessibility.PRIVATE))))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(src -> src.hasPermission(1))).then(Commands.argument((String)"forceRemove", (ArgumentType)BoolArgumentType.bool()).executes(context -> EndInvCommand.byIndexRemove((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), BoolArgumentType.getBool((CommandContext)context, (String)"forceRemove")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"new").requires(src -> src.hasPermission(1))).executes(context -> EndInvCommand.createNew((CommandSourceStack)context.getSource(), Accessibility.PUBLIC))).then(Commands.literal((String)"public").executes(context -> EndInvCommand.createNew((CommandSourceStack)context.getSource(), Accessibility.PUBLIC)))).then(Commands.literal((String)"restricted").executes(context -> EndInvCommand.createNew((CommandSourceStack)context.getSource(), Accessibility.RESTRICTED)))).then(Commands.literal((String)"private").executes(context -> EndInvCommand.createNew((CommandSourceStack)context.getSource(), Accessibility.PRIVATE)))));
    }

    private static int byIndexRemove(CommandSourceStack source, int index, boolean forced) {
        EndlessInventory endlessInventory = ServerLevelEndInv.levelEndInvData.fromIndex(index);
        if (endlessInventory == null) {
            source.sendFailure((Component)Component.literal((String)("Cannot get EndInv by index " + index)));
            return -1;
        }
        EndlessInventoryData.BackupResult result = EndlessInventoryData.backup(source.getLevel());
        if (!result.success()) {
            if (forced) {
                ServerLevelEndInv.levelEndInvData.byIndexRemove(index);
                source.sendSuccess(() -> Component.literal((String)("Force-removed " + String.valueOf(endlessInventory.getUuid()))), true);
                return index;
            }
            source.sendFailure((Component)Component.literal((String)("Cannot backup as " + result.message())));
            return -1;
        }
        source.sendSuccess(() -> Component.literal((String)("Backed up at " + result.message())), true);
        source.sendSuccess(() -> Component.literal((String)("Removed " + String.valueOf(endlessInventory.getUuid()))), true);
        return index;
    }

    private static int byIndexAddWhitelist(CommandSourceStack source, int index) {
        try {
            ServerPlayer player = source.getPlayerOrException();
            EndlessInventory endlessInventory = ServerLevelEndInv.levelEndInvData.fromIndex(index);
            if (endlessInventory == null) {
                source.sendFailure((Component)Component.literal((String)("Cannot get EndInv by index " + index)));
                return -1;
            }
            if (!endlessInventory.isOwner((Player)player) && !source.hasPermission(1)) {
                source.sendFailure((Component)Component.translatable((String)"endinv.callback.not_owner"));
                return -1;
            }
            endlessInventory.white_list.add(player.getUUID());
            source.sendSuccess(() -> Component.literal((String)("Add " + player.getName().getString() + " to " + String.valueOf(endlessInventory.getUuid()) + "'s whitelist.")), true);
            return index;
        }
        catch (CommandSyntaxException e) {
            source.sendFailure((Component)Component.literal((String)"A player must execute this command."));
            return -1;
        }
    }

    private static int byIndexRemoveWhitelist(CommandSourceStack source, int index) {
        try {
            ServerPlayer player = source.getPlayerOrException();
            EndlessInventory endlessInventory = ServerLevelEndInv.levelEndInvData.fromIndex(index);
            if (endlessInventory == null) {
                source.sendFailure((Component)Component.literal((String)("Cannot get EndInv by index " + index)));
                return -1;
            }
            if (endlessInventory.isOwner((Player)player) || source.hasPermission(1)) {
                if (!endlessInventory.white_list.remove(player.getUUID())) {
                    source.sendFailure((Component)Component.literal((String)(player.getName().getString() + " is not in " + String.valueOf(endlessInventory.getUuid()) + "'s whitelist.")));
                    return -1;
                }
            } else {
                source.sendFailure((Component)Component.translatable((String)"endinv.callback.not_owner"));
                return -1;
            }
            source.sendSuccess(() -> Component.literal((String)("Remove " + player.getName().getString() + " from " + String.valueOf(endlessInventory.getUuid()) + "'s whitelist.")), true);
            return index;
        }
        catch (CommandSyntaxException e) {
            source.sendFailure((Component)Component.literal((String)"A player must execute this command."));
            return -1;
        }
    }

    private static int byIndexSetAccessibility(CommandSourceStack source, int index, Accessibility accessibility) {
        try {
            ServerPlayer player = source.getPlayerOrException();
            EndlessInventory endlessInventory = ServerLevelEndInv.levelEndInvData.fromIndex(index);
            if (endlessInventory == null) {
                source.sendFailure((Component)Component.literal((String)("Cannot get EndInv by index " + index)));
                return -1;
            }
            if (!endlessInventory.isOwner((Player)player) && !source.hasPermission(1)) {
                source.sendFailure((Component)Component.translatable((String)"endinv.callback.not_owner"));
                return -1;
            }
            endlessInventory.setAccessibility(accessibility);
            source.sendSuccess(() -> Component.literal((String)("Set " + String.valueOf(endlessInventory.getUuid()) + "'s accessibility to" + String.valueOf((Object)accessibility))), true);
            return index;
        }
        catch (CommandSyntaxException e) {
            source.sendFailure((Component)Component.literal((String)"A player must execute this command."));
            return -1;
        }
    }

    private static int byIndexSetOwner(CommandSourceStack source, int index) {
        try {
            ServerPlayer player = source.getPlayerOrException();
            EndlessInventory endlessInventory = ServerLevelEndInv.levelEndInvData.fromIndex(index);
            if (endlessInventory == null) {
                source.sendFailure((Component)Component.literal((String)("Cannot get EndInv by index " + index)));
                return -1;
            }
            endlessInventory.setOwner(player.getUUID());
            source.sendSuccess(() -> Component.literal((String)("Set " + String.valueOf(endlessInventory.getUuid()) + "'s owner to" + player.getName().getString())), true);
            return index;
        }
        catch (CommandSyntaxException e) {
            source.sendFailure((Component)Component.literal((String)"A player must execute this command."));
            return -1;
        }
    }

    private static int createNew(CommandSourceStack source, Accessibility accessibility) {
        try {
            ServerPlayer player = source.getPlayerOrException();
            switch (accessibility) {
                case PUBLIC: {
                    EndlessInventory endInv = ServerLevelEndInv.createPublicEndInv();
                    source.sendSuccess(() -> Component.literal((String)("Created a new public endInv with uuid: " + String.valueOf(endInv.getUuid()))), true);
                    break;
                }
                case RESTRICTED: {
                    EndlessInventory endInv = ServerLevelEndInv.createPublicEndInv();
                    endInv.setAccessibility(Accessibility.RESTRICTED);
                    source.sendSuccess(() -> Component.literal((String)("Created a new white_list endInv with uuid: " + String.valueOf(endInv.getUuid()))), true);
                    endInv.white_list.add(player.getUUID());
                    source.sendSuccess(() -> Component.literal((String)"Add current player to white list"), true);
                    break;
                }
                case PRIVATE: {
                    EndlessInventory endInv = ServerLevelEndInv.createPublicEndInv();
                    endInv.setAccessibility(Accessibility.PRIVATE);
                    endInv.setOwner(player.getUUID());
                    source.sendSuccess(() -> Component.literal((String)("Created a new private endInv with uuid: " + String.valueOf(endInv.getUuid()) + ", with owner : " + player.getName().getString())), true);
                }
            }
            return 1;
        }
        catch (CommandSyntaxException e) {
            source.sendFailure((Component)Component.literal((String)"A player must execute this command."));
            return -1;
        }
    }

    private static int byIndexSetDefault(CommandSourceStack source, int index) {
        try {
            ServerPlayer player = source.getPlayerOrException();
            EndlessInventory endlessInventory = ServerLevelEndInv.levelEndInvData.fromIndex(index);
            if (endlessInventory == null) {
                source.sendFailure((Component)Component.literal((String)("Cannot get EndInv by index " + index)));
                return -1;
            }
            ModRegistries.NbtAttachments.getEndInvUUID().setTo((Player)player, endlessInventory.getUuid());
            source.sendSuccess(() -> Component.literal((String)("Set player's default endInv with uuid: " + String.valueOf(endlessInventory.getUuid()))), true);
            return index;
        }
        catch (CommandSyntaxException e) {
            source.sendFailure((Component)Component.literal((String)"A player must execute this command."));
            return -1;
        }
    }

    private static int byIndexOpen(CommandSourceStack source, int index) {
        try {
            ServerPlayer player = source.getPlayerOrException();
            EndlessInventory endlessInventory = ServerLevelEndInv.levelEndInvData.fromIndex(index);
            if (endlessInventory == null) {
                source.sendFailure((Component)Component.literal((String)("Cannot get EndInv by index " + index)));
                return -1;
            }
            if (endlessInventory.accessible((Player)player)) {
                ServerLevelEndInv.TEMP_ENDINV_REG.put(player, endlessInventory);
                player.openMenu((MenuProvider)new SimpleMenuProvider(EndlessInventoryMenu::createWithTemp, (Component)Component.empty()));
            } else if (source.hasPermission(1)) {
                ServerLevelEndInv.TEMP_ENDINV_REG.put(player, endlessInventory);
                player.openMenu((MenuProvider)new SimpleMenuProvider(EndlessInventoryMenu::createWithTemp, (Component)Component.empty()));
                source.sendSuccess(() -> Component.literal((String)"Opened an unaccessible endInv for op"), true);
            } else {
                source.sendFailure((Component)Component.translatable((String)"endinv.callback.no_access"));
                return -1;
            }
            return index;
        }
        catch (CommandSyntaxException e) {
            source.sendFailure((Component)Component.literal((String)"A player must execute this command."));
            return -1;
        }
    }

    private static int byIndexGet(CommandSourceStack source, int index) {
        try {
            EndlessInventory endlessInventory = ServerLevelEndInv.levelEndInvData.fromIndex(index);
            if (endlessInventory == null) {
                source.sendFailure((Component)Component.literal((String)("Cannot get EndInv by index " + index)));
                return -1;
            }
            source.sendSuccess(() -> Component.literal((String)("Found endInv with uuid: " + String.valueOf(endlessInventory.getUuid()))), true);
            return index;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static int getCurrentIndex(CommandSourceStack source) {
        try {
            ServerPlayer serverPlayer = source.getPlayerOrException();
            if (!ServerLevelEndInv.hasEndInvUuid((Player)serverPlayer)) {
                source.sendFailure((Component)Component.literal((String)"This player has not EndInv."));
                return -1;
            }
            Optional<EndlessInventory> optional = ServerLevelEndInv.getEndInvForPlayer((Player)serverPlayer);
            if (optional.isPresent()) {
                EndlessInventory endlessInventory = optional.get();
                int index = ServerLevelEndInv.levelEndInvData.getIndex(endlessInventory);
                source.sendSuccess(() -> Component.literal((String)("EndInv index: " + index)), true);
                return index;
            }
            source.sendFailure((Component)Component.literal((String)"Cannot get EndInv for player."));
            return -1;
        }
        catch (CommandSyntaxException e) {
            source.sendFailure((Component)Component.literal((String)"A player must execute this command."));
            return -1;
        }
    }
}

