/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.data;

import com.kwwsyk.endinv.common.EndInvAffinities;
import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.util.Accessibility;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public interface EndInvCodecStrategy {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String ITEM_ID_KEY = "id";
    public static final String ITEM_COUNT_KEY = "count";
    public static final String DEPRECATED_COUNT_KEY = "Count";
    public static final String COMPONENTS_KEY = "components";
    public static final String END_INV_LIST_KEY = "endless_inventories";
    public static final String ITEM_LIST_KEY = "Items";
    public static final String SIZE_INT_KEY = "Size";
    public static final String LAST_MOD_TIME_LONG_KEY = "modState";
    public static final String UUID_KEY = "uuid";
    public static final String MAX_STACK_SIZE_INT_KEY = "maxItemStackSize";
    public static final String INFINITY_BOOL_KEY = "Infinity";
    public static final String AFFINITY_KEY = "Affinities";
    public static final String BOOKMARK_LIST_KEY = "starred_items";
    public static final String OWNER_UUID_KEY = "Owner";
    public static final String WHITE_LIST_KEY = "white_list";
    public static final String ACCESSIBILITY_KEY = "Accessibility";
    public static final Codec<ItemStack> ITEM_STACK_CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.ITEM_NON_AIR_CODEC.fieldOf(ITEM_ID_KEY).forGetter(ItemStack::getItemHolder), (App)Codec.INT.fieldOf(ITEM_COUNT_KEY).orElse((Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf(COMPONENTS_KEY, (Object)DataComponentPatch.EMPTY).forGetter(ItemStack::getComponentsPatch)).apply((Applicative)instance, ItemStack::new)));

    default public EndlessInventory deserializeEndInv(CompoundTag invTag, HolderLookup.Provider provider) {
        EndlessInventory endlessInventory = new EndlessInventory(invTag.getUUID(UUID_KEY));
        this.deserializeItems(endlessInventory, invTag, provider);
        this.decodeAffinities(endlessInventory, (CompoundTag)invTag.get(AFFINITY_KEY), provider);
        if (invTag.contains(OWNER_UUID_KEY)) {
            endlessInventory.setOwner(invTag.getUUID(OWNER_UUID_KEY));
        }
        if (invTag.contains(WHITE_LIST_KEY)) {
            endlessInventory.white_list.addAll(invTag.getList(WHITE_LIST_KEY, 11).stream().map(NbtUtils::loadUUID).toList());
        }
        if (invTag.contains(ACCESSIBILITY_KEY)) {
            endlessInventory.setAccessibility(Accessibility.valueOf(invTag.getString(ACCESSIBILITY_KEY)));
        }
        if (invTag.contains(MAX_STACK_SIZE_INT_KEY)) {
            endlessInventory.setMaxItemStackSize(invTag.getInt(MAX_STACK_SIZE_INT_KEY));
        }
        if (invTag.contains(INFINITY_BOOL_KEY)) {
            endlessInventory.setInfinityMode(invTag.getBoolean(INFINITY_BOOL_KEY));
        }
        return endlessInventory;
    }

    default public CompoundTag serializeEndInv(EndlessInventory endInv, HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        CompoundTag itemData = this.serializeItems(endInv, provider);
        nbt.merge(itemData);
        CompoundTag affTag = this.encodeAffinities(endInv.affinities, provider);
        nbt.put(AFFINITY_KEY, (Tag)affTag);
        nbt.putUUID(UUID_KEY, endInv.getUuid());
        if (endInv.getOwnerUUID() != null) {
            nbt.putUUID(OWNER_UUID_KEY, endInv.getOwnerUUID());
        }
        ListTag whiteList = new ListTag();
        for (UUID uuid : endInv.white_list) {
            whiteList.add((Object)NbtUtils.createUUID((UUID)uuid));
        }
        nbt.put(WHITE_LIST_KEY, (Tag)whiteList);
        nbt.putString(ACCESSIBILITY_KEY, endInv.getAccessibility().name());
        nbt.putInt(MAX_STACK_SIZE_INT_KEY, endInv.getMaxItemStackSize());
        nbt.putBoolean(INFINITY_BOOL_KEY, endInv.isInfinityMode());
        return nbt;
    }

    public void deserializeItems(EndlessInventory var1, CompoundTag var2, HolderLookup.Provider var3);

    public CompoundTag serializeItems(EndlessInventory var1, HolderLookup.Provider var2);

    public boolean canHandle(CompoundTag var1);

    default public CompoundTag encodeAffinities(EndInvAffinities affinities, HolderLookup.Provider provider) {
        CompoundTag ret = new CompoundTag();
        ListTag nbtTagList = new ListTag();
        List<ItemStack> items = affinities.starredItems;
        for (ItemStack itemStack : items) {
            if (itemStack.isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            nbtTagList.add((Object)EndInvCodecStrategy.saveItem(itemStack.copyWithCount(1), itemTag, provider));
        }
        ret.put(BOOKMARK_LIST_KEY, (Tag)nbtTagList);
        return ret;
    }

    default public void decodeAffinities(EndlessInventory endlessInventory, @Nullable CompoundTag nbt, HolderLookup.Provider provider) {
        EndInvAffinities aff = endlessInventory.affinities;
        if (nbt == null) {
            return;
        }
        ListTag tagList = nbt.getList(BOOKMARK_LIST_KEY, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTag = tagList.getCompound(i);
            EndInvCodecStrategy.parse((Tag)itemTag, provider).filter(it -> !it.isEmpty()).ifPresent(aff::addStarredItem);
        }
    }

    public static Optional<ItemStack> parse(Tag tag, HolderLookup.Provider provider) {
        if (!(tag instanceof CompoundTag)) {
            return Optional.empty();
        }
        CompoundTag compound = (CompoundTag)tag;
        try {
            return Optional.of(EndInvCodecStrategy.loadItem(compound, provider));
        }
        catch (Exception e) {
            LOGGER.error("Tried to load invalid item: '{}'", (Object)compound, (Object)e);
            return Optional.empty();
        }
    }

    public static Tag saveItem(ItemStack itemStack, CompoundTag outputTag, HolderLookup.Provider provider) {
        if (itemStack.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return EndInvCodecStrategy.save(itemStack, outputTag, provider);
    }

    public static CompoundTag save(ItemStack stack, CompoundTag compoundTag, HolderLookup.Provider provider) {
        return (CompoundTag)ITEM_STACK_CODEC.encode((Object)stack, (DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compoundTag).getOrThrow();
    }

    public static ItemStack loadItem(CompoundTag compoundTag, HolderLookup.Provider provider) {
        try {
            if (compoundTag.contains(DEPRECATED_COUNT_KEY)) {
                ItemStack ret = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)compoundTag.getString(ITEM_ID_KEY))), compoundTag.getInt(DEPRECATED_COUNT_KEY));
                if (compoundTag.contains(COMPONENTS_KEY)) {
                    DataComponentPatch patch = (DataComponentPatch)DataComponentPatch.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compoundTag).getOrThrow();
                    ret.applyComponents(patch);
                }
                return ret;
            }
            return (ItemStack)ITEM_STACK_CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compoundTag).getOrThrow();
        }
        catch (RuntimeException runtimeexception) {
            LOGGER.debug("Tried to load invalid item: {}", (Object)compoundTag, (Object)runtimeexception);
            return ItemStack.EMPTY;
        }
    }
}

