/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.data;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.data.EndInvCodecStrategy;
import com.kwwsyk.endinv.common.util.ItemKey;
import com.kwwsyk.endinv.common.util.ItemState;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class FullCodecStrategy
implements EndInvCodecStrategy {
    @Override
    public boolean canHandle(CompoundTag tag) {
        ListTag list = tag.getList("Items", 10);
        return !list.isEmpty() && list.getCompound(0).contains("modState");
    }

    @Override
    public void deserializeItems(EndlessInventory endlessInventory, CompoundTag nbt, HolderLookup.Provider provider) {
        Map<ItemKey, ItemState> itemMap = endlessInventory.getItemMap();
        ListTag tagList = nbt.getList("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTag = tagList.getCompound(i);
            Optional<ItemStack> stackPre = EndInvCodecStrategy.parse((Tag)itemTag, provider).filter(it -> !it.isEmpty());
            long modState = itemTag.getLong("modState");
            endlessInventory.updateModState(modState);
            stackPre.ifPresent(itemStack -> itemMap.put(ItemKey.asKey(itemStack), new ItemState(itemStack.getCount(), modState)));
        }
    }

    @Override
    public CompoundTag serializeItems(EndlessInventory endlessInventory, HolderLookup.Provider provider) {
        ListTag nbtTagList = new ListTag();
        Map<ItemKey, ItemState> itemMap = endlessInventory.getItemMap();
        for (Map.Entry<ItemKey, ItemState> entry : itemMap.entrySet()) {
            ItemStack itemStack = entry.getKey().toStack(entry.getValue().count());
            if (itemStack.isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putLong("modState", entry.getValue().lastModTime());
            nbtTagList.add((Object)EndInvCodecStrategy.saveItem(itemStack, itemTag, provider));
        }
        CompoundTag nbt = new CompoundTag();
        nbt.put("Items", (Tag)nbtTagList);
        nbt.putInt("Size", itemMap.size());
        return nbt;
    }
}

