/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.menu;

import com.kwwsyk.endinv.common.menu.EndlessInventoryMenu;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class MenuClickHandler {
    public static void handleQuickCraft(EndlessInventoryMenu menu, int slotId, int button, Player player) {
        int i = menu.quickcraftStatus;
        menu.quickcraftStatus = AbstractContainerMenu.getQuickcraftHeader((int)button);
        if ((i != 1 || menu.quickcraftStatus != 2) && i != menu.quickcraftStatus || menu.getCarried().isEmpty()) {
            MenuClickHandler.resetQuickCraft(menu);
        } else {
            switch (menu.quickcraftStatus) {
                case 0: {
                    menu.quickcraftType = AbstractContainerMenu.getQuickcraftType((int)button);
                    if (AbstractContainerMenu.isValidQuickcraftType((int)menu.quickcraftType, (Player)player)) {
                        menu.quickcraftStatus = 1;
                        menu.quickcraftSlots.clear();
                        break;
                    }
                    MenuClickHandler.resetQuickCraft(menu);
                    break;
                }
                case 1: {
                    ItemStack itemstack;
                    if (slotId < 0) {
                        return;
                    }
                    Slot slot = (Slot)menu.slots.get(slotId);
                    if (!AbstractContainerMenu.canItemQuickReplace((Slot)slot, (ItemStack)(itemstack = menu.getCarried()), (boolean)true) || !slot.mayPlace(itemstack) || menu.quickcraftType != 2 && itemstack.getCount() <= menu.quickcraftSlots.size() || !menu.canDragTo(slot)) break;
                    menu.quickcraftSlots.add(slot);
                    break;
                }
                case 2: {
                    if (!menu.quickcraftSlots.isEmpty()) {
                        if (menu.quickcraftSlots.size() == 1) {
                            int i1 = menu.quickcraftSlots.iterator().next().index;
                            MenuClickHandler.resetQuickCraft(menu);
                            MenuClickHandler.handlePickup(menu, i1, menu.quickcraftType, player);
                            return;
                        }
                        ItemStack copiedCarried = menu.getCarried().copy();
                        if (copiedCarried.isEmpty()) {
                            MenuClickHandler.resetQuickCraft(menu);
                            return;
                        }
                        int count = menu.getCarried().getCount();
                        for (Slot slot1 : menu.quickcraftSlots) {
                            ItemStack carried = menu.getCarried();
                            if (slot1 == null || !AbstractContainerMenu.canItemQuickReplace((Slot)slot1, (ItemStack)carried, (boolean)true) || !slot1.mayPlace(carried) || menu.quickcraftType != 2 && carried.getCount() < menu.quickcraftSlots.size() || !menu.canDragTo(slot1)) continue;
                            int j = slot1.hasItem() ? slot1.getItem().getCount() : 0;
                            int k = Math.min(copiedCarried.getMaxStackSize(), slot1.getMaxStackSize(copiedCarried));
                            int l = Math.min(AbstractContainerMenu.getQuickCraftPlaceCount(menu.quickcraftSlots, (int)menu.quickcraftType, (ItemStack)copiedCarried) + j, k);
                            count -= l - j;
                            slot1.setByPlayer(copiedCarried.copyWithCount(l));
                        }
                        copiedCarried.setCount(count);
                        menu.setCarried(copiedCarried);
                    }
                    MenuClickHandler.resetQuickCraft(menu);
                    break;
                }
                default: {
                    MenuClickHandler.resetQuickCraft(menu);
                }
            }
        }
    }

    private static void resetQuickCraft(EndlessInventoryMenu EIM) {
        EIM.quickcraftStatus = 0;
        EIM.quickcraftSlots.clear();
    }

    public static void handlePickup(EndlessInventoryMenu EIM, int slotId, int button, Player player) {
        ClickAction clickaction;
        ClickAction clickAction = clickaction = button == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY;
        if (slotId == -999) {
            if (!EIM.getCarried().isEmpty()) {
                if (clickaction == ClickAction.PRIMARY) {
                    player.drop(EIM.getCarried(), true);
                    EIM.setCarried(ItemStack.EMPTY);
                } else {
                    player.drop(EIM.getCarried().split(1), true);
                }
            }
        } else if (slotId >= 0) {
            ItemStack carried;
            Slot clickedSlot = (Slot)EIM.slots.get(slotId);
            Container container = clickedSlot.container;
            ItemStack clickedSlotItem = clickedSlot.getItem();
            if (!EIM.tryItemClickBehaviourOverride(player, clickaction, clickedSlot, clickedSlotItem, carried = EIM.getCarried())) {
                MenuClickHandler.handleVanillaPickup(EIM, slotId, clickaction, player);
                clickedSlot.setChanged();
            }
        }
    }

    public static void handleVanillaPickup(AbstractContainerMenu menu, int slotId, ClickAction clickaction, Player player) {
        Slot clickedSlot = (Slot)menu.slots.get(slotId);
        ItemStack clickedSlotItem = clickedSlot.getItem();
        ItemStack carried = menu.getCarried();
        if (clickedSlotItem.isEmpty()) {
            if (!carried.isEmpty()) {
                int i3 = clickaction == ClickAction.PRIMARY ? carried.getCount() : 1;
                menu.setCarried(clickedSlot.safeInsert(carried, i3));
            }
        } else if (clickedSlot.mayPickup(player)) {
            if (carried.isEmpty()) {
                int j3 = clickaction == ClickAction.PRIMARY ? clickedSlotItem.getCount() : (clickedSlotItem.getCount() + 1) / 2;
                Optional optional1 = clickedSlot.tryRemove(j3, Integer.MAX_VALUE, player);
                optional1.ifPresent(p_150421_ -> {
                    menu.setCarried(p_150421_);
                    clickedSlot.onTake(player, p_150421_);
                });
            } else if (clickedSlot.mayPlace(carried)) {
                if (ItemStack.isSameItemSameComponents((ItemStack)clickedSlotItem, (ItemStack)carried)) {
                    int k3 = clickaction == ClickAction.PRIMARY ? carried.getCount() : 1;
                    menu.setCarried(clickedSlot.safeInsert(carried, k3));
                } else if (carried.getCount() <= clickedSlot.getMaxStackSize(carried)) {
                    menu.setCarried(clickedSlotItem);
                    clickedSlot.setByPlayer(carried);
                }
            } else if (ItemStack.isSameItemSameComponents((ItemStack)clickedSlotItem, (ItemStack)carried)) {
                Optional optional = clickedSlot.tryRemove(clickedSlotItem.getCount(), carried.getMaxStackSize() - carried.getCount(), player);
                optional.ifPresent(p_150428_ -> {
                    carried.grow(p_150428_.getCount());
                    clickedSlot.onTake(player, p_150428_);
                });
            }
        }
    }

    public static void handleQuickMove(AbstractContainerMenu menu, int slotId, int button, Player player) {
        ClickAction clickaction;
        ClickAction clickAction = clickaction = button == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY;
        if (slotId == -999) {
            if (!menu.getCarried().isEmpty()) {
                if (clickaction == ClickAction.PRIMARY) {
                    player.drop(menu.getCarried(), true);
                    menu.setCarried(ItemStack.EMPTY);
                } else {
                    player.drop(menu.getCarried().split(1), true);
                }
            }
        } else {
            if (slotId < 0) {
                return;
            }
            Slot clickedSlot = (Slot)menu.slots.get(slotId);
            if (!clickedSlot.mayPickup(player)) {
                return;
            }
            ItemStack itemstack8 = menu.quickMoveStack(player, slotId);
            while (!itemstack8.isEmpty() && ItemStack.isSameItem((ItemStack)clickedSlot.getItem(), (ItemStack)itemstack8)) {
                itemstack8 = menu.quickMoveStack(player, slotId);
            }
        }
    }

    public static void handleSwap(EndlessInventoryMenu EIM, int slotId, int button, Player player) {
        if ((button < 0 || button >= 9) && button != 40 || slotId <= 0) {
            return;
        }
        Slot clickedSlot = (Slot)EIM.slots.get(slotId);
        Container container = clickedSlot.container;
        MenuClickHandler.handleVanillaSwap(EIM, slotId, button, player);
    }

    public static void handleVanillaSwap(AbstractContainerMenu menu, int slotId, int button, Player player) {
        Inventory inventory = player.getInventory();
        ItemStack inventoryItem = inventory.getItem(button);
        Slot hoveringSlot = (Slot)menu.slots.get(slotId);
        ItemStack hoveringSlotItem = hoveringSlot.getItem();
        if (!inventoryItem.isEmpty() || !hoveringSlotItem.isEmpty()) {
            if (inventoryItem.isEmpty()) {
                if (hoveringSlot.mayPickup(player)) {
                    inventory.setItem(button, hoveringSlotItem);
                    hoveringSlot.setByPlayer(ItemStack.EMPTY);
                    hoveringSlot.onTake(player, hoveringSlotItem);
                }
            } else if (hoveringSlotItem.isEmpty()) {
                if (hoveringSlot.mayPlace(inventoryItem)) {
                    int j2 = hoveringSlot.getMaxStackSize(inventoryItem);
                    if (inventoryItem.getCount() > j2) {
                        hoveringSlot.setByPlayer(inventoryItem.split(j2));
                    } else {
                        inventory.setItem(button, ItemStack.EMPTY);
                        hoveringSlot.setByPlayer(inventoryItem);
                    }
                }
            } else if (hoveringSlot.mayPickup(player) && hoveringSlot.mayPlace(inventoryItem)) {
                int k2 = hoveringSlot.getMaxStackSize(inventoryItem);
                if (inventoryItem.getCount() > k2) {
                    hoveringSlot.setByPlayer(inventoryItem.split(k2));
                    hoveringSlot.onTake(player, hoveringSlotItem);
                    if (!inventory.add(hoveringSlotItem)) {
                        player.drop(hoveringSlotItem, true);
                    }
                } else {
                    inventory.setItem(button, hoveringSlotItem);
                    hoveringSlot.setByPlayer(inventoryItem);
                    hoveringSlot.onTake(player, hoveringSlotItem);
                }
            }
        }
    }

    public static void handleThrow(AbstractContainerMenu menu, int slotId, int button, Player player) {
        if (!menu.getCarried().isEmpty() || slotId < 0) {
            return;
        }
        Slot throwingSlot = (Slot)menu.slots.get(slotId);
        int throwingCount = button == 0 ? 1 : throwingSlot.getItem().getCount();
        ItemStack thrown = throwingSlot.safeTake(throwingCount, Integer.MAX_VALUE, player);
        player.drop(thrown, true);
        if (button == 1) {
            while (!thrown.isEmpty() && ItemStack.isSameItem((ItemStack)throwingSlot.getItem(), (ItemStack)thrown)) {
                thrown = throwingSlot.safeTake(throwingCount, Integer.MAX_VALUE, player);
                player.drop(thrown, true);
            }
        }
    }

    public static void handleClone(AbstractContainerMenu menu, int slotId, int button, Player player) {
        Slot slot4;
        if (player.getAbilities().instabuild && menu.getCarried().isEmpty() && slotId >= 0 && (slot4 = (Slot)menu.slots.get(slotId)).hasItem()) {
            ItemStack itemstack5 = slot4.getItem();
            menu.setCarried(itemstack5.copyWithCount(itemstack5.getMaxStackSize()));
        }
    }

    public static void handlePickupAll(EndlessInventoryMenu EIM, int slotId, int button, Player player) {
        if (slotId < 0) {
            return;
        }
        Slot clickedSlot = (Slot)EIM.slots.get(slotId);
        Container slotContainer = clickedSlot.container;
        ItemStack carried = EIM.getCarried();
        if (carried.isEmpty()) {
            return;
        }
        if (!clickedSlot.hasItem() || !clickedSlot.mayPickup(player)) {
            int startIndex = button == 0 ? 0 : EIM.slots.size() - 1;
            int inc = button == 0 ? 1 : -1;
            for (int l2 = 0; l2 < 2; ++l2) {
                for (int index = startIndex; index >= 0 && index < EIM.slots.size() && carried.getCount() < carried.getMaxStackSize(); index += inc) {
                    Slot scanningSlot = (Slot)EIM.slots.get(index);
                    if (!AbstractContainerMenu.canItemQuickReplace((Slot)scanningSlot, (ItemStack)carried, (boolean)true) || !scanningSlot.mayPickup(player) || !EIM.canTakeItemForPickAll(carried, scanningSlot)) continue;
                    ItemStack scanningItem = scanningSlot.getItem();
                    if (l2 == 0 && scanningItem.getCount() == scanningItem.getMaxStackSize()) continue;
                    ItemStack taken = scanningSlot.safeTake(scanningItem.getCount(), carried.getMaxStackSize() - carried.getCount(), player);
                    carried.grow(taken.getCount());
                }
                if (carried.getCount() >= carried.getMaxStackSize()) continue;
                ItemStack taken = EIM.tryExtractFromPage(carried, carried.getMaxStackSize() - carried.getCount());
                carried.grow(taken.getCount());
                carried.setCount(Math.min(carried.getCount(), carried.getMaxStackSize()));
            }
        }
    }

    public static void vanillaPickupAll(AbstractContainerMenu menu, int slotId, int button, Player player) {
        if (slotId >= 0) {
            Slot slot2 = (Slot)menu.slots.get(slotId);
            ItemStack itemstack4 = menu.getCarried();
            if (!(itemstack4.isEmpty() || slot2.hasItem() && slot2.mayPickup(player))) {
                int l1 = button == 0 ? 0 : menu.slots.size() - 1;
                int i2 = button == 0 ? 1 : -1;
                for (int l2 = 0; l2 < 2; ++l2) {
                    for (int l3 = l1; l3 >= 0 && l3 < menu.slots.size() && itemstack4.getCount() < itemstack4.getMaxStackSize(); l3 += i2) {
                        Slot slot8 = (Slot)menu.slots.get(l3);
                        if (!slot8.hasItem() || !AbstractContainerMenu.canItemQuickReplace((Slot)slot8, (ItemStack)itemstack4, (boolean)true) || !slot8.mayPickup(player) || !menu.canTakeItemForPickAll(itemstack4, slot8)) continue;
                        ItemStack itemstack11 = slot8.getItem();
                        if (l2 == 0 && itemstack11.getCount() == itemstack11.getMaxStackSize()) continue;
                        ItemStack itemstack12 = slot8.safeTake(itemstack11.getCount(), itemstack4.getMaxStackSize() - itemstack4.getCount(), player);
                        itemstack4.grow(itemstack12.getCount());
                    }
                }
            }
        }
    }
}

