/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.network.payloads.toServer;

import com.kwwsyk.endinv.common.AbstractModInitializer;
import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.menu.EndlessInventoryMenu;
import com.kwwsyk.endinv.common.menu.page.pageManager.AttachingMonitor;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import com.kwwsyk.endinv.common.network.payloads.ModPacketContext;
import com.kwwsyk.endinv.common.network.payloads.ModPacketPayload;
import com.kwwsyk.endinv.common.network.payloads.PageData;
import com.kwwsyk.endinv.common.network.payloads.toClient.EndInvContent;
import com.kwwsyk.endinv.common.network.payloads.toClient.EndInvMetadata;
import com.kwwsyk.endinv.common.network.payloads.toClient.SetItemDisplayContentPayload;
import com.kwwsyk.endinv.common.options.ContentTransferMode;
import com.kwwsyk.endinv.common.util.SortType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public record ItemPageContext(int startIndex, int length, PageData pageData) implements ModPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemPageContext> STREAM_CODEC = StreamCodec.of((buf, value) -> ItemPageContext.encode(value, (FriendlyByteBuf)buf), ItemPageContext::decode);
    public static final CustomPacketPayload.Type<ItemPageContext> TYPE = new CustomPacketPayload.Type(AbstractModInitializer.withModLocation("page_context"));

    public static void encode(ItemPageContext context, FriendlyByteBuf o) {
        o.writeInt(context.startIndex);
        o.writeInt(context.length);
        PageData.encode(o, context.pageData);
    }

    public static ItemPageContext decode(FriendlyByteBuf o) {
        return new ItemPageContext(o.readInt(), o.readInt(), PageData.decode(o));
    }

    public SortType sortType() {
        return this.pageData.sortType();
    }

    public String search() {
        return this.pageData.search();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ItemPageContext)) {
            return false;
        }
        ItemPageContext context = (ItemPageContext)o;
        return this.length == context.length && this.startIndex == context.startIndex && Objects.equals(this.pageData, context.pageData);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.startIndex, this.length, this.pageData);
    }

    @Override
    public String id() {
        return "page_context";
    }

    @Override
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void handle(ModPacketContext iPayloadContext) {
        ServerPlayer serverPlayer = (ServerPlayer)iPayloadContext.player();
        assert (serverPlayer != null);
        Optional<PageMetaDataManager> optional = ServerLevelEndInv.checkAndGetManagerForPlayer(serverPlayer);
        optional.ifPresent(manager -> {
            if (!Objects.equals(manager.getPageData(), this.pageData)) {
                SortType sortType = this.pageData.sortType();
                boolean reverseSort = this.pageData.reverseSort();
                String search = this.pageData.search();
                if (manager instanceof AttachingMonitor) {
                    AttachingMonitor attachingMonitor = (AttachingMonitor)manager;
                    attachingMonitor.applyPageData(this.pageData);
                } else if (manager instanceof EndlessInventoryMenu) {
                    EndlessInventoryMenu menuManager = (EndlessInventoryMenu)manager;
                    menuManager.applyPageData(this.pageData);
                } else {
                    manager.setSortType(sortType);
                    manager.setSortReversed(reverseSort);
                    manager.setSearching(search);
                    manager.switchPageWithId(this.pageData().pageRegKey());
                }
            }
            EndlessInventory endInv = (EndlessInventory)manager.getSourceInventory();
            if (ModInfo.getServerConfig().transferMode().get() == ContentTransferMode.PART) {
                List<ItemStack> view = endInv.getSortedAndFilteredItemView(this.startIndex, this.length, manager.sortType(), manager.isSortReversed(), manager.getDisplayingPageType().itemClassify, manager.searching());
                NonNullList stacks = NonNullList.withSize((int)this.length, (Object)ItemStack.EMPTY);
                for (int i = 0; i < view.size(); ++i) {
                    stacks.set(i, (Object)view.get(i));
                }
                ModInfo.getPacketDistributor().sendToPlayer(serverPlayer, EndInvMetadata.getWith(endInv));
                ModInfo.getPacketDistributor().sendToPlayer(serverPlayer, new SetItemDisplayContentPayload((List<ItemStack>)stacks));
            } else if (ModInfo.getServerConfig().transferMode().get() == ContentTransferMode.ALL) {
                ModInfo.getPacketDistributor().sendToPlayer(serverPlayer, new EndInvContent(endInv.getItemMap()));
            }
        });
    }
}

