/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.event;

import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_918;

public class AutoPickTipper {
    private static final int MAX_QUEUE_SIZE = 8;
    private static final int DISPLAY_TICKS = 100;
    private static final int MIN_DELAY_BETWEEN_REMOVALS = 10;
    private static final Deque<PickupDisplayItem> pickupQueue = new ArrayDeque<PickupDisplayItem>();
    private static int removalDelayCounter = 0;

    public static void addItem(class_1799 stack) {
        if (class_310.method_1551().field_1724 != null) {
            class_310.method_1551().field_1724.method_5783(class_3417.field_15197, 0.5f, 1.0f);
        }
        for (PickupDisplayItem item : pickupQueue) {
            if (!class_1799.method_31577((class_1799)item.stack, (class_1799)stack)) continue;
            item.stack.method_7933(stack.method_7947());
            item.timeLeft = 100;
            pickupQueue.remove(item);
            pickupQueue.addFirst(item);
            return;
        }
        if (pickupQueue.size() >= 8) {
            pickupQueue.pollLast();
        }
        pickupQueue.addFirst(new PickupDisplayItem(stack.method_7972(), 100));
    }

    public static void onRenderGui(class_332 guiGraphics) {
        PickupDisplayItem lastItem;
        if (pickupQueue.isEmpty()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_918 itemRenderer = mc.method_1480();
        int screenWidth = mc.method_22683().method_4486();
        int screenHeight = mc.method_22683().method_4502();
        int index = 0;
        for (PickupDisplayItem item : pickupQueue) {
            int x = screenWidth - 24;
            int y = screenHeight - 20 - index * 18;
            int color = AutoPickTipper.rarityColor(item.stack.method_7932());
            guiGraphics.method_51427(item.stack, x, y);
            guiGraphics.method_51431(class_310.method_1551().field_1772, item.stack, x, y);
            guiGraphics.method_25296(x - 48, y, x + 16, y + 16, 0, color);
            ++index;
        }
        if (removalDelayCounter > 0) {
            --removalDelayCounter;
        } else if (!pickupQueue.isEmpty() && (lastItem = pickupQueue.peekLast()) != null) {
            --lastItem.timeLeft;
            if (lastItem.timeLeft <= 0) {
                pickupQueue.pollLast();
                removalDelayCounter = 10;
            }
        }
    }

    private static int rarityColor(class_1814 rarity) {
        switch (rarity) {
            case field_8906: {
                return -1996488705;
            }
        }
        class_124 color = rarity.method_58413();
        Integer rgb = color != null ? color.method_532() : null;
        return rgb != null ? 0xFF000000 | rgb : -1996488705;
    }

    private static class PickupDisplayItem {
        class_1799 stack;
        int timeLeft;

        public PickupDisplayItem(class_1799 stack, int timeLeft) {
            this.stack = stack;
            this.timeLeft = timeLeft;
        }
    }
}

