/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui.page;

import com.kwwsyk.endinv.common.SourceInventory;
import com.kwwsyk.endinv.common.client.CachedSrcInv;
import com.kwwsyk.endinv.common.client.ClientModInfo;
import com.kwwsyk.endinv.common.client.KeyMappings;
import com.kwwsyk.endinv.common.client.gui.ScreenFramework;
import com.kwwsyk.endinv.common.client.gui.bg.SFBgRenderer;
import com.kwwsyk.endinv.common.client.gui.page.manager.PageManager;
import com.kwwsyk.endinv.common.menu.page.PageType;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_156;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_768;
import net.minecraft.class_7923;

public abstract class DisplayPage {
    protected final PageType pageType;
    public final String id;
    @Nullable
    protected final Predicate<class_1799> itemClassify;
    public class_2960 icon = null;
    public class_2561 name;
    public PageManager meta;
    public final SourceInventory srcInv;
    protected final class_1703 menu;
    protected final class_310 mc = class_310.method_1551();
    protected ScreenFramework framework;
    protected int leftPos;
    protected int topPos;
    protected int renderOffsetX;
    protected int renderOffsetY;
    private boolean rendererInitialized;
    private int lastFrameworkPageX;
    private int lastFrameworkPageY;
    protected boolean holdOn = false;
    private boolean doubleClick;
    private int lastClickedButton;
    private double lastCLickedX;
    private double lastClickedY;
    private long lastClickedTime;
    private boolean skipNextRelease;
    private int lastDraggedPageSlot = -1;
    protected float scrollOffs;

    public DisplayPage(PageType pageType, PageManager manager) {
        this.meta = manager;
        this.menu = manager.getMenu();
        this.srcInv = CachedSrcInv.INSTANCE;
        this.pageType = pageType;
        this.id = pageType.registerName;
        this.itemClassify = pageType.itemClassify;
        this.name = class_2561.method_48321((String)("page.endinv." + pageType.registerName), (String)pageType.registerName);
    }

    public abstract void initializeContents();

    public abstract void scrollTo(float var1);

    public abstract boolean canScroll();

    public abstract void sendChangesToServer();

    public abstract boolean hasSearchbox();

    public abstract boolean hasSortTypeSwitchBar();

    public class_2960 getIcon() {
        return this.icon;
    }

    public int getPageLeft() {
        return this.leftPos;
    }

    public int getPageTop() {
        return this.topPos;
    }

    @Nullable
    public Predicate<class_1799> getClassify() {
        return this.itemClassify;
    }

    public PageType getPageType() {
        return this.pageType;
    }

    public int getRowIndexForScroll(float scrollOffs) {
        return Math.max((int)((double)(scrollOffs * (float)this.calculateRowCount()) + 0.5), 0);
    }

    public float getScrollForRowIndex(int rowIndex) {
        return class_3532.method_15363((float)((float)rowIndex / (float)this.calculateRowCount()), (float)0.0f, (float)1.0f);
    }

    public int calculateRowCount() {
        return Math.max(this.meta.getItemSize() / this.meta.columns(), CachedSrcInv.INSTANCE.getItemSize() / this.meta.columns());
    }

    protected float subtractInputFromScroll(float scrollOffs, double input) {
        return class_3532.method_15363((float)(scrollOffs - (float)(input / (double)this.meta.rows())), (float)0.0f, (float)1.0f);
    }

    public void setChanged() {
    }

    public class_1799 tryInsertItem(class_1799 stack) {
        return this.srcInv.addItem(stack);
    }

    public class_1799 tryExtractItem(class_1799 item, int count) {
        return this.srcInv.takeItem(item, count);
    }

    public void setHoldOn() {
        if (!this.holdOn) {
            this.holdOn = true;
        }
    }

    public void release() {
        if (this.holdOn) {
            this.holdOn = false;
        }
    }

    public void renderBg(SFBgRenderer SFBgRenderer2, class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        SFBgRenderer2.getDefaultPageBgRenderer().ifPresent(bgRenderer -> bgRenderer.renderBg(guiGraphics, partialTick, mouseX, mouseY));
    }

    public void initRenderer(ScreenFramework framework, int pageXPos, int pageYPos) {
        this.framework = framework;
        if (!this.rendererInitialized) {
            this.leftPos = pageXPos;
            this.topPos = pageYPos;
            this.renderOffsetX = 0;
            this.renderOffsetY = 0;
            this.rendererInitialized = true;
        } else {
            this.leftPos = pageXPos + this.renderOffsetX;
            this.topPos = pageYPos + this.renderOffsetY;
        }
        this.lastFrameworkPageX = pageXPos;
        this.lastFrameworkPageY = pageYPos;
    }

    public void move(int deltaX, int deltaY) {
        this.renderOffsetX += deltaX;
        this.renderOffsetY += deltaY;
        this.leftPos = this.lastFrameworkPageX + this.renderOffsetX;
        this.topPos = this.lastFrameworkPageY + this.renderOffsetY;
    }

    public void resize(int rows) {
    }

    public void render(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.renderPage(graphics);
        if (this.framework.hoveringOnPage()) {
            this.renderHovering(graphics, mouseX, mouseY, partialTick);
        }
    }

    public abstract void renderPage(class_332 var1);

    public void renderHovering(class_332 graphics, int mouseX, int mouseY, float partialTick) {
    }

    public void renderPageIcon(class_332 graphics, int x, int y, float partialTick) {
        if (this.getIcon() == null) {
            return;
        }
        Optional optionalItem = class_7923.field_41178.method_17966(this.getIcon());
        if (optionalItem.isPresent()) {
            class_1799 stack = new class_1799((class_1935)optionalItem.get());
            graphics.method_51427(stack, x, y);
            return;
        }
        try {
            graphics.method_25290(this.getIcon(), x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract boolean doubleClickedOnOne(double var1, double var3, double var5, double var7, long var9);

    public abstract void pageClicked(double var1, double var3, int var5, class_1713 var6);

    @Nullable
    public abstract class_768 getOneInteractableArea(double var1, double var3);

    public abstract class_1799 getItemByMouseOffset(double var1, double var3);

    public class_1799 getHoveredOrClickedItem(double mouseX, double mouseY) {
        return this.getItemByMouseOffset(mouseX - (double)this.leftPos, mouseY - (double)this.topPos);
    }

    public abstract void handleStarItem(double var1, double var3);

    public int getSlotByMouseOffset(double XOffset, double YOffset) {
        return -1;
    }

    public boolean mouseClicked(double XOffset, double YOffset, int keyCode) {
        class_3675.class_306 mouseKey = class_3675.class_307.field_1672.method_1447(keyCode);
        boolean isKeyPicking = ClientModInfo.inputHandler.isActiveAndMatches(this.mc.field_1690.field_1871, mouseKey);
        long clickTime = class_156.method_658();
        this.doubleClick = keyCode == this.lastClickedButton && this.doubleClickedOnOne(XOffset, YOffset, this.lastCLickedX, this.lastClickedY, clickTime - this.lastClickedTime);
        this.skipNextRelease = false;
        if (keyCode != 0 && keyCode != 1 && !isKeyPicking) {
            if (this.menu.method_34255().method_7960()) {
                if (this.mc.field_1690.field_1831.method_1433(keyCode)) {
                    this.pageClicked(XOffset, YOffset, 40, class_1713.field_7791);
                } else {
                    for (int i = 0; i < 9; ++i) {
                        if (!this.mc.field_1690.field_1852[i].method_1433(keyCode)) continue;
                        this.pageClicked(XOffset, YOffset, i, class_1713.field_7791);
                    }
                }
            }
        } else if (this.menu.method_34255().method_7960()) {
            if (ClientModInfo.inputHandler.isActiveAndMatches(this.mc.field_1690.field_1871, mouseKey)) {
                this.pageClicked(XOffset, YOffset, keyCode, class_1713.field_7796);
            } else {
                class_1713 clicktype = class_1713.field_7790;
                if (class_437.method_25442()) {
                    this.setHoldOn();
                    clicktype = class_1713.field_7794;
                }
                this.pageClicked(XOffset, YOffset, keyCode, clicktype);
            }
            this.skipNextRelease = true;
        } else {
            this.pageClicked(XOffset, YOffset, keyCode, class_1713.field_7790);
        }
        this.lastClickedTime = clickTime;
        this.lastClickedButton = keyCode;
        this.lastCLickedX = XOffset;
        this.lastClickedY = YOffset;
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (class_437.method_25442()) {
            int slotId = this.getSlotByMouseOffset(mouseX, mouseY);
            if (slotId >= 0 && this.lastDraggedPageSlot >= 0 && slotId != this.lastDraggedPageSlot) {
                this.pageClicked(mouseX, mouseY, button, class_1713.field_7794);
            }
            this.lastDraggedPageSlot = slotId;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double XOffset, double YOffset, int keyCode) {
        this.lastDraggedPageSlot = -1;
        class_3675.class_306 mouseKey = class_3675.class_307.field_1672.method_1447(keyCode);
        if (this.doubleClick) {
            this.pageClicked(XOffset, YOffset, keyCode, class_1713.field_7793);
            this.doubleClick = false;
            this.lastClickedTime = 0L;
            return true;
        }
        if (this.skipNextRelease) {
            this.skipNextRelease = false;
            return true;
        }
        if (!this.menu.method_34255().method_7960() && ClientModInfo.inputHandler.isActiveAndMatches(this.mc.field_1690.field_1871, mouseKey)) {
            this.pageClicked(XOffset, YOffset, keyCode, class_1713.field_7796);
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollY) {
        if (!this.canScroll()) {
            return false;
        }
        this.scrollOffs = this.subtractInputFromScroll(this.scrollOffs, scrollY);
        this.scrollTo(this.scrollOffs);
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers, int mouseX, int mouseY) {
        boolean isNumericKey = class_3675.method_15985((int)keyCode, (int)scanCode).method_30103().isPresent();
        if (isNumericKey && this.menu.method_34255().method_7960()) {
            if (ClientModInfo.inputHandler.isActiveAndMatches(this.mc.field_1690.field_1831, class_3675.method_15985((int)keyCode, (int)scanCode))) {
                this.pageClicked(mouseX, mouseY, 40, class_1713.field_7791);
                return true;
            }
            for (int i = 0; i < 9; ++i) {
                if (!ClientModInfo.inputHandler.isActiveAndMatches(this.mc.field_1690.field_1852[i], class_3675.method_15985((int)keyCode, (int)scanCode))) continue;
                this.pageClicked(mouseX, mouseY, i, class_1713.field_7791);
                return true;
            }
        }
        if (ClientModInfo.inputHandler.isActiveAndMatches(KeyMappings.STAR_ITEM, class_3675.method_15985((int)keyCode, (int)scanCode))) {
            this.handleStarItem(mouseX, mouseY);
            return true;
        }
        return false;
    }
}

