/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui.page;

import com.kwwsyk.endinv.common.client.CachedSrcInv;
import com.kwwsyk.endinv.common.client.gui.page.ItemDisplay;
import com.kwwsyk.endinv.common.client.gui.page.manager.PageManager;
import com.kwwsyk.endinv.common.client.option.CachedConfig;
import com.kwwsyk.endinv.common.menu.page.PageType;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class SegClassifyItemDisplay
extends ItemDisplay {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<Predicate<class_1799>> subClassifies;
    private final boolean includeRemainItems;
    private final boolean keepClassifiedItemInNextSeg;
    private final List<class_1799> segmentedView = new ArrayList<class_1799>();
    private final List<Integer> segmentStartSlots = new ArrayList<Integer>();
    private final List<Integer> pageSeparatorRows = new ArrayList<Integer>();

    public SegClassifyItemDisplay(PageType pageType, PageManager metaDataManager, List<Predicate<class_1799>> subClassifies, boolean includeRemainItems, boolean keepClassifiedItemInNextSeg) {
        super(pageType, metaDataManager);
        this.subClassifies = subClassifies == null ? List.of() : List.copyOf(subClassifies);
        this.includeRemainItems = includeRemainItems;
        this.keepClassifiedItemInNextSeg = keepClassifiedItemInNextSeg;
    }

    @Override
    public void readCachedItems() {
        List<class_1799> source = CachedSrcInv.INSTANCE.getSortedAndFilteredItemView(0, Integer.MAX_VALUE, CachedConfig.sortType(), CachedConfig.reverseSort(), this.getClassify(), CachedConfig.searching());
        this.buildContentsWith(source);
    }

    @Override
    public void buildContentsWith(@NotNull List<class_1799> stacks) {
        if (this.holdOn) {
            this.inQueueStacks = stacks;
            return;
        }
        this.rebuildSegments(stacks);
    }

    private void buildContentDirectly(List<class_1799> stacks) {
        for (int i = 0; i < this.length; ++i) {
            if (i < stacks.size() && stacks.get(i) != null) {
                this.items.set(i, (Object)stacks.get(i).method_7972());
                continue;
            }
            this.items.set(i, (Object)class_1799.field_8037);
        }
    }

    @Override
    public void renderPage(class_332 guiGraphics) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        int rowIndex = 0;
        int columnIndex = 0;
        int columns = this.meta.columns();
        for (class_1799 item : this.items) {
            if (columnIndex == 0 && this.pageSeparatorRows.contains(rowIndex)) {
                int y = this.topPos + rowIndex * 18;
                guiGraphics.method_25294(this.leftPos, y, this.leftPos + columns * 18 - 2, y + 1, -10855846);
            }
            if (item.method_7960() && !item.method_31574(class_1802.field_8162)) {
                this.renderEmpty(guiGraphics, this.leftPos + columnIndex * 18, this.topPos + rowIndex * 18 + 1, item);
            }
            guiGraphics.method_51428(item, this.leftPos + columnIndex * 18, this.topPos + rowIndex * 18 + 1, columnIndex + rowIndex * 180);
            if (!this.isHiddenBySortBox(rowIndex, columnIndex)) {
                guiGraphics.method_51432(class_310.method_1551().field_1772, item, this.leftPos + columnIndex * 18, this.topPos + rowIndex * 18 + 1, this.getDisplayAmount(item));
            }
            if (++columnIndex < columns) continue;
            columnIndex = 0;
            ++rowIndex;
        }
        guiGraphics.method_51448().method_22909();
    }

    @Override
    public class_1799 takeItem(class_1799 itemStack, int count) {
        this.setChanged();
        class_1799 result = this.srcInv.takeItem(itemStack, count);
        this.readCachedItems();
        return result;
    }

    @Override
    public class_1799 takeItem(int index, int count) {
        int viewIndex = this.startIndex + index;
        if (viewIndex < 0 || viewIndex >= this.segmentedView.size()) {
            return class_1799.field_8037;
        }
        class_1799 itemStack = this.segmentedView.get(viewIndex);
        if (itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        this.setChanged();
        class_1799 result = this.srcInv.takeItem(itemStack, count);
        this.readCachedItems();
        return result;
    }

    @Override
    public class_1799 addItem(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        this.setChanged();
        class_1799 remain = this.srcInv.addItem(itemStack.method_7972());
        this.readCachedItems();
        return remain;
    }

    private void rebuildSegments(List<class_1799> source) {
        this.segmentedView.clear();
        this.segmentStartSlots.clear();
        this.pageSeparatorRows.clear();
        ArrayList<class_1799> filtered = new ArrayList<class_1799>();
        for (class_1799 stack : source) {
            if (stack == null || stack.method_7960()) continue;
            filtered.add(stack.method_7972());
        }
        if (filtered.isEmpty()) {
            this.buildContentDirectly(List.of());
            return;
        }
        boolean[] consumed = new boolean[filtered.size()];
        boolean[] matchedAtLeastOnce = new boolean[filtered.size()];
        for (Predicate<class_1799> classifier : this.subClassifies) {
            if (classifier == null) continue;
            int start = this.segmentedView.size();
            ArrayList<class_1799> segment = new ArrayList<class_1799>();
            for (int i = 0; i < filtered.size(); ++i) {
                class_1799 stack;
                if (!this.keepClassifiedItemInNextSeg && consumed[i] || !classifier.test(stack = (class_1799)filtered.get(i))) continue;
                segment.add(stack.method_7972());
                matchedAtLeastOnce[i] = true;
                if (this.keepClassifiedItemInNextSeg) continue;
                consumed[i] = true;
            }
            if (segment.isEmpty()) continue;
            this.segmentStartSlots.add(start);
            this.appendSegment(this.segmentedView, segment);
        }
        if (this.includeRemainItems) {
            ArrayList<class_1799> remain = new ArrayList<class_1799>();
            for (int i = 0; i < filtered.size(); ++i) {
                boolean consumedFlag;
                boolean matched = matchedAtLeastOnce[i];
                boolean bl = consumedFlag = this.keepClassifiedItemInNextSeg ? matched : consumed[i];
                if (consumedFlag) continue;
                remain.add(((class_1799)filtered.get(i)).method_7972());
            }
            if (!remain.isEmpty()) {
                this.segmentStartSlots.add(this.segmentedView.size());
                this.appendSegment(this.segmentedView, remain);
            }
        }
        this.updateDisplayedSlice();
    }

    private void appendSegment(List<class_1799> target, List<class_1799> segment) {
        if (segment.isEmpty()) {
            return;
        }
        target.addAll(segment);
        int columns = this.meta.columns();
        if (columns <= 0) {
            return;
        }
        int remainder = segment.size() % columns;
        if (remainder == 0) {
            return;
        }
        int filler = columns - remainder;
        for (int i = 0; i < filler; ++i) {
            target.add(class_1799.field_8037);
        }
    }

    private void updateDisplayedSlice() {
        int columns = Math.max(1, this.meta.columns());
        int fromIndex = Math.min(this.startIndex, this.segmentedView.size());
        int toIndex = Math.min(fromIndex + this.length, this.segmentedView.size());
        List<class_1799> slice = this.segmentedView.subList(fromIndex, toIndex);
        this.buildContentDirectly(slice);
        this.pageSeparatorRows.clear();
        if (!this.segmentStartSlots.isEmpty()) {
            int firstRow = fromIndex / columns;
            int rowEndExclusive = class_3532.method_38788((int)Math.max(toIndex, fromIndex), (int)columns);
            for (Integer start : this.segmentStartSlots) {
                int relative;
                int row;
                if (start == null || (row = start / columns) <= firstRow || row >= rowEndExclusive || this.pageSeparatorRows.contains(relative = row - firstRow)) continue;
                this.pageSeparatorRows.add(relative);
            }
            if (!this.pageSeparatorRows.isEmpty()) {
                this.pageSeparatorRows.sort(Integer::compareTo);
            }
        }
    }
}

