/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.data;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.data.EndInvCodecStrategy;
import com.kwwsyk.endinv.common.data.FullCodecStrategy;
import com.kwwsyk.endinv.common.data.SortedSaveStrategy;
import com.mojang.logging.LogUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_5218;
import net.minecraft.class_7225;
import org.slf4j.Logger;

public class EndlessInventoryData
extends class_18 {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final List<EndlessInventory> levelEndInvs = new ArrayList<EndlessInventory>();
    public static EndInvCodecStrategy LoadStrategy = new FullCodecStrategy();
    public static EndInvCodecStrategy SaveStrategy = new FullCodecStrategy();

    private EndlessInventoryData() {
    }

    public static void init(class_3218 level) {
        if (!level.method_27983().equals(class_1937.field_25179)) {
            return;
        }
        class_18.class_8645 factory = new class_18.class_8645(EndlessInventoryData::create, EndlessInventoryData::load, class_4284.field_19214);
        ServerLevelEndInv.levelEndInvData = (EndlessInventoryData)level.method_17983().method_17924(factory, "endless_inventories");
        LOGGER.info("Initialized EndlessInventoryData in {} with {} inventories", (Object)level.method_27983().method_29177(), (Object)ServerLevelEndInv.levelEndInvData.levelEndInvs.size());
    }

    public static BackupResult backup(class_3218 level) {
        try {
            Path worldDir = level.method_8503().method_27050(class_5218.field_24188).normalize();
            Path dataFile = worldDir.resolve("data/endless_inventories.dat");
            if (!Files.exists(dataFile, new LinkOption[0])) {
                throw new FileNotFoundException("Cannot find data file: " + String.valueOf(dataFile));
            }
            Path backupDir = worldDir.resolve("endinv_backup");
            Files.createDirectories(backupDir, new FileAttribute[0]);
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss"));
            Path backupFile = backupDir.resolve("endless_inventories_" + timestamp + ".dat");
            Files.copy(dataFile, backupFile, StandardCopyOption.REPLACE_EXISTING);
            return new BackupResult(true, backupFile.toString());
        }
        catch (IOException e) {
            return new BackupResult(false, e.getMessage());
        }
        catch (Exception e) {
            return new BackupResult(false, "Unexpected exception");
        }
    }

    public static EndlessInventoryData create() {
        return new EndlessInventoryData();
    }

    public void addEndInvToLevel(EndlessInventory endlessInventory) {
        this.levelEndInvs.add(endlessInventory);
        this.method_80();
    }

    public void byIndexRemove(int index) {
        if (index < 0 || index >= this.levelEndInvs.size()) {
            return;
        }
        this.levelEndInvs.remove(index);
    }

    public EndlessInventory fromUUID(UUID uuid) {
        for (EndlessInventory endlessInventory : this.levelEndInvs) {
            if (!Objects.equals(endlessInventory.getUuid(), uuid)) continue;
            return endlessInventory;
        }
        return null;
    }

    @Nullable
    public EndlessInventory fromIndex(int index) {
        if (index < 0 || index >= this.levelEndInvs.size()) {
            return null;
        }
        return this.levelEndInvs.get(index);
    }

    public int getIndex(EndlessInventory endlessInventory) {
        int index = 0;
        for (EndlessInventory endinv : this.levelEndInvs) {
            if (Objects.equals(endlessInventory, endinv)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static EndlessInventoryData load(class_2487 tag, class_7225.class_7874 provider) {
        EndlessInventoryData data = EndlessInventoryData.create();
        class_2499 listTag = tag.method_10554("endless_inventories", 10);
        class_2487 head = listTag.method_10602(0);
        EndlessInventoryData.checkStrategy(head);
        listTag.iterator().forEachRemaining(t -> data.levelEndInvs.add(LoadStrategy.deserializeEndInv((class_2487)t, provider)));
        return data;
    }

    static void checkStrategy(class_2487 tag) {
        boolean flag = LoadStrategy.canHandle(tag);
        if (!flag) {
            LoadStrategy = new SortedSaveStrategy();
            LOGGER.debug("EndInv load strategy changed to default as current strategy cannot handle.");
        }
    }

    public class_2487 method_75(class_2487 compoundTag, class_7225.class_7874 provider) {
        class_2499 nbtTagList = new class_2499();
        for (EndlessInventory endlessInventory : this.levelEndInvs) {
            class_2487 invTag = SaveStrategy.serializeEndInv(endlessInventory, provider);
            nbtTagList.add((Object)invTag);
        }
        class_2487 saveTag = new class_2487();
        saveTag.method_10566("endless_inventories", (class_2520)nbtTagList);
        return saveTag;
    }

    public record BackupResult(boolean success, @Nullable String message) {
    }
}

