/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.network.payloads;

import com.kwwsyk.endinv.common.util.SortType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.class_2540;

public record PageData(String pageRegKey, int rows, int columns, SortType sortType, boolean reverseSort, String search) {
    public static final PageData DEFAULT = new PageData("all_items", 6, 9, SortType.DEFAULT, false, "");
    public static final Codec<PageData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("pageId", (Object)"all_items").forGetter(PageData::pageRegKey), (App)Codec.INT.optionalFieldOf("rows", (Object)DEFAULT.rows()).forGetter(PageData::rows), (App)Codec.INT.optionalFieldOf("columns", (Object)DEFAULT.columns()).forGetter(PageData::columns), (App)SortType.CODEC.optionalFieldOf("sortType", (Object)SortType.DEFAULT).forGetter(PageData::sortType), (App)Codec.BOOL.optionalFieldOf("reverseSort", (Object)false).forGetter(PageData::reverseSort), (App)Codec.STRING.optionalFieldOf("searching", (Object)"").forGetter(PageData::search)).apply((Applicative)instance, PageData::new));

    public PageData(int rows, int columns) {
        this("all_items", rows, columns, SortType.DEFAULT, false, "");
    }

    public static void encode(class_2540 o, PageData data) {
        o.method_10814(data.pageRegKey);
        o.method_53002(data.rows);
        o.method_53002(data.columns);
        o.method_10817((Enum)data.sortType);
        o.method_52964(data.reverseSort);
        o.method_10814(data.search);
    }

    public static PageData decode(class_2540 o) {
        return new PageData(o.method_19772(), o.readInt(), o.readInt(), (SortType)o.method_10818(SortType.class), o.readBoolean(), o.method_19772());
    }

    public PageData copy() {
        return new PageData(this.pageRegKey, this.rows, this.columns, this.sortType, this.reverseSort, this.search);
    }

    public PageData ofRowChanged(int rows) {
        return new PageData(this.pageRegKey, rows, this.columns, this.sortType, this.reverseSort, this.search);
    }

    public PageData ofColumnChanged(int columns) {
        return new PageData(this.pageRegKey, this.rows, columns, this.sortType, this.reverseSort, this.search);
    }

    public PageData sortTypeChanged(SortType sortType) {
        return new PageData(this.pageRegKey, this.rows, this.columns, sortType, this.reverseSort, this.search);
    }

    public PageData searchingChanged(String searching) {
        return new PageData(this.pageRegKey, this.rows, this.columns, this.sortType, this.reverseSort, searching);
    }

    public PageData ofReverseSort() {
        return new PageData(this.pageRegKey, this.rows, this.columns, this.sortType, !this.reverseSort, this.search);
    }

    public PageData ofPageKeyChanged(String pageRegKey) {
        return new PageData(pageRegKey, this.rows, this.columns, this.sortType, !this.reverseSort, this.search);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PageData)) return false;
        PageData pageData = (PageData)obj;
        if (!pageData.pageRegKey.equals(this.pageRegKey)) return false;
        if (pageData.rows != this.rows) return false;
        if (pageData.columns() != this.columns) return false;
        if (pageData.reverseSort != this.reverseSort) return false;
        if (this.sortType != pageData.sortType) return false;
        if (!Objects.equals(pageData.search, this.search)) return false;
        return true;
    }
}

