/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.fabric;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kwwsyk.endinv.common.options.ContentTransferMode;
import com.kwwsyk.endinv.common.options.IConfigValue;
import com.kwwsyk.endinv.common.options.IServerConfig;
import com.kwwsyk.endinv.common.options.MissingEndInvPolicy;
import com.kwwsyk.endinv.common.options.SpecifiedMenuAttachingConfig;
import com.kwwsyk.endinv.common.util.Accessibility;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerConfig
implements IServerConfig {
    public static final ServerConfig INSTANCE = new ServerConfig();
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerConfig.class);
    private static final String MAX_STACK = "maxStackSize";
    private static final String ENABLE_INFINITE = "enableInfinite";
    private static final String ENABLE_AUTO_PICK = "enableAutoPick";
    private static final String ENABLE_ATTACHING = "enableAttaching";
    private static final String TRANSFER_MODE = "transferMode";
    private static final String DEFAULT_ACCESS = "defaultAccessibility";
    private static final String CREATION_MODE = "creationMode";
    private static final String CONVERT_EMPTY_TAG = "convertEmptyTag";
    private static final String SPECIFIED_MENU_ATTACH_LIST = "specifiedMenuAttachability";
    private static final String INVENTORY_ATTACHABLE = "inventoryAttachable";
    private final Path path;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private int maxStackSize = Integer.MAX_VALUE;
    private boolean infinite = false;
    private boolean autoPick = false;
    private boolean attaching = true;
    private ContentTransferMode transferModeValue = ContentTransferMode.ALL;
    private Accessibility defaultAccess = Accessibility.PUBLIC;
    private MissingEndInvPolicy creationPolicy = MissingEndInvPolicy.CREATE_PER_PLAYER;
    private boolean convertEmpty = true;
    private SpecifiedMenuAttachingConfig specifiedAttach = new SpecifiedMenuAttachingConfig();

    private ServerConfig() {
        this.path = FabricLoader.getInstance().getConfigDir().resolve("endless_inventory-server.json");
        this.load();
    }

    private void load() {
        if (Files.notExists(this.path, new LinkOption[0])) {
            this.save();
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(this.path);){
            JsonElement element = JsonParser.parseReader((Reader)reader);
            if (!element.isJsonObject()) {
                LOGGER.warn("Server config is not a json object, using defaults");
                return;
            }
            JsonObject json = element.getAsJsonObject();
            if (json.has(MAX_STACK) && json.get(MAX_STACK).isJsonPrimitive()) {
                this.maxStackSize = json.get(MAX_STACK).getAsInt();
            }
            if (json.has(ENABLE_INFINITE) && json.get(ENABLE_INFINITE).isJsonPrimitive()) {
                this.infinite = json.get(ENABLE_INFINITE).getAsBoolean();
            }
            if (json.has(ENABLE_AUTO_PICK) && json.get(ENABLE_AUTO_PICK).isJsonPrimitive()) {
                this.autoPick = json.get(ENABLE_AUTO_PICK).getAsBoolean();
            }
            if (json.has(ENABLE_ATTACHING) && json.get(ENABLE_ATTACHING).isJsonPrimitive()) {
                this.attaching = json.get(ENABLE_ATTACHING).getAsBoolean();
            }
            if (json.has(TRANSFER_MODE) && json.get(TRANSFER_MODE).isJsonPrimitive()) {
                try {
                    this.transferModeValue = ContentTransferMode.valueOf(json.get(TRANSFER_MODE).getAsString());
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.warn("Unknown transfer mode in config: {}", (Object)json.get(TRANSFER_MODE).getAsString());
                }
            }
            if (json.has(DEFAULT_ACCESS) && json.get(DEFAULT_ACCESS).isJsonPrimitive()) {
                try {
                    this.defaultAccess = Accessibility.valueOf(json.get(DEFAULT_ACCESS).getAsString());
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.warn("Unknown accessibility in config: {}", (Object)json.get(DEFAULT_ACCESS).getAsString());
                }
            }
            if (json.has(CREATION_MODE) && json.get(CREATION_MODE).isJsonPrimitive()) {
                try {
                    this.creationPolicy = MissingEndInvPolicy.valueOf(json.get(CREATION_MODE).getAsString());
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.warn("Unknown creation mode in config: {}", (Object)json.get(CREATION_MODE).getAsString());
                }
            }
            if (json.has(CONVERT_EMPTY_TAG) && json.get(CONVERT_EMPTY_TAG).isJsonPrimitive()) {
                this.convertEmpty = json.get(CONVERT_EMPTY_TAG).getAsBoolean();
            }
            SpecifiedMenuAttachingConfig readCfg = new SpecifiedMenuAttachingConfig();
            if (json.has(SPECIFIED_MENU_ATTACH_LIST) && json.get(SPECIFIED_MENU_ATTACH_LIST).isJsonArray()) {
                JsonArray arr = json.getAsJsonArray(SPECIFIED_MENU_ATTACH_LIST);
                ArrayList<String> entries = new ArrayList<String>(arr.size());
                for (JsonElement el : arr) {
                    if (!el.isJsonPrimitive()) continue;
                    entries.add(el.getAsString());
                }
                readCfg = SpecifiedMenuAttachingConfig.Parser.readList(entries);
            }
            boolean invAttach = true;
            if (json.has(INVENTORY_ATTACHABLE) && json.get(INVENTORY_ATTACHABLE).isJsonPrimitive()) {
                invAttach = json.get(INVENTORY_ATTACHABLE).getAsBoolean();
            }
            readCfg.setInventoryAttachable(invAttach);
            this.specifiedAttach = readCfg;
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to read server config, using defaults", (Throwable)ex);
        }
    }

    private void save() {
        try {
            Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
            JsonObject json = new JsonObject();
            json.addProperty(MAX_STACK, (Number)this.maxStackSize);
            json.addProperty(ENABLE_INFINITE, Boolean.valueOf(this.infinite));
            json.addProperty(ENABLE_AUTO_PICK, Boolean.valueOf(this.autoPick));
            json.addProperty(ENABLE_ATTACHING, Boolean.valueOf(this.attaching));
            json.addProperty(TRANSFER_MODE, this.transferModeValue.name());
            json.addProperty(DEFAULT_ACCESS, this.defaultAccess.name());
            json.addProperty(CREATION_MODE, this.creationPolicy.name());
            json.addProperty(CONVERT_EMPTY_TAG, Boolean.valueOf(this.convertEmpty));
            JsonArray arr = new JsonArray();
            for (String s : SpecifiedMenuAttachingConfig.Parser.fromMap(this.specifiedAttach.getConfigs())) {
                arr.add(s);
            }
            json.add(SPECIFIED_MENU_ATTACH_LIST, (JsonElement)arr);
            json.addProperty(INVENTORY_ATTACHABLE, Boolean.valueOf(this.specifiedAttach.isInventoryAttachable()));
            try (BufferedWriter writer = Files.newBufferedWriter(this.path, new OpenOption[0]);){
                this.gson.toJson((JsonElement)json, (Appendable)writer);
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to save server config", (Throwable)ex);
        }
    }

    private <T> IConfigValue<T> tracked(Supplier<T> getter, Consumer<T> setter) {
        return IConfigValue.of(getter, value -> {
            setter.accept(value);
            this.save();
        });
    }

    @Override
    public IConfigValue<Integer> getMaxAllowedStackSize() {
        return this.tracked(() -> this.maxStackSize, value -> {
            this.maxStackSize = value;
        });
    }

    @Override
    public IConfigValue<Boolean> allowInfinityMode() {
        return this.tracked(() -> this.infinite, value -> {
            this.infinite = value;
        });
    }

    @Override
    public IConfigValue<Boolean> enableAutoPick() {
        return IConfigValue.of(() -> this.autoPick, value -> {
            this.autoPick = value;
            this.save();
            this.onAttachingOrAutopickConfigChanged();
        });
    }

    @Override
    public IConfigValue<Boolean> enableAttaching() {
        return IConfigValue.of(() -> this.attaching, value -> {
            this.attaching = value;
            this.save();
            this.onAttachingOrAutopickConfigChanged();
            this.onSpecifiedMenuAttachabilityChanged();
        });
    }

    @Override
    public IConfigValue<ContentTransferMode> transferMode() {
        return this.tracked(() -> this.transferModeValue, value -> {
            this.transferModeValue = value;
        });
    }

    @Override
    public IConfigValue<Accessibility> defaultAccessibility() {
        return this.tracked(() -> this.defaultAccess, value -> {
            this.defaultAccess = value;
        });
    }

    @Override
    public IConfigValue<MissingEndInvPolicy> policyHandlingMissing() {
        return this.tracked(() -> this.creationPolicy, value -> {
            this.creationPolicy = value;
        });
    }

    @Override
    public IConfigValue<Boolean> doConvertEmptyTag() {
        return this.tracked(() -> this.convertEmpty, value -> {
            this.convertEmpty = value;
        });
    }

    @Override
    public IConfigValue<SpecifiedMenuAttachingConfig> specifiedMenuAttachability() {
        return IConfigValue.of(() -> this.specifiedAttach, value -> {
            this.specifiedAttach.clearConfigs();
            this.specifiedAttach.getConfigs().putAll(value.getConfigs());
            this.specifiedAttach.setInventoryAttachable(value.isInventoryAttachable());
            this.save();
            this.onSpecifiedMenuAttachabilityChanged();
        });
    }
}

