/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.fabric.event;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.autopick.AutoPickHelper;
import com.kwwsyk.endinv.common.autopick.events.IBlockBreakEvent;
import com.kwwsyk.endinv.common.network.payloads.toClient.ItemPickedUpPayload;
import com.kwwsyk.endinv.fabric.ServerConfig;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8567;

public final class LootEvent {
    private LootEvent() {
    }

    public static void register() {
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
            final boolean[] cancelled = new boolean[]{false};
            AutoPickHelper.onBlockBreak(new IBlockBreakEvent(){

                @Override
                public class_1936 getLevel() {
                    return world;
                }

                @Override
                public class_2338 getPos() {
                    return pos;
                }

                @Override
                public class_2680 getState() {
                    return state;
                }

                @Override
                public class_1657 getPlayer() {
                    return player;
                }

                @Override
                public int getExpToDrop() {
                    return 0;
                }

                @Override
                public void setExpToDrop(int exp) {
                }

                @Override
                public void setCanceled(boolean canceled) {
                    cancelled[0] = canceled;
                }
            });
            return cancelled[0];
        });
    }

    private static void handleDrops(class_8567 params, List<class_1799> drops) {
        if (drops.isEmpty()) {
            return;
        }
        class_3222 player = LootEvent.findPlayer(params).or(() -> LootEvent.findNearbyPlayer(params)).orElse(null);
        if (player == null) {
            return;
        }
        if (!ServerConfig.INSTANCE.enableAutoPick().get().booleanValue() || !LootEvent.isAutoPickEnabled(player)) {
            return;
        }
        ServerLevelEndInv.getEndInvForPlayer((class_1657)player).ifPresent(endInv -> {
            boolean consumedAll = true;
            for (int i = 0; i < drops.size(); ++i) {
                class_1799 stack = (class_1799)drops.get(i);
                if (stack.method_7960()) continue;
                class_1799 remain = endInv.addItem(stack.method_7972());
                int inserted = stack.method_7947() - remain.method_7947();
                if (inserted > 0) {
                    class_1799 picked = stack.method_7972();
                    picked.method_7939(inserted);
                    ModInfo.getPacketDistributor().sendToPlayer(player, new ItemPickedUpPayload(picked));
                }
                if (remain.method_7960()) {
                    drops.set(i, class_1799.field_8037);
                    continue;
                }
                drops.set(i, remain);
                consumedAll = false;
            }
            drops.removeIf(class_1799::method_7960);
            if (consumedAll) {
                drops.clear();
            }
        });
    }

    private static Optional<class_3222> findPlayer(class_8567 params) {
        class_1297 direct = (class_1297)params.method_51869(class_181.field_1226);
        if (direct instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)direct;
            return Optional.of(serverPlayer);
        }
        class_1657 attacker = (class_1657)params.method_51869(class_181.field_1233);
        if (attacker instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)attacker;
            return Optional.of(serverPlayer);
        }
        return Optional.empty();
    }

    private static Optional<class_3222> findNearbyPlayer(class_8567 params) {
        try {
            class_243 origin = (class_243)params.method_51869(class_181.field_24424);
            class_3218 level = params.method_51863();
            if (origin != null) {
                class_3222 nearest = (class_3222)level.method_18459(origin.field_1352, origin.field_1351, origin.field_1350, 7.0, false);
                return Optional.ofNullable(nearest);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Optional.empty();
    }

    private static boolean isAutoPickEnabled(class_3222 player) {
        return ModRegistries.NbtAttachments.getSyncedConfig().getWith((class_1657)player).autoPicking();
    }
}

