/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.fabric.integrates.jei;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.menu.EndlessInventoryMenu;
import com.kwwsyk.endinv.common.util.ItemKey;
import com.kwwsyk.endinv.fabric.network.payloads.JeiTransferRecipePayload;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public class EIMRecipeTranHandler
implements IRecipeTransferHandler<EndlessInventoryMenu, class_8786<class_3955>> {
    private static final Class<EndlessInventoryMenu> CONTAINER_CLASS = EndlessInventoryMenu.class;
    private static final class_3917<EndlessInventoryMenu> CONTAINER_TYPE = ModRegistries.Menus.getEndInvMenuType();
    private final IJeiHelpers jeiHelper;
    private final IRecipeTransferHandlerHelper transferHelper;
    private final IRecipeTransferInfo playerInvInfo;

    public EIMRecipeTranHandler(IJeiHelpers jeiHelper, IRecipeTransferHandlerHelper transferHelper) {
        this.jeiHelper = jeiHelper;
        this.transferHelper = transferHelper;
        this.playerInvInfo = this.createPlayerInvInfo();
    }

    private IRecipeTransferInfo createPlayerInvInfo() {
        return this.transferHelper.createBasicRecipeTransferInfo(CONTAINER_CLASS, CONTAINER_TYPE, RecipeTypes.CRAFTING, 0, 9, 10, 36);
    }

    public Class<EndlessInventoryMenu> getContainerClass() {
        return CONTAINER_CLASS;
    }

    public Optional<class_3917<EndlessInventoryMenu>> getMenuType() {
        return Optional.of(CONTAINER_TYPE);
    }

    public RecipeType<class_8786<class_3955>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public IRecipeTransferError transferRecipe(EndlessInventoryMenu container, class_8786<class_3955> recipe, IRecipeSlotsView recipeSlots, class_1657 player, boolean maxTransfer, boolean doTransfer) {
        try {
            if (!new EIMRecipeTranInfo(this).canHandle(container, recipe)) {
                return this.transferHelper.createUserErrorWithTooltip((class_2561)class_2561.method_43470((String)"Unsupported container or recipe"));
            }
            if (!container.isCrafterEnabled()) {
                return this.transferHelper.createUserErrorWithTooltip((class_2561)class_2561.method_43470((String)"Crafter is disabled by server rules"));
            }
            TransferPlan plan = EIMRecipeTranHandler.createTransferPlan(container, recipe, maxTransfer);
            boolean missing = plan.isMissing();
            if (!doTransfer) {
                if (!missing) return null;
                IRecipeTransferError iRecipeTransferError = this.transferHelper.createUserErrorWithTooltip((class_2561)class_2561.method_43470((String)"Missing ingredient(s)"));
                return iRecipeTransferError;
            }
            if (player.method_37908().field_9236) {
                container.setCraftingVisible(true);
                class_2960 id = EIMRecipeTranHandler.tryResolveRecipeId(recipe);
                if (id == null) return this.transferHelper.createInternalError();
                ModInfo.getPacketDistributor().sendToServer(new JeiTransferRecipePayload(container.field_7763, id, maxTransfer));
            } else {
                EIMRecipeTranHandler.performTransfer(container, recipe, plan, player);
            }
            if (!missing) return null;
            IRecipeTransferError iRecipeTransferError = this.transferHelper.createUserErrorWithTooltip((class_2561)class_2561.method_43470((String)"Missing ingredient(s)"));
            return iRecipeTransferError;
        }
        catch (Exception e) {
            return this.transferHelper.createInternalError();
        }
    }

    public static void performServerTransfer(EndlessInventoryMenu container, class_8786<class_3955> recipe, class_1657 player, boolean maxTransfer) {
        TransferPlan plan = EIMRecipeTranHandler.createTransferPlan(container, recipe, maxTransfer);
        EIMRecipeTranHandler.performTransfer(container, recipe, plan, player);
    }

    private static boolean sameType(class_1799 a, class_1799 b) {
        if (a.method_7960() || b.method_7960()) {
            return false;
        }
        return class_1799.method_31577((class_1799)a, (class_1799)b);
    }

    private static class_1856[] buildRecipeLayout(class_3955 recipe) {
        Object[] layout = new class_1856[9];
        Arrays.fill(layout, class_1856.field_9017);
        if (recipe instanceof class_1869) {
            class_1869 shaped = (class_1869)recipe;
            int width = Math.min(3, shaped.method_8150());
            int height = Math.min(3, shaped.method_8158());
            class_2371 ingredients = shaped.method_8117();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int srcIndex = y * shaped.method_8150() + x;
                    if (srcIndex >= ingredients.size()) continue;
                    layout[y * 3 + x] = (class_1856)ingredients.get(srcIndex);
                }
            }
        } else {
            class_2371 ingredients = recipe.method_8117();
            for (int i = 0; i < Math.min(ingredients.size(), layout.length); ++i) {
                layout[i] = (class_1856)ingredients.get(i);
            }
        }
        return layout;
    }

    @Nullable
    private static ItemCounts countAvailableOfType(class_1799 type, ItemAvailability availability) {
        if (type.method_7960()) {
            return null;
        }
        return availability.lookup(ItemKey.asKey(type));
    }

    private static Selection chooseBestCandidate(class_1856 ing, ItemAvailability availability, Reservation reservation) {
        Candidate best = Candidate.NONE;
        HashSet<ItemKey> seen = new HashSet<ItemKey>();
        for (class_1799 cand : ing.method_8105()) {
            ItemCounts counts = EIMRecipeTranHandler.countAvailableOfType(cand, availability);
            Candidate candidate = Candidate.fromCounts(counts, reservation);
            if (!candidate.isValid() || !seen.add(candidate.selection().key())) continue;
            best = Candidate.pickBetter(best, candidate);
        }
        for (ItemCounts counts : availability.all()) {
            Candidate candidate;
            if (!ing.method_8093(counts.representative()) || !(candidate = Candidate.fromCounts(counts, reservation)).isValid() || !seen.add(candidate.selection().key())) continue;
            best = Candidate.pickBetter(best, candidate);
        }
        return best.selection();
    }

    private static TransferPlan createTransferPlan(EndlessInventoryMenu container, class_8786<class_3955> recipe, boolean maxTransfer) {
        int craftsPossible;
        class_1856[] layout = EIMRecipeTranHandler.buildRecipeLayout((class_3955)recipe.comp_1933());
        List<class_1735> playerInvSlots = container.getPlayerInvSlots();
        List<class_1799> pageItems = container.getSourceInventory().getItemsAsList();
        ItemAvailability availability = ItemAvailability.build(playerInvSlots, pageItems);
        Reservation reservation = new Reservation();
        Object[] chosenPerSlot = new class_1799[layout.length];
        Arrays.fill(chosenPerSlot, class_1799.field_8037);
        boolean missing = false;
        int perSlotStackLimit = Integer.MAX_VALUE;
        for (int i = 0; i < layout.length; ++i) {
            class_1856 ing = layout[i];
            if (ing.method_8103()) continue;
            Selection selection = EIMRecipeTranHandler.chooseBestCandidate(ing, availability, reservation);
            if (selection.isEmpty()) {
                missing = true;
                continue;
            }
            reservation.reserve(selection);
            chosenPerSlot[i] = selection.stack();
            perSlotStackLimit = Math.min(perSlotStackLimit, selection.stack().method_7914());
        }
        if (missing || reservation.isEmpty()) {
            craftsPossible = 0;
        } else {
            craftsPossible = Integer.MAX_VALUE;
            for (Map.Entry entry : reservation.totalDemand().entrySet()) {
                ItemCounts counts = availability.lookup((ItemKey)entry.getKey());
                if (counts == null) {
                    craftsPossible = 0;
                    missing = true;
                    break;
                }
                int possible = counts.total() / (Integer)entry.getValue();
                craftsPossible = Math.min(craftsPossible, possible);
            }
            if (craftsPossible == Integer.MAX_VALUE) {
                craftsPossible = 0;
            }
        }
        if (perSlotStackLimit == Integer.MAX_VALUE) {
            perSlotStackLimit = 64;
        }
        int craftsWanted = maxTransfer ? Math.min(craftsPossible, perSlotStackLimit) : (craftsPossible > 0 ? 1 : 0);
        boolean bl = missing || craftsWanted <= 0;
        return new TransferPlan(layout, (class_1799[])chosenPerSlot, craftsWanted, bl);
    }

    private static void performTransfer(EndlessInventoryMenu container, Object recipe, TransferPlan plan, class_1657 player) {
        container.setCraftingVisible(true);
        List<class_1735> craftingSlots = container.getCraftingSlots();
        for (class_1735 cSlot : craftingSlots) {
            class_1799 removed;
            int count;
            if (!cSlot.method_7681() || (count = cSlot.method_7677().method_7947()) <= 0 || (removed = cSlot.method_32753(count, count, player)).method_7960()) continue;
            player.method_31548().method_7398(removed);
        }
        List<class_1735> playerInvSlots = container.getPlayerInvSlots();
        class_1856[] layout = plan.layout();
        for (int i = 0; i < Math.min(craftingSlots.size(), layout.length); ++i) {
            class_1856 ing = layout[i];
            if (ing.method_8103()) continue;
            class_1735 target = craftingSlots.get(i);
            int toTake = plan.craftsWanted();
            if (toTake <= 0) continue;
            class_1799 chosen = plan.chosenPerSlot()[i];
            class_1799 placedStack = class_1799.field_8037;
            for (class_1735 invSlot : playerInvSlots) {
                class_1799 taken;
                int can;
                if (toTake <= 0) break;
                if (!invSlot.method_7681()) continue;
                class_1799 in = invSlot.method_7677();
                if (!(chosen.method_7960() ? ing.method_8093(in) : EIMRecipeTranHandler.sameType(chosen, in)) || (can = Math.min(toTake, in.method_7947())) <= 0 || (taken = invSlot.method_32753(can, can, player)).method_7960()) continue;
                if (placedStack.method_7960()) {
                    placedStack = taken;
                } else if (EIMRecipeTranHandler.sameType(placedStack, taken)) {
                    placedStack.method_7933(taken.method_7947());
                } else {
                    player.method_31548().method_7398(taken);
                    break;
                }
                toTake -= taken.method_7947();
            }
            if (toTake > 0) {
                class_1799 extracted;
                class_1799 template;
                class_1799 class_17992 = !chosen.method_7960() ? chosen : (template = ing.method_8105().length > 0 ? ing.method_8105()[0] : class_1799.field_8037);
                if (!template.method_7960() && !(extracted = container.tryExtractFromPage(template, toTake)).method_7960()) {
                    if (placedStack.method_7960()) {
                        placedStack = extracted;
                    } else if (EIMRecipeTranHandler.sameType(placedStack, extracted)) {
                        placedStack.method_7933(extracted.method_7947());
                    } else {
                        player.method_31548().method_7398(extracted);
                    }
                    toTake -= extracted.method_7947();
                }
            }
            if (placedStack.method_7960()) continue;
            int cap = Math.min(placedStack.method_7914(), target.method_7675());
            if (placedStack.method_7947() > cap) {
                class_1799 overflow = placedStack.method_46651(placedStack.method_7947() - cap);
                placedStack.method_7939(cap);
                player.method_31548().method_7398(overflow);
            }
            target.method_7673(placedStack);
        }
    }

    @Nullable
    private static class_2960 tryResolveRecipeId(Object recipeObj) {
        Object v;
        Method m2;
        try {
            m2 = recipeObj.getClass().getMethod("getId", new Class[0]);
            v = m2.invoke(recipeObj, new Object[0]);
            if (v instanceof class_2960) {
                class_2960 rl = (class_2960)v;
                return rl;
            }
        }
        catch (Throwable m2) {
            // empty catch block
        }
        try {
            m2 = recipeObj.getClass().getMethod("id", new Class[0]);
            v = m2.invoke(recipeObj, new Object[0]);
            if (v instanceof class_2960) {
                class_2960 rl = (class_2960)v;
                return rl;
            }
        }
        catch (Throwable m3) {
            // empty catch block
        }
        try {
            m2 = recipeObj.getClass().getMethod("value", new Class[0]);
            v = m2.invoke(recipeObj, new Object[0]);
            if (v != null) {
                return EIMRecipeTranHandler.tryResolveRecipeId(v);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public class EIMRecipeTranInfo
    implements IRecipeTransferInfo {
        public EIMRecipeTranInfo(EIMRecipeTranHandler this$0) {
        }

        public Class<? extends EndlessInventoryMenu> getContainerClass() {
            return CONTAINER_CLASS;
        }

        public Optional<class_3917<EndlessInventoryMenu>> getMenuType() {
            return Optional.of(CONTAINER_TYPE);
        }

        public RecipeType getRecipeType() {
            return RecipeTypes.CRAFTING;
        }

        public boolean canHandle(class_1703 container, Object recipe) {
            return container instanceof EndlessInventoryMenu;
        }

        public List<class_1735> getRecipeSlots(class_1703 container, Object recipe) {
            return ((EndlessInventoryMenu)container).getCraftingSlots();
        }

        public List<class_1735> getInventorySlots(class_1703 container, Object recipe) {
            return ((EndlessInventoryMenu)container).getPlayerInvSlots();
        }
    }

    private record TransferPlan(class_1856[] layout, class_1799[] chosenPerSlot, int craftsWanted, boolean missing) {
        boolean isMissing() {
            return this.missing;
        }
    }

    private static final class ItemAvailability {
        private final Map<ItemKey, ItemCounts> counts = new HashMap<ItemKey, ItemCounts>();

        private ItemAvailability() {
        }

        static ItemAvailability build(List<class_1735> invSlots, List<class_1799> pageItems) {
            ItemAvailability availability = new ItemAvailability();
            for (class_1735 slot : invSlots) {
                if (!slot.method_7681()) continue;
                availability.add(slot.method_7677(), Source.INVENTORY);
            }
            for (class_1799 stack : pageItems) {
                if (stack.method_7960()) continue;
                availability.add(stack, Source.PAGE);
            }
            return availability;
        }

        private void add(class_1799 stack, Source source) {
            ItemKey key = ItemKey.asKey(stack);
            ItemCounts counts = this.counts.computeIfAbsent(key, k -> new ItemCounts((ItemKey)k, stack.method_46651(1)));
            counts.add(stack.method_7947(), source);
        }

        @Nullable
        ItemCounts lookup(ItemKey key) {
            return this.counts.get(key);
        }

        Collection<ItemCounts> all() {
            return this.counts.values();
        }

        private static enum Source {
            INVENTORY,
            PAGE;

        }
    }

    private static final class ItemCounts {
        private final ItemKey key;
        private final class_1799 representative;
        private int inventoryCount;
        private int pageCount;

        ItemCounts(ItemKey key, class_1799 representative) {
            this.key = key;
            this.representative = representative;
        }

        void add(int amount, ItemAvailability.Source source) {
            if (source == ItemAvailability.Source.INVENTORY) {
                this.inventoryCount += amount;
            } else {
                this.pageCount += amount;
            }
        }

        ItemKey key() {
            return this.key;
        }

        class_1799 representative() {
            return this.representative.method_7972();
        }

        int total() {
            return this.inventoryCount + this.pageCount;
        }

        int totalRemaining(Reservation reservation) {
            return this.total() - reservation.totalReserved(this.key);
        }

        int inventoryRemaining(Reservation reservation) {
            return this.inventoryCount - reservation.inventoryReserved(this.key);
        }

        boolean isPlain() {
            return this.key.components() == null || this.key.components().method_57848();
        }
    }

    private record Candidate(Selection selection, int priority, int totalRemaining, int inventoryRemaining) {
        private static final Candidate NONE = new Candidate(Selection.EMPTY, -1, 0, 0);

        boolean isValid() {
            return this.selection != null && !this.selection.isEmpty();
        }

        static Candidate fromCounts(@Nullable ItemCounts counts, Reservation reservation) {
            boolean hasPlainInventory;
            if (counts == null) {
                return NONE;
            }
            int totalRemaining = counts.totalRemaining(reservation);
            if (totalRemaining <= 0) {
                return NONE;
            }
            int inventoryRemaining = counts.inventoryRemaining(reservation);
            boolean hasInventory = inventoryRemaining > 0;
            boolean bl = hasPlainInventory = hasInventory && counts.isPlain();
            int priority = hasPlainInventory ? 3 : (hasInventory ? 2 : 1);
            Selection selection = new Selection(counts.representative(), counts.key(), hasInventory);
            return new Candidate(selection, priority, totalRemaining, inventoryRemaining);
        }

        static Candidate pickBetter(Candidate current, Candidate challenger) {
            if (!challenger.isValid()) {
                return current;
            }
            if (!current.isValid()) {
                return challenger;
            }
            if (challenger.priority != current.priority) {
                return challenger.priority > current.priority ? challenger : current;
            }
            if (challenger.totalRemaining != current.totalRemaining) {
                return challenger.totalRemaining > current.totalRemaining ? challenger : current;
            }
            if (challenger.inventoryRemaining != current.inventoryRemaining) {
                return challenger.inventoryRemaining > current.inventoryRemaining ? challenger : current;
            }
            return current;
        }
    }

    private static final class Reservation {
        private final Map<ItemKey, Integer> total = new HashMap<ItemKey, Integer>();
        private final Map<ItemKey, Integer> inventory = new HashMap<ItemKey, Integer>();

        private Reservation() {
        }

        void reserve(Selection selection) {
            if (selection.key() == null) {
                return;
            }
            this.total.merge(selection.key(), 1, Integer::sum);
            if (selection.useInventory()) {
                this.inventory.merge(selection.key(), 1, Integer::sum);
            }
        }

        int totalReserved(ItemKey key) {
            return this.total.getOrDefault(key, 0);
        }

        int inventoryReserved(ItemKey key) {
            return this.inventory.getOrDefault(key, 0);
        }

        Map<ItemKey, Integer> totalDemand() {
            return this.total;
        }

        boolean isEmpty() {
            return this.total.isEmpty();
        }
    }

    private record Selection(class_1799 stack, ItemKey key, boolean useInventory) {
        static final Selection EMPTY = new Selection(class_1799.field_8037, null, false);

        boolean isEmpty() {
            return this.stack.method_7960();
        }
    }
}

