/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.fabric.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kwwsyk.endinv.common.client.option.IClientConfig;
import com.kwwsyk.endinv.common.client.option.TextureMode;
import com.kwwsyk.endinv.common.options.IConfigValue;
import com.kwwsyk.endinv.common.util.SortType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FabricClientConfig
implements IClientConfig {
    public static final FabricClientConfig INSTANCE = new FabricClientConfig();
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricClientConfig.class);
    private static final String ATTACHING = "attaching";
    private static final String ROWS = "rows";
    private static final String COLUMNS = "columns";
    private static final String AUTO_SUIT = "autoSuitColumn";
    private static final String TEXTURE = "texture";
    private static final String SCREEN_DEBUG = "screenDebug";
    private static final String MAX_PAGE_BARS = "maxPageBars";
    private static final String HIDDEN_PAGES = "hiddenPages";
    private static final String PAGE_ID = "pageId";
    private static final String SEARCH = "search";
    private static final String SORT_TYPE = "sortType";
    private static final String REVERSE_SORT = "reverseSort";
    private final Path path;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private boolean attachingMenu = true;
    private int rowCount = 0;
    private int columnCount = 9;
    private boolean autoSuitColumn = true;
    private TextureMode textureMode = TextureMode.FROM_RESOURCE;
    private boolean screenDebug = false;
    private int maxPageBars = 10;
    private final Set<String> hiddenPages = new HashSet<String>();
    private SortType sortType = SortType.DEFAULT;
    private boolean reverseSort = false;
    private String activePageId = "all_items";
    private String searchQuery = "";

    private FabricClientConfig() {
        this.path = FabricLoader.getInstance().getConfigDir().resolve("endless_inventory-client.json");
        this.load();
    }

    private void load() {
        if (Files.notExists(this.path, new LinkOption[0])) {
            this.save();
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(this.path);){
            JsonElement element = JsonParser.parseReader((Reader)reader);
            if (!element.isJsonObject()) {
                LOGGER.warn("Client config is not a json object, using defaults");
                return;
            }
            JsonObject json = element.getAsJsonObject();
            if (json.has(ATTACHING)) {
                this.attachingMenu = json.get(ATTACHING).getAsBoolean();
            }
            if (json.has(ROWS)) {
                this.rowCount = json.get(ROWS).getAsInt();
            }
            if (json.has(COLUMNS)) {
                this.columnCount = json.get(COLUMNS).getAsInt();
            }
            if (json.has(AUTO_SUIT)) {
                this.autoSuitColumn = json.get(AUTO_SUIT).getAsBoolean();
            }
            if (json.has(TEXTURE)) {
                try {
                    this.textureMode = TextureMode.valueOf((String)json.get(TEXTURE).getAsString());
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.warn("Unknown texture mode: {}", (Object)json.get(TEXTURE).getAsString());
                }
            }
            if (json.has(SCREEN_DEBUG)) {
                this.screenDebug = json.get(SCREEN_DEBUG).getAsBoolean();
            }
            if (json.has(MAX_PAGE_BARS)) {
                this.maxPageBars = json.get(MAX_PAGE_BARS).getAsInt();
            }
            if (json.has(SORT_TYPE)) {
                try {
                    this.sortType = SortType.valueOf((String)json.get(SORT_TYPE).getAsString());
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.warn("Unknown sort type: {}", (Object)json.get(SORT_TYPE).getAsString());
                    this.sortType = SortType.DEFAULT;
                }
            }
            if (json.has(REVERSE_SORT)) {
                this.reverseSort = json.get(REVERSE_SORT).getAsBoolean();
            }
            if (json.has(PAGE_ID)) {
                this.activePageId = json.get(PAGE_ID).getAsString();
            }
            if (json.has(SEARCH)) {
                this.searchQuery = json.get(SEARCH).getAsString();
            }
            this.hiddenPages.clear();
            if (json.has(HIDDEN_PAGES) && json.get(HIDDEN_PAGES).isJsonArray()) {
                JsonArray array = json.getAsJsonArray(HIDDEN_PAGES);
                for (JsonElement entry : array) {
                    if (!entry.isJsonPrimitive()) continue;
                    this.hiddenPages.add(entry.getAsString());
                }
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to read client config, using defaults", (Throwable)ex);
        }
    }

    public void save() {
        try {
            Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
            JsonObject json = new JsonObject();
            json.addProperty(ATTACHING, Boolean.valueOf(this.attachingMenu));
            json.addProperty(ROWS, (Number)this.rowCount);
            json.addProperty(COLUMNS, (Number)this.columnCount);
            json.addProperty(AUTO_SUIT, Boolean.valueOf(this.autoSuitColumn));
            json.addProperty(TEXTURE, this.textureMode.name());
            json.addProperty(SCREEN_DEBUG, Boolean.valueOf(this.screenDebug));
            json.addProperty(MAX_PAGE_BARS, (Number)this.maxPageBars);
            JsonArray array = new JsonArray();
            this.hiddenPages.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            json.add(HIDDEN_PAGES, (JsonElement)array);
            try (BufferedWriter writer = Files.newBufferedWriter(this.path, new OpenOption[0]);){
                this.gson.toJson((JsonElement)json, (Appendable)writer);
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to save client config", (Throwable)ex);
        }
    }

    private <T> IConfigValue<T> tracked(Supplier<T> getter, Consumer<T> setter) {
        return IConfigValue.of(getter, value -> {
            setter.accept(value);
            this.save();
        });
    }

    public IConfigValue<Boolean> attaching() {
        return this.tracked(() -> this.attachingMenu, value -> {
            this.attachingMenu = value;
        });
    }

    public IConfigValue<Integer> rows() {
        return this.tracked(() -> this.rowCount, value -> {
            this.rowCount = value;
        });
    }

    public IConfigValue<Integer> columns() {
        return this.tracked(() -> this.columnCount, value -> {
            this.columnCount = value;
        });
    }

    public IConfigValue<Boolean> autoSuitColumn() {
        return this.tracked(() -> this.autoSuitColumn, value -> {
            this.autoSuitColumn = value;
        });
    }

    public IConfigValue<TextureMode> textureMode() {
        return this.tracked(() -> this.textureMode, value -> {
            this.textureMode = value;
        });
    }

    public IConfigValue<Boolean> screenDebugging() {
        return this.tracked(() -> this.screenDebug, value -> {
            this.screenDebug = value;
        });
    }

    public IConfigValue<Integer> maxPageBarCount() {
        return this.tracked(() -> this.maxPageBars, value -> {
            this.maxPageBars = value;
        });
    }

    public Set<String> hidingPageIds() {
        return Collections.unmodifiableSet(this.hiddenPages);
    }

    public void setPageHiding(String id, boolean hiding) {
        if (hiding) {
            this.hiddenPages.add(id);
        } else {
            this.hiddenPages.remove(id);
        }
        this.save();
    }
}

