/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.fabric.client.events;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.client.CachedConfig;
import com.kwwsyk.endinv.common.client.gui.AttachedScreen;
import com.kwwsyk.endinv.common.client.gui.EndlessInventoryScreen;
import com.kwwsyk.endinv.common.client.gui.IScreenEvent;
import com.kwwsyk.endinv.common.network.payloads.ModPacketPayload;
import com.kwwsyk.endinv.common.network.payloads.SyncedConfig;
import com.kwwsyk.endinv.common.network.payloads.toServer.OpenEndInvPayload;
import com.kwwsyk.endinv.fabric.mixin.ScreenAccessor;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_746;

public final class ScreenAttachment {
    @Nullable
    private static AttachedScreen<?> attachment;

    private ScreenAttachment() {
    }

    public static void register() {
        ScreenEvents.BEFORE_INIT.register((client, screen, width, height) -> {
            if (screen instanceof class_465) {
                CachedConfig.readAndSyncClientConfigToServer((boolean)false);
            }
        });
        ScreenEvents.AFTER_INIT.register((client, screen, width, height) -> {
            class_465 container;
            block7: {
                block6: {
                    if (!(screen instanceof class_465)) break block6;
                    container = (class_465)screen;
                    if (!(screen instanceof EndlessInventoryScreen)) break block7;
                }
                return;
            }
            class_746 player = client.field_1724;
            if (player == null) {
                attachment = null;
                return;
            }
            SyncedConfig syncedConfig = (SyncedConfig)ModRegistries.NbtAttachments.getSyncedConfig().getWith((class_1657)player);
            if (!syncedConfig.checkForAttaching()) {
                attachment = null;
                return;
            }
            if (attachment == null) {
                ModInfo.getPacketDistributor().sendToServer((ModPacketPayload)new OpenEndInvPayload());
                attachment = new AttachedScreen(container);
            }
            attachment.init(new IScreenEvent(){

                public void addListener(class_339 widget) {
                    ((ScreenAccessor)screen).endinv$invokeAddRenderableWidget((class_364)widget);
                }
            });
            ScreenEvents.remove((class_437)screen).register(s -> {
                if (attachment != null) {
                    attachment.closed(new IScreenEvent(){});
                    attachment = null;
                }
            });
            ScreenEvents.beforeRender((class_437)screen).register((s, graphics, mouseX, mouseY, delta) -> ScreenAttachment.preRender(attachment));
            ScreenEvents.afterRender((class_437)screen).register((s, graphics, mouseX, mouseY, delta) -> ScreenAttachment.render(attachment, graphics, mouseX, mouseY, delta));
            ScreenMouseEvents.allowMouseClick((class_437)screen).register((s, mouseX, mouseY, button) -> ScreenAttachment.allowMouseClick(attachment, mouseX, mouseY, button));
            ScreenMouseEvents.allowMouseRelease((class_437)screen).register((s, mouseX, mouseY, button) -> ScreenAttachment.allowMouseRelease(attachment, mouseX, mouseY, button));
            ScreenMouseEvents.allowMouseScroll((class_437)screen).register((s, mouseX, mouseY, horizontal, vertical) -> ScreenAttachment.allowMouseScroll(attachment, mouseX, mouseY, horizontal, vertical));
            ScreenKeyboardEvents.allowKeyPress((class_437)screen).register((s, keyCode, scanCode, modifiers) -> ScreenAttachment.allowKeyPress(attachment, keyCode, scanCode, modifiers));
        });
    }

    private static void preRender(AttachedScreen<?> expected) {
        expected.renderPre(new IScreenEvent(){});
    }

    private static void render(AttachedScreen<?> expected, final class_332 graphics, final double mouseX, final double mouseY, final float delta) {
        if (attachment != expected) {
            return;
        }
        expected.render(new IScreenEvent(){

            public double getMouseX() {
                return mouseX;
            }

            public double getMouseY() {
                return mouseY;
            }

            public float getPartialTick() {
                return delta;
            }

            public class_332 getGuiGraphics() {
                return graphics;
            }
        });
    }

    private static boolean allowMouseClick(AttachedScreen<?> expected, final double mouseX, final double mouseY, final int button) {
        if (attachment != expected || !ScreenAttachment.isAttachmentActive(expected)) {
            return true;
        }
        final boolean[] canceled = new boolean[]{false};
        expected.mouseClicked(new IScreenEvent(){

            public double getMouseX() {
                return mouseX;
            }

            public double getMouseY() {
                return mouseY;
            }

            public int getButton() {
                return button;
            }

            public void setCanceled(boolean flag) {
                canceled[0] = flag;
            }
        });
        return !canceled[0];
    }

    private static boolean allowMouseRelease(AttachedScreen<?> expected, final double mouseX, final double mouseY, final int button) {
        if (attachment != expected || !ScreenAttachment.isAttachmentActive(expected)) {
            return true;
        }
        final boolean[] canceled = new boolean[]{false};
        expected.mouseReleased(new IScreenEvent(){

            public double getMouseX() {
                return mouseX;
            }

            public double getMouseY() {
                return mouseY;
            }

            public int getButton() {
                return button;
            }

            public void setCanceled(boolean flag) {
                canceled[0] = flag;
            }
        });
        return !canceled[0];
    }

    private static boolean allowMouseScroll(AttachedScreen<?> expected, final double mouseX, final double mouseY, final double horizontal, final double vertical) {
        if (attachment != expected || !ScreenAttachment.isAttachmentActive(expected)) {
            return true;
        }
        final boolean[] canceled = new boolean[]{false};
        expected.mouseScrolled(new IScreenEvent(){

            public double getMouseX() {
                return mouseX;
            }

            public double getMouseY() {
                return mouseY;
            }

            public double getScrollDeltaY() {
                return vertical;
            }

            public double getScrollDeltaX() {
                return horizontal;
            }

            public void setCanceled(boolean canceled1) {
                canceled[0] = canceled1;
            }
        });
        return !canceled[0];
    }

    private static boolean allowKeyPress(AttachedScreen<?> expected, final int keyCode, final int scanCode, final int modifiers) {
        if (attachment != expected || !ScreenAttachment.isAttachmentActive(expected)) {
            return true;
        }
        final boolean[] canceled = new boolean[]{false};
        expected.keyPressed(new IScreenEvent(){

            public int getKeyCode() {
                return keyCode;
            }

            public int getScanCode() {
                return scanCode;
            }

            public int getModifiers() {
                return modifiers;
            }

            public void setCanceled(boolean flag) {
                canceled[0] = flag;
            }
        });
        return !canceled[0];
    }

    public static boolean handleMouseDrag(class_465<?> screen, final double mouseX, final double mouseY, final int button, final double deltaX, final double deltaY) {
        AttachedScreen<?> current = attachment;
        if (current == null || current.screen != screen || !ScreenAttachment.isAttachmentActive(current)) {
            return false;
        }
        final boolean[] canceled = new boolean[]{false};
        current.mouseDragged(new IScreenEvent(){

            public double getMouseX() {
                return mouseX;
            }

            public double getMouseY() {
                return mouseY;
            }

            public int getMouseButton() {
                return button;
            }

            public double getDragX() {
                return deltaX;
            }

            public double getDragY() {
                return deltaY;
            }

            public void setCanceled(boolean flag) {
                canceled[0] = flag;
            }
        });
        return canceled[0];
    }

    public static boolean handleCharTyped(class_437 screen, final char chr, final int modifiers) {
        AttachedScreen<?> current = attachment;
        if (current == null || current.screen != screen || !ScreenAttachment.isAttachmentActive(current)) {
            return false;
        }
        final boolean[] canceled = new boolean[]{false};
        current.charTyped(new IScreenEvent(){

            public char getCodePoint() {
                return chr;
            }

            public int getModifiers() {
                return modifiers;
            }

            public void setCanceled(boolean flag) {
                canceled[0] = flag;
            }
        });
        return canceled[0];
    }

    private static boolean isAttachmentActive(AttachedScreen<?> expected) {
        class_437 screen = class_310.method_1551().field_1755;
        if (!(screen instanceof class_465)) {
            attachment = null;
            return false;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            attachment = null;
            return false;
        }
        if (expected.screen != screen) {
            return false;
        }
        if (!((SyncedConfig)ModRegistries.NbtAttachments.getSyncedConfig().getWith((class_1657)player)).attaching()) {
            attachment = null;
            return false;
        }
        return true;
    }
}

