/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.fabric.event;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.network.payloads.ModPacketPayload;
import com.kwwsyk.endinv.common.network.payloads.SyncedConfig;
import com.kwwsyk.endinv.common.network.payloads.toClient.ItemPickedUpPayload;
import com.kwwsyk.endinv.fabric.ServerConfig;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_3222;
import net.minecraft.class_8567;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LootEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(LootEvent.class);

    private LootEvent() {
    }

    public static void register() {
        if (!LootEvent.registerModifyDropsCompat()) {
            LOGGER.debug("Fabric loot modify drops hook unavailable; auto-pickup will fall back to world drops.");
        }
    }

    private static boolean registerModifyDropsCompat() {
        try {
            Class<?> eventsClass = Class.forName("net.fabricmc.fabric.api.loot.v3.LootTableEvents");
            Object event = eventsClass.getField("MODIFY_DROPS").get(null);
            Class<?> callbackClass = Class.forName("net.fabricmc.fabric.api.loot.v3.LootTableEvents$ModifyDrops");
            Object listener = Proxy.newProxyInstance(callbackClass.getClassLoader(), new Class[]{callbackClass}, (proxy, method, args) -> {
                if (args == null || args.length == 0) {
                    return null;
                }
                class_8567 lootParams = null;
                List drops = null;
                for (Object arg : args) {
                    List list;
                    if (arg instanceof class_8567) {
                        class_8567 params;
                        lootParams = params = (class_8567)arg;
                        continue;
                    }
                    if (!(arg instanceof List) || !(list = (List)arg).isEmpty() && !(list.get(0) instanceof class_1799)) continue;
                    drops = list;
                }
                if (lootParams != null && drops != null) {
                    LootEvent.handleDrops(lootParams, drops);
                }
                return null;
            });
            event.getClass().getMethod("register", callbackClass).invoke(event, listener);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Failed to register Fabric modify drops bridge", (Throwable)e);
            return false;
        }
    }

    private static void handleDrops(class_8567 params, List<class_1799> drops) {
        if (drops.isEmpty()) {
            return;
        }
        class_3222 player = LootEvent.findPlayer(params).orElse(null);
        if (player == null) {
            return;
        }
        if (!((Boolean)ServerConfig.INSTANCE.enableAutoPick().get()).booleanValue() || !LootEvent.isAutoPickEnabled(player)) {
            return;
        }
        ServerLevelEndInv.getEndInvForPlayer((class_1657)player).ifPresent(endInv -> {
            boolean consumedAll = true;
            for (int i = 0; i < drops.size(); ++i) {
                class_1799 stack = (class_1799)drops.get(i);
                if (stack.method_7960()) continue;
                class_1799 remain = endInv.addItem(stack.method_7972());
                int inserted = stack.method_7947() - remain.method_7947();
                if (inserted > 0) {
                    class_1799 picked = stack.method_7972();
                    picked.method_7939(inserted);
                    ModInfo.getPacketDistributor().sendToPlayer(player, (ModPacketPayload)new ItemPickedUpPayload(picked));
                }
                if (remain.method_7960()) {
                    drops.set(i, class_1799.field_8037);
                    continue;
                }
                drops.set(i, remain);
                consumedAll = false;
            }
            drops.removeIf(class_1799::method_7960);
            if (consumedAll) {
                drops.clear();
            }
        });
    }

    private static Optional<class_3222> findPlayer(class_8567 params) {
        class_1297 direct = (class_1297)params.method_51869(class_181.field_1226);
        if (direct instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)direct;
            return Optional.of(serverPlayer);
        }
        class_1657 attacker = (class_1657)params.method_51869(class_181.field_1233);
        if (attacker instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)attacker;
            return Optional.of(serverPlayer);
        }
        return Optional.empty();
    }

    private static boolean isAutoPickEnabled(class_3222 player) {
        return ((SyncedConfig)ModRegistries.NbtAttachments.getSyncedConfig().computeIfAbsent((class_1657)player)).autoPicking();
    }
}

