/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.fabric.event;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.NbtAttachment;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.network.payloads.ModPacketPayload;
import com.kwwsyk.endinv.common.network.payloads.SyncedConfig;
import com.kwwsyk.endinv.common.network.payloads.toClient.EndInvContent;
import com.kwwsyk.endinv.common.network.payloads.toClient.EndInvMetadata;
import com.kwwsyk.endinv.common.options.ContentTransferMode;
import com.kwwsyk.endinv.fabric.ServerConfig;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class PlayerEvents {
    private static final Set<UUID> PENDING_SYNC = new HashSet<UUID>();

    private PlayerEvents() {
    }

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(PlayerEvents::flushSync);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> PlayerEvents.scheduleSync(handler.field_14140));
        ServerPlayerEvents.COPY_FROM.register(PlayerEvents::copyFromOldPlayer);
    }

    public static void markPlayersForSync(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            PlayerEvents.scheduleSync(player);
        }
    }

    private static void flushSync(MinecraftServer server) {
        Iterator<UUID> iterator = PENDING_SYNC.iterator();
        while (iterator.hasNext()) {
            UUID uuid = iterator.next();
            class_3222 player = server.method_3760().method_14602(uuid);
            if (player == null) continue;
            PlayerEvents.sendInitialData(player);
            iterator.remove();
        }
    }

    private static void scheduleSync(class_3222 player) {
        PENDING_SYNC.add(player.method_5667());
    }

    private static void copyFromOldPlayer(class_3222 oldPlayer, class_3222 newPlayer, boolean alive) {
        if (alive) {
            return;
        }
        NbtAttachment uuidAttachment = ModRegistries.NbtAttachments.getEndInvUUID();
        UUID uuid = (UUID)uuidAttachment.getWith((class_1657)oldPlayer);
        uuidAttachment.setTo((class_1657)newPlayer, (Object)uuid);
        SyncedConfig config = (SyncedConfig)ModRegistries.NbtAttachments.getSyncedConfig().getWith((class_1657)oldPlayer);
        ModRegistries.NbtAttachments.getSyncedConfig().setTo((class_1657)newPlayer, (Object)config);
        ModInfo.getPacketDistributor().sendToPlayer(newPlayer, (ModPacketPayload)config);
        PlayerEvents.scheduleSync(newPlayer);
    }

    private static void sendInitialData(class_3222 player) {
        NbtAttachment configAttachment = ModRegistries.NbtAttachments.getSyncedConfig();
        SyncedConfig syncedConfig = (SyncedConfig)configAttachment.getWith((class_1657)player);
        ModInfo.getPacketDistributor().sendToPlayer(player, (ModPacketPayload)syncedConfig);
        if (ServerConfig.INSTANCE.transferMode().get() == ContentTransferMode.ALL) {
            ServerLevelEndInv.getEndInvForPlayer((class_1657)player).ifPresent(endInv -> {
                ModInfo.getPacketDistributor().sendToPlayer(player, (ModPacketPayload)new EndInvContent(endInv.getItemMap()));
                ModInfo.getPacketDistributor().sendToPlayer(player, (ModPacketPayload)EndInvMetadata.getWith((EndlessInventory)endInv));
            });
        }
    }
}

