/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.util.Accessibility;
import com.kwwsyk.endinv.common.util.ItemKey;
import com.kwwsyk.endinv.common.util.ItemState;
import com.kwwsyk.endinv.common.util.SearchUtil;
import com.kwwsyk.endinv.common.util.SortType;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public abstract class SourceInventory {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final Map<ItemKey, ItemState> itemMap;
    protected List<ItemStack> items;
    protected UUID uuid;
    protected volatile long lastModTime = Util.m_137550_();
    protected int maxStackSize;
    protected boolean infinityMode;
    @Nullable
    protected UUID owner;
    public List<UUID> white_list = new ArrayList<UUID>();
    protected Accessibility accessibility;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private volatile boolean itemsDirty = true;

    public SourceInventory(UUID uuid) {
        this.items = new ArrayList<ItemStack>();
        this.itemMap = new Object2ObjectLinkedOpenHashMap();
        this.uuid = uuid;
        this.maxStackSize = ModInfo.getServerConfig().getMaxAllowedStackSize().get();
        this.infinityMode = ModInfo.getServerConfig().allowInfinityMode().get();
        this.accessibility = ModInfo.getServerConfig().defaultAccessibility().get();
    }

    public void setChanged() {
        this.markCacheDirty();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public UUID giveNewUuid() {
        this.uuid = UUID.randomUUID();
        return this.uuid;
    }

    public Map<ItemKey, ItemState> getItemMap() {
        return this.itemMap;
    }

    public List<ItemStack> getItemsAsList() {
        return this.snapshotItems();
    }

    public int getItemSize() {
        this.readLock.lock();
        try {
            if (!this.itemsDirty) {
                int n = this.items.size();
                return n;
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            if (this.itemsDirty) {
                this.refreshItemsFromMap();
            }
            int n = this.items.size();
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int getMaxItemStackSize() {
        return this.maxStackSize;
    }

    public void setMaxItemStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
    }

    public boolean isInfinityMode() {
        return this.infinityMode;
    }

    public void setInfinityMode(boolean infinityMode) {
        this.infinityMode = infinityMode;
    }

    public Accessibility getAccessibility() {
        return this.accessibility;
    }

    public void setAccessibility(Accessibility accessibility) {
        this.accessibility = accessibility;
    }

    public boolean accessible(Player player) {
        return this.accessibility == Accessibility.PUBLIC || this.owner != null && this.owner.equals(player.m_20148_()) || this.white_list.contains(player.m_20148_()) && this.accessibility == Accessibility.RESTRICTED;
    }

    public boolean isOwner(Player player) {
        return Objects.equals(player.m_20148_(), this.owner);
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.owner;
    }

    public void setOwner(@Nullable UUID owner) {
        this.owner = owner;
    }

    public ItemStack takeItem(ItemStack itemStack) {
        return this.takeItem(itemStack, itemStack.m_41741_());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemStack takeItem(ItemStack stack, int count) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.writeLock.lock();
        try {
            ItemKey key = ItemKey.asKey(stack);
            ItemState state = this.itemMap.get(key);
            if (state == null) {
                LOGGER.warn("EI:takeItem: no state for {}", (Object)key);
                LOGGER.debug("EI:Current Source Inventory: Class:{},UUID:{},Items:{}", new Object[]{this.getClass(), this.uuid, this.buildSnapshotLocked()});
                if (ModInfo.getServerConfig().doConvertEmptyTag().get().booleanValue() && key.components() != null) {
                    state = this.itemMap.get(key = new ItemKey(key.item(), DataComponentPatch.f_315512_));
                    if (state == null) {
                        ItemStack itemStack = ItemStack.f_41583_;
                        return itemStack;
                    }
                    LOGGER.info("EI:takeItem: converted ItemKey with empty tag {} to null tag", (Object)ItemKey.asKey(stack));
                } else {
                    ItemStack itemStack = ItemStack.f_41583_;
                    return itemStack;
                }
            }
            LOGGER.info("EI:takeItem: key={} availableCount={} requestedCount={}", new Object[]{key, state.count(), count});
            if (state.count() >= this.maxStackSize && this.infinityMode) {
                LOGGER.info("EI:takeItem: infinity mode for {} returning {}", (Object)key, (Object)count);
                this.setChanged();
                ItemStack itemStack = stack.m_255036_(count);
                return itemStack;
            }
            int taken = Math.min(count, state.count());
            ItemStack result = stack.m_255036_(taken);
            if (taken == state.count()) {
                this.itemMap.remove(key);
                this.updateLastModTime();
                LOGGER.info("EI:takeItem: removed all of {} (taken={})", (Object)key, (Object)taken);
            } else {
                this.itemMap.put(key, new ItemState(state.count() - taken, this.updateLastModTime()));
                LOGGER.info("EI:takeItem: taken={} remaining={} for {}", new Object[]{taken, state.count() - taken, key});
            }
            this.setChanged();
            ItemStack itemStack = result;
            return itemStack;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack addItem(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.writeLock.lock();
        try {
            ItemStack remain;
            ItemKey key = ItemKey.asKey(itemStack);
            ItemState state = this.itemMap.get(key);
            int count = itemStack.m_41613_();
            int original = 0;
            if (state != null) {
                original = state.count();
            }
            if (original < this.maxStackSize) {
                int increased = original + count;
                if (increased <= this.maxStackSize) {
                    this.itemMap.put(key, new ItemState(increased, this.updateLastModTime()));
                    remain = ItemStack.f_41583_;
                } else {
                    this.itemMap.put(key, new ItemState(this.maxStackSize, this.updateLastModTime()));
                    remain = itemStack.m_255036_(increased - this.maxStackSize);
                }
            } else if (this.infinityMode) {
                this.itemMap.put(key, new ItemState(original, this.updateLastModTime()));
                remain = ItemStack.f_41583_;
            } else {
                ItemStack itemStack2 = itemStack.m_41777_();
                return itemStack2;
            }
            this.setChanged();
            ItemStack itemStack3 = remain;
            return itemStack3;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void clearContent() {
        this.writeLock.lock();
        try {
            this.itemMap.clear();
            this.updateLastModTime();
            this.setChanged();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected List<ItemStack> getSortedView(SortType type, boolean reverse) {
        List<ItemStack> ret = this.snapshotItems();
        ret.sort(ModInfo.sortHelper.getComparator(type, this));
        if (reverse) {
            Collections.reverse(ret);
        }
        return ret;
    }

    public List<ItemStack> getSortedAndFilteredItemView(int startIndex, int length, SortType sortType, boolean reverse, @Nullable Predicate<ItemStack> classify, String search) {
        Stream base = this.getSortedView(sortType, reverse).stream();
        return base.filter(classify != null ? classify : is -> true).filter(stack -> SearchUtil.matchesSearch(stack, search)).skip(startIndex).limit(Math.max(length, 0)).collect(Collectors.toCollection(ArrayList::new));
    }

    public void syncItemsFromMap() {
        this.writeLock.lock();
        try {
            this.refreshItemsFromMap();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncMapFromItems() {
        this.writeLock.lock();
        try {
            this.itemMap.clear();
            for (ItemStack stack : this.items) {
                if (stack.m_41619_()) continue;
                long now = this.updateLastModTime();
                ItemKey key = ItemKey.asKey(stack);
                this.itemMap.put(key, new ItemState(stack.m_41613_(), now));
            }
            this.markCacheDirty();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public long updateLastModTime() {
        long now = Util.m_137550_();
        if (now <= this.lastModTime) {
            now = this.lastModTime + 1L;
        }
        this.lastModTime = now;
        return this.lastModTime;
    }

    protected List<ItemStack> snapshotItems() {
        this.readLock.lock();
        try {
            if (!this.itemsDirty) {
                ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>(this.items);
                return arrayList;
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            if (this.itemsDirty) {
                this.refreshItemsFromMap();
            }
            ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>(this.items);
            return arrayList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void refreshItemsFromMap() {
        this.items = this.itemMap.entrySet().stream().map(e -> ((ItemKey)e.getKey()).toStack(((ItemState)e.getValue()).count())).collect(Collectors.toList());
        this.itemsDirty = false;
    }

    private List<ItemStack> buildSnapshotLocked() {
        return this.itemMap.entrySet().stream().map(e -> ((ItemKey)e.getKey()).toStack(((ItemState)e.getValue()).count())).collect(Collectors.toList());
    }

    private void markCacheDirty() {
        this.itemsDirty = true;
    }

    protected void overwriteItems(Map<ItemKey, ItemState> newItems) {
        this.writeLock.lock();
        try {
            this.itemMap.clear();
            this.itemMap.putAll(newItems);
            this.markCacheDirty();
            this.updateLastModTime();
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

