/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.client.gui.ScreenFramework;
import com.kwwsyk.endinv.common.menu.EndlessInventoryMenu;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import com.kwwsyk.endinv.common.network.payloads.toServer.ToggleCraftingPayload;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EndlessInventoryScreen
extends AbstractContainerScreen<EndlessInventoryMenu> {
    private static final ResourceLocation CRAFTING_TEXTURE = ResourceLocation.m_339182_((String)"minecraft", (String)"textures/gui/container/crafting_table.png");
    private ScreenFramework frameWork;
    private CycleButton<Boolean> craftingToggleButton;
    private boolean craftingVisible;

    public EndlessInventoryScreen(EndlessInventoryMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.recalcDimensions();
    }

    private void recalcDimensions() {
        int baseRows = ((EndlessInventoryMenu)this.f_97732_).getBaseRows();
        this.f_97727_ = 114 + baseRows * 18;
        this.f_97731_ = this.f_97727_ - 94;
    }

    public void m_7856_() {
        super.m_7856_();
        this.craftingVisible = ((EndlessInventoryMenu)this.f_97732_).isCraftingVisible();
        this.recalcDimensions();
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        ScreenFramework existing = ScreenFramework.getInstance();
        if (existing != null) {
            existing.onClose();
        }
        this.frameWork = new ScreenFramework(this);
        this.frameWork.addWidgetToScreen(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        this.addCraftingToggleButton();
        if (this.craftingToggleButton != null) {
            this.craftingToggleButton.m_168892_((Object)this.craftingVisible);
        }
        if (this.frameWork != null) {
            this.frameWork.resizePageRows(((EndlessInventoryMenu)this.f_97732_).getVisibleRows());
        }
    }

    private void addCraftingToggleButton() {
        int width = 70;
        this.craftingToggleButton = CycleButton.m_168919_().m_168948_((Object)false).m_168936_(0, 0, width, 20, (Component)Component.m_237113_((String)"Crafter"), (it, on) -> {
            this.toggleCrafting();
            if ((Boolean)it.m_168883_() != this.craftingVisible) {
                it.m_168892_((Object)this.craftingVisible);
            }
        });
        this.updateCraftingToggleButtonPosition();
        this.m_142416_((GuiEventListener)this.craftingToggleButton);
    }

    private void updateCraftingToggleButtonPosition() {
        if (this.craftingToggleButton == null) {
            return;
        }
        int width = this.craftingToggleButton.m_5711_();
        int x = this.f_97735_ + this.f_97726_ - width - 8;
        int y = this.f_97736_ - 20;
        this.craftingToggleButton.m_252865_(x);
        this.craftingToggleButton.m_253211_(y);
    }

    private void toggleCrafting() {
        this.craftingVisible = !this.craftingVisible;
        ((EndlessInventoryMenu)this.f_97732_).setCraftingVisible(this.craftingVisible);
        ModInfo.getPacketDistributor().sendToServer(new ToggleCraftingPayload(this.craftingVisible));
        int previousTop = this.f_97736_;
        this.recalcDimensions();
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.updateCraftingToggleButtonPosition();
        if (this.frameWork != null) {
            this.frameWork.resizePageRows(((EndlessInventoryMenu)this.f_97732_).getVisibleRows());
            this.frameWork.move(0, this.f_97736_ - previousTop);
        }
    }

    private void drawCraftingBackground(GuiGraphics guiGraphics) {
        int craftX = this.f_97735_;
        int craftY = this.f_97736_ + 18 * ((EndlessInventoryMenu)this.f_97732_).getVisibleRows() + 18;
        guiGraphics.m_280218_(CRAFTING_TEXTURE, craftX, craftY, 0, 12, 176, 58);
    }

    public void m_88315_(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(gui, mouseX, mouseY, partialTick);
        this.frameWork.renderPre(gui, mouseX, mouseY, partialTick);
        super.m_88315_(gui, mouseX, mouseY, partialTick);
        this.frameWork.render(gui, mouseX, mouseY, partialTick);
        this.m_280072_(gui, mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int keyCode) {
        for (GuiEventListener guieventlistener : this.m_6702_()) {
            if (!guieventlistener.m_6375_(mouseX, mouseY, keyCode)) continue;
            this.m_7522_(guieventlistener);
            if (keyCode == 0) {
                this.m_7897_(true);
            }
            return true;
        }
        return this.frameWork.mouseClicked(mouseX, mouseY, keyCode) || super.m_6375_(mouseX, mouseY, keyCode);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.frameWork.mouseDragged(mouseX, mouseY, button, dragX, dragY) || super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int keyCode) {
        return this.frameWork.mouseReleased(mouseX, mouseY, keyCode) || super.m_6348_(mouseX, mouseY, keyCode);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollX, double scrollY) {
        return super.m_6050_(mouseX, mouseY, scrollX, scrollY) || this.frameWork.mouseScrolled(mouseX, mouseY, scrollY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.frameWork.keyPressed(keyCode, scanCode, modifiers) || super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        return this.frameWork.charTyped(codePoint, modifiers);
    }

    protected void m_6597_(@Nullable Slot slot, int slotId, int mouseButton, @NotNull ClickType type) {
        super.m_6597_(slot, slotId, mouseButton, type);
        ((EndlessInventoryMenu)this.f_97732_).m_38946_();
    }

    public void m_7379_() {
        super.m_7379_();
        this.frameWork.onClose();
    }

    protected void m_7286_(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.frameWork.renderBg(guiGraphics, mouseX, mouseY, partialTick);
        if (((EndlessInventoryMenu)this.f_97732_).isCraftingVisible()) {
            this.drawCraftingBackground(guiGraphics);
        }
    }

    public PageMetaDataManager getPageManager() {
        return (PageMetaDataManager)this.f_97732_;
    }

    public AbstractContainerScreen<?> getScreen() {
        return this;
    }

    public ScreenFramework getFrameWork() {
        return this.frameWork;
    }

    public int getGuiLeft() {
        return this.f_97735_;
    }

    public int getGuiTop() {
        return this.f_97736_;
    }

    public int getXSize() {
        return this.f_97726_;
    }

    public int getYSize() {
        return this.f_97727_;
    }
}

