/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.SourceInventory;
import com.kwwsyk.endinv.common.client.CachedSrcInv;
import com.kwwsyk.endinv.common.client.ClientModInfo;
import com.kwwsyk.endinv.common.client.KeyMappings;
import com.kwwsyk.endinv.common.client.gui.AttachingScreen;
import com.kwwsyk.endinv.common.client.gui.EndlessInventoryScreen;
import com.kwwsyk.endinv.common.client.gui.bg.FromResource;
import com.kwwsyk.endinv.common.client.gui.bg.SFBgRenderer;
import com.kwwsyk.endinv.common.client.gui.bg.ScreenRectangleWidgetParam;
import com.kwwsyk.endinv.common.client.gui.bg.Transparent;
import com.kwwsyk.endinv.common.client.gui.page.DisplayPage;
import com.kwwsyk.endinv.common.client.gui.page.ItemPage;
import com.kwwsyk.endinv.common.client.gui.page.manager.PageManager;
import com.kwwsyk.endinv.common.client.gui.widget.SortTypeSwitchBox;
import com.kwwsyk.endinv.common.client.option.CachedConfig;
import com.kwwsyk.endinv.common.client.option.MenuAttachabilityCache;
import com.kwwsyk.endinv.common.client.option.TextureMode;
import com.kwwsyk.endinv.common.network.payloads.PageData;
import com.kwwsyk.endinv.common.network.payloads.toServer.CreativeItemModPayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.QuickMoveToPagePayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.StarItemPayload;
import com.kwwsyk.endinv.common.util.SortType;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ScreenFramework
implements PageManager {
    private static ScreenFramework INSTANCE;
    private final Minecraft mc;
    public final AbstractContainerScreen<?> screen;
    public final AbstractContainerMenu menu;
    private ScreenRectangleWidgetParam searchBoxParam;
    private ScreenRectangleWidgetParam sortBoxParam;
    private ScreenRectangleWidgetParam configButtonParam;
    private ScreenRectangleWidgetParam pageBarScrollUpButtonParam;
    private ScreenRectangleWidgetParam pageBarScrollDownButtonParam;
    public SFBgRenderer SFBgRenderer;
    public final int pageBarCount;
    public int firstPageIndex = 0;
    public int leftPos;
    public int topPos;
    public int imageWidth;
    public int imageHeight;
    private int pageX;
    private int pageY;
    private final int pageXSize;
    private int pageYSize;
    private int pageOffsetX;
    private int pageOffsetY;
    private int roughMouseX;
    private int roughMouseY;
    public EditBox searchBox;
    public SortTypeSwitchBox sortTypeSwitchBox;
    private Button reverseSortButton;
    private Button configButton;
    private final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
    private int rows;
    private final int columns;
    private DisplayPage displayingPage;
    public final List<DisplayPage> pages;
    private boolean isHoveringOnPage;
    private ItemStack creativeQuickInsertedItem = ItemStack.f_41583_;
    private boolean ignoreTextInput;

    public ScreenFramework(EndlessInventoryScreen screen) {
        this.screen = screen;
        this.mc = Minecraft.m_91087_();
        this.menu = screen.m_6262_();
        this.leftPos = screen.getGuiLeft();
        this.topPos = screen.getGuiTop();
        this.imageWidth = screen.getXSize();
        this.imageHeight = screen.getYSize();
        PageData layout = CachedConfig.resolveLayout(screen, true);
        this.columns = Math.max(1, layout.columns());
        this.rows = Math.max(1, layout.rows());
        this.SFBgRenderer = new FromResource.MenuMode(this, new ScreenRectangleWidgetParam(this.leftPos - 32, this.topPos + 1, 32, 28));
        this.pages = this.buildPages();
        this.pageBarCount = Math.min(ClientModInfo.getClientConfig().maxPageBarCount().get(), this.getPages().size());
        this.pageBarScrollUpButtonParam = new ScreenRectangleWidgetParam(this.leftPos - 32, this.topPos - 16, 30, 14);
        this.pageBarScrollDownButtonParam = new ScreenRectangleWidgetParam(this.leftPos - 32, this.topPos + 2 + 28 * this.pageBarCount, 30, 14);
        this.configButtonParam = new ScreenRectangleWidgetParam(this.leftPos + this.imageWidth, Math.min(this.topPos + this.imageHeight, screen.f_96544_ - 20), 18, 18);
        this.searchBoxParam = new ScreenRectangleWidgetParam(this.leftPos + 89, this.topPos + 5, 80, 12);
        this.sortBoxParam = new ScreenRectangleWidgetParam(this.leftPos + 8, this.topPos + 5, 60, 12);
        this.pageX = this.leftPos + 8;
        this.pageY = this.topPos + 17;
        this.pageXSize = this.columns * 18;
        this.pageYSize = this.rows * 18;
        this.switchPageWithId(layout.pageRegKey());
        this.addWidgets();
        INSTANCE = this;
    }

    public ScreenFramework(AttachingScreen<?> attachingScreen) {
        this.screen = attachingScreen.screen;
        this.mc = Minecraft.m_91087_();
        this.menu = attachingScreen.menu;
        PageData layout = CachedConfig.resolveLayout(this.screen, false);
        this.rows = layout.rows();
        this.columns = layout.columns();
        this.leftPos = 20;
        this.topPos = Math.max((this.screen.f_96544_ - this.rows * 18 - 17 - 10) / 2, 20);
        this.imageWidth = 13 + 18 * this.columns;
        this.imageHeight = this.screen.f_96544_;
        this.SFBgRenderer = ClientModInfo.getClientConfig().textureMode().get() != TextureMode.TRANSPARENT ? new FromResource.LeftLayout(this, new ScreenRectangleWidgetParam(this.leftPos - 32, this.topPos + 20, 32, 28)) : new Transparent(this, new ScreenRectangleWidgetParam(this.leftPos - 32, this.topPos + 20, 32, 28));
        this.pages = this.buildPages();
        this.pageBarCount = Math.min(ClientModInfo.getClientConfig().maxPageBarCount().get(), this.getPages().size());
        this.pageBarScrollUpButtonParam = new ScreenRectangleWidgetParam(0, this.topPos, 20, 14);
        this.pageBarScrollDownButtonParam = new ScreenRectangleWidgetParam(0, this.topPos + 22 + 28 * this.pageBarCount, 20, 14);
        int searchBoxY = this.topPos + 17 + 18 * this.rows + 12;
        this.searchBoxParam = new ScreenRectangleWidgetParam(this.leftPos + 1, searchBoxY, Math.min(200, this.imageWidth), Math.min(20, this.screen.f_96544_ - searchBoxY));
        this.configButtonParam = new ScreenRectangleWidgetParam(0, Math.min(searchBoxY, this.screen.f_96544_ - 20), 20, 20);
        this.sortBoxParam = new ScreenRectangleWidgetParam(this.leftPos + 6, this.topPos + 5, 77, 12);
        this.pageX = this.leftPos + 8;
        this.pageY = this.topPos + 17;
        this.pageXSize = this.columns * 18;
        this.pageYSize = this.rows * 18;
        this.switchPageWithId(layout.pageRegKey());
        this.addWidgets();
        INSTANCE = this;
    }

    private void addWidgets() {
        this.configButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2699"), btn -> this.mc.m_91152_(ClientModInfo.createConfigScreen(this.screen))).m_252794_(this.configButtonParam.XPos(), this.configButtonParam.YPos()).m_253046_(this.configButtonParam.XSize(), this.configButtonParam.YSize()).m_253136_();
        this.reverseSortButton = Button.m_253074_((Component)Component.m_237113_((String)"\u21c5"), btn -> {
            CachedConfig.setReverseSort(!CachedConfig.reverseSort());
            DisplayPage patt0$temp = this.getDisplayingPage();
            if (patt0$temp instanceof ItemPage) {
                ItemPage page = (ItemPage)patt0$temp;
                page.refreshItems();
            }
        }).m_252794_(this.sortBoxParam.XPos() + this.sortBoxParam.XSize() + 2, this.sortBoxParam.YPos()).m_253046_(this.sortBoxParam.YSize(), this.sortBoxParam.YSize()).m_253136_();
        this.searchBox = new EditBox(this.mc.f_91062_, this.searchBoxParam.XPos(), this.searchBoxParam.YPos(), this.searchBoxParam.XSize(), this.searchBoxParam.YSize(), (Component)Component.m_237115_((String)"itemGroup.search"));
        this.sortTypeSwitchBox = new SortTypeSwitchBox(this, this, this.sortBoxParam);
        this.searchBox.m_94144_(this.searching());
        if (this.pageBarCount < this.getPages().size()) {
            Button up = Button.m_253074_((Component)Component.m_237113_((String)"^"), btn -> {
                if (this.firstPageIndex > 0) {
                    --this.firstPageIndex;
                }
            }).m_252794_(this.pageBarScrollUpButtonParam.XPos(), this.pageBarScrollUpButtonParam.YPos()).m_253046_(this.pageBarScrollUpButtonParam.XSize(), this.pageBarScrollUpButtonParam.YSize()).m_253136_();
            Button down = Button.m_253074_((Component)Component.m_237113_((String)"v"), btn -> {
                if (this.firstPageIndex + this.pageBarCount < this.getPages().size()) {
                    ++this.firstPageIndex;
                }
            }).m_252794_(this.pageBarScrollDownButtonParam.XPos(), this.pageBarScrollDownButtonParam.YPos()).m_253046_(this.pageBarScrollDownButtonParam.XSize(), this.pageBarScrollDownButtonParam.YSize()).m_253136_();
            this.widgets.add((AbstractWidget)up);
            this.widgets.add((AbstractWidget)down);
        }
        this.widgets.add((AbstractWidget)this.configButton);
        this.widgets.add((AbstractWidget)this.reverseSortButton);
        this.widgets.add((AbstractWidget)this.searchBox);
        this.widgets.add(this.sortTypeSwitchBox);
    }

    public void addWidgetToScreen(Consumer<AbstractWidget> installer) {
        this.widgets.forEach(installer);
    }

    public void renderPre(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public void renderBg(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.SFBgRenderer.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        this.getDisplayingPage().initRenderer(this, this.getPageX(), this.getPageY());
        this.getDisplayingPage().renderBg(this.SFBgRenderer, guiGraphics, partialTick, mouseX, mouseY);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.roughMouseX = mouseX;
        this.roughMouseY = mouseY;
        this.isHoveringOnPage = this.hasClickedOnPage(mouseX, mouseY);
        this.getDisplayingPage().initRenderer(this, this.getPageX(), this.getPageY());
        this.getDisplayingPage().render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.searchBox.m_274382_() && !this.searchBox.m_93696_()) {
            guiGraphics.m_280677_(this.mc.f_91062_, List.of(Component.m_237115_((String)"search.endinv.prefix.sharp"), Component.m_237115_((String)"search.endinv.prefix.at"), Component.m_237115_((String)"search.endinv.prefix.xor"), Component.m_237115_((String)"search.endinv.prefix.star")), Optional.empty(), mouseX, mouseY);
        }
        if (this.reverseSortButton.m_274382_()) {
            guiGraphics.m_280557_(this.mc.f_91062_, (Component)Component.m_237115_((String)"button.endinv.reverse"), mouseX, mouseY);
        }
    }

    protected boolean hasClickedOnPage(double mouseX, double mouseY) {
        return mouseX >= (double)this.getPageX() && mouseX <= (double)this.getPageX() + (double)this.pageXSize && mouseY >= (double)this.getPageY() && mouseY <= (double)this.getPageY() + (double)this.pageYSize && !this.sortTypeSwitchBox.m_274382_();
    }

    protected int hasClickedOnPageSwitchBar(double mouseX, double mouseY) {
        double XOffset = mouseX - (double)this.SFBgRenderer.pageSwitchBarParam().XPos();
        double YOffset = mouseY - (double)this.SFBgRenderer.pageSwitchBarParam().YPos();
        if (XOffset < 0.0 || XOffset > (double)this.SFBgRenderer.pageSwitchBarParam().XSize() || YOffset < 0.0) {
            return -1;
        }
        int index = (int)YOffset / this.SFBgRenderer.pageSwitchBarParam().YSize();
        if (index < 0 || index >= this.pageBarCount) {
            return -1;
        }
        return index;
    }

    protected void pageSwitched(int index) {
        this.switchPageWithIndex(index + this.firstPageIndex);
        this.searchBox.m_94194_(this.getDisplayingPage().hasSearchbox());
        this.sortTypeSwitchBox.f_93624_ = this.getDisplayingPage().hasSortTypeSwitchBar();
        CachedConfig.setDisplayingPageKey(this.getDisplayingPageId());
        CachedConfig.updateLayoutWith(this.getPageData());
    }

    public void switchSortTypeTo(SortType type) {
        CachedConfig.setSortType(type);
        DisplayPage displayPage = this.getDisplayingPage();
        if (displayPage instanceof ItemPage) {
            ItemPage page = (ItemPage)displayPage;
            page.refreshItems();
        }
    }

    private boolean isHovering(Slot slot, double mouseX, double mouseY) {
        return this.isHovering(slot.f_40220_, slot.f_40221_, 16, 16, mouseX, mouseY);
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        int i = ClientModInfo.containerScreenHelper.getGuiLeft(this.screen);
        int j = ClientModInfo.containerScreenHelper.getGuiTop(this.screen);
        return (mouseX -= (double)i) >= (double)(x - 1) && mouseX < (double)(x + width + 1) && (mouseY -= (double)j) >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    public boolean hoveringOnPage() {
        return !this.sortTypeSwitchBox.m_274382_();
    }

    @Nullable
    private Slot findSlot(double mouseX, double mouseY) {
        for (int i = 0; i < this.menu.f_38839_.size(); ++i) {
            Slot slot = (Slot)this.menu.f_38839_.get(i);
            if (!this.isHovering(slot, mouseX, mouseY) || !slot.m_6659_()) continue;
            return slot;
        }
        return null;
    }

    private void slotQuickMoved(Slot clicked) {
        ItemStack itemStack = clicked.m_7993_().m_41777_();
        if (this.menu instanceof CreativeModeInventoryScreen.ItemPickerMenu && clicked.f_40219_ < 45 && this.menu.f_38839_.size() >= 54) {
            if (ItemStack.m_322370_((ItemStack)itemStack, (ItemStack)this.creativeQuickInsertedItem)) {
                return;
            }
            this.creativeQuickInsertedItem = itemStack;
            itemStack.m_41764_(itemStack.m_41741_());
            this.getDisplayingPage().tryInsertItem(itemStack);
            ModInfo.getPacketDistributor().sendToServer(new CreativeItemModPayload(itemStack, true));
        } else {
            int payloadId;
            boolean canAttach;
            boolean bl = canAttach = this.screen instanceof EndlessInventoryScreen || MenuAttachabilityCache.isAttachable(this.screen);
            if (!canAttach) {
                return;
            }
            ItemStack remain = this.getDisplayingPage().tryInsertItem(itemStack);
            clicked.m_269060_(remain);
            clicked.m_142406_(this.getPlayer(), itemStack);
            int n = payloadId = this.menu instanceof CreativeModeInventoryScreen.ItemPickerMenu ? this.getItemPickerMenuSlotOffset(clicked) : this.menu.f_38839_.indexOf((Object)clicked);
            if (payloadId >= 0) {
                ModInfo.getPacketDistributor().sendToServer(new QuickMoveToPagePayload(payloadId));
            }
        }
        DisplayPage displayPage = this.getDisplayingPage();
        if (displayPage instanceof ItemPage) {
            ItemPage itemPage = (ItemPage)displayPage;
            itemPage.requestRemoteContents();
        }
    }

    private int getItemPickerMenuSlotOffset(Slot clicked) {
        int originalIndex = clicked.f_40219_;
        if (originalIndex == 0 && clicked.m_150661_() > 0) {
            return clicked.m_150661_();
        }
        if (originalIndex < 45) {
            return originalIndex;
        }
        return originalIndex - 9;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int keyCode) {
        Slot clicked;
        if (!this.searchBoxParam.hasClickedOn((int)mouseX, (int)mouseY)) {
            this.searchBox.m_93692_(false);
        } else {
            this.searchBox.m_93692_(true);
            if (keyCode == 1) {
                this.searchBox.m_94144_("");
                this.refreshSearchResults();
                return true;
            }
        }
        boolean flg = ClientModInfo.inputHandler.isActiveAndMatches(KeyMappings.QUICK_MOVE, InputConstants.Type.MOUSE.m_84895_(keyCode));
        if (flg && (clicked = this.findSlot(mouseX, mouseY)) != null && clicked.m_6657_()) {
            this.slotQuickMoved(clicked);
            return true;
        }
        int pageIndex = this.hasClickedOnPageSwitchBar(mouseX, mouseY);
        if (pageIndex >= 0) {
            this.pageSwitched(pageIndex);
            return true;
        }
        if (this.hasClickedOnPage(mouseX, mouseY)) {
            this.sortTypeSwitchBox.setOpen(false);
            return this.getDisplayingPage().mouseClicked(mouseX - (double)this.getPageX(), mouseY - (double)this.getPageY(), keyCode);
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        Slot clicked;
        ItemStack itemstack = this.menu.m_142621_();
        if (!itemstack.m_41619_() || ((Boolean)this.mc.f_91066_.m_231828_().m_231551_()).booleanValue()) {
            return false;
        }
        if (ClientModInfo.inputHandler.isActiveAndMatches(KeyMappings.QUICK_MOVE, InputConstants.Type.MOUSE.m_84895_(button)) && (clicked = this.findSlot(mouseX, mouseY)) != null && clicked.m_6657_()) {
            this.slotQuickMoved(clicked);
            return true;
        }
        if (this.hasClickedOnPage(mouseX, mouseY)) {
            return this.getDisplayingPage().mouseDragged(mouseX - (double)this.getPageX(), mouseY - (double)this.getPageY(), button, dragX, dragY);
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int keyCode) {
        this.creativeQuickInsertedItem = ItemStack.f_41583_;
        DisplayPage displayingPage = this.getDisplayingPage();
        displayingPage.release();
        if (this.hasClickedOnPage(mouseX, mouseY)) {
            return displayingPage.mouseReleased(mouseX - (double)this.getPageX(), mouseY - (double)this.getPageY(), keyCode);
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollY) {
        if (this.hasClickedOnPage(mouseX, mouseY)) {
            mouseY = this.getPageY();
            return this.getDisplayingPage().mouseScrolled(mouseX - (double)this.getPageX(), mouseY, scrollY);
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        Slot clicked;
        this.ignoreTextInput = false;
        if (ClientModInfo.inputHandler.isActiveAndMatches(KeyMappings.STAR_ITEM, InputConstants.m_84827_((int)keyCode, (int)scanCode)) && (clicked = this.findSlot(this.roughMouseX, this.roughMouseY)) != null && clicked.m_6657_()) {
            ItemStack itemStack = clicked.m_7993_();
            ModInfo.getPacketDistributor().sendToServer(new StarItemPayload(itemStack, true));
            this.getDisplayingPage().sendChangesToServer();
            return true;
        }
        boolean flag = false;
        if (this.isHoveringOnPage) {
            flag = this.getDisplayingPage().keyPressed(keyCode, scanCode, modifiers, this.roughMouseX - this.getPageX(), this.roughMouseY - this.getPageY());
        }
        if (flag) {
            this.ignoreTextInput = true;
            return true;
        }
        if (this.getDisplayingPage().hasSearchbox() && this.searchBox.m_93696_()) {
            String s = this.searchBox.m_94155_();
            if (this.searchBox.m_7933_(keyCode, scanCode, modifiers)) {
                if (!Objects.equals(s, this.searchBox.m_94155_())) {
                    this.refreshSearchResults();
                }
                return true;
            }
            return this.searchBox.m_93696_() && this.searchBox.m_94213_() && keyCode != 256;
        }
        return false;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.ignoreTextInput || !this.getDisplayingPage().hasSearchbox()) {
            return false;
        }
        String s = this.searchBox.m_94155_();
        if (this.searchBox.m_5534_(codePoint, modifiers)) {
            if (!Objects.equals(s, this.searchBox.m_94155_())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return false;
    }

    public void onClose() {
        INSTANCE = null;
    }

    public void refreshSearchResults() {
        String searching = this.searchBox.m_94155_();
        CachedConfig.setSearching(searching);
        DisplayPage displayPage = this.getDisplayingPage();
        if (displayPage instanceof ItemPage) {
            ItemPage page = (ItemPage)displayPage;
            page.refreshItems();
        }
    }

    @Nullable
    public static ScreenFramework getInstance() {
        return INSTANCE;
    }

    public int getPageX() {
        return this.pageX + this.pageOffsetX;
    }

    public int getPageY() {
        return this.pageY + this.pageOffsetY;
    }

    public void move(int deltaX, int deltaY) {
        this.pageOffsetX += deltaX;
        this.pageOffsetY += deltaY;
        DisplayPage current = this.getDisplayingPage();
        if (current != null) {
            current.move(deltaX, deltaY);
        }
    }

    public void resizePageRows(int rows) {
        this.rows = Math.max(1, rows);
        this.pageYSize = this.rows * 18;
        DisplayPage current = this.getDisplayingPage();
        if (current != null) {
            current.resize(this.rows);
        }
    }

    @Override
    public AbstractContainerMenu getMenu() {
        return this.menu;
    }

    @Override
    public SourceInventory getSourceInventory() {
        return CachedSrcInv.INSTANCE;
    }

    @Override
    public Player getPlayer() {
        return this.mc.f_91074_;
    }

    @Override
    public void switchPageWithIndex(int index) {
        this.displayingPage = this.pages.get(index);
        this.displayingPage.initializeContents();
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public int columns() {
        return this.columns;
    }

    @Override
    public List<DisplayPage> getPages() {
        return this.pages;
    }

    @Override
    public DisplayPage getDisplayingPage() {
        return this.displayingPage;
    }
}

