/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui.bg;

import com.kwwsyk.endinv.common.AbstractModInitializer;
import com.kwwsyk.endinv.common.client.ClientModInfo;
import com.kwwsyk.endinv.common.client.gui.ScreenFramework;
import com.kwwsyk.endinv.common.client.gui.bg.SFBgRenderer;
import com.kwwsyk.endinv.common.client.gui.bg.SFBgRendererImpl;
import com.kwwsyk.endinv.common.client.gui.bg.ScreenRectangleWidgetParam;
import com.kwwsyk.endinv.common.client.option.TextureMode;
import com.kwwsyk.endinv.common.menu.EndlessInventoryMenu;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public abstract class FromResource
extends SFBgRendererImpl {
    public static final ResourceLocation CONTAINER_TEXTURE_RESOURCE = ResourceLocation.m_340282_((String)"textures/gui/container/generic_54.png");
    public static final ResourceLocation TABS_RESOURCE = ResourceLocation.m_340282_((String)"textures/gui/advancements/tabs.png");
    private static final ResourceLocation TAB_LEFT_MIDDLE_SPRITE = ResourceLocation.m_340282_((String)"advancements/tab_left_middle");
    private static final ResourceLocation TAB_LEFT_TOP_SELECTED = ResourceLocation.m_340282_((String)"advancements/tab_left_top_selected");
    private static final ResourceLocation TAB_LEFT_MIDDLE_SELECTED = ResourceLocation.m_340282_((String)"advancements/tab_left_middle_selected");
    private static final ResourceLocation TAB_LEFT_BOTTOM_SELECTED = ResourceLocation.m_340282_((String)"advancements/tab_left_bottom_selected");
    public static final ResourceLocation DEDICATED_CONTAINER_TEXTURE = ResourceLocation.m_339182_((String)"endless_inventory", (String)"textures/gui/item_grid.png");
    public static final ResourceLocation DEDICATED_TABS = ResourceLocation.m_339182_((String)"endless_inventory", (String)"textures/gui/tabs.png");
    private static final ResourceLocation TAB_UNSELECTED = AbstractModInitializer.withModLocation("textures/gui/tab_left_middle");
    private static final ResourceLocation TAB_TOP = ResourceLocation.m_340282_((String)"textures/gui/tab_left_top_selected");
    private static final ResourceLocation TAB_MIDDLE = ResourceLocation.m_340282_((String)"textures/gui/tab_left_middle_selected");
    private static final ResourceLocation TAB_BOTTOM = ResourceLocation.m_340282_((String)"textures/gui/tab_left_bottom_selected");
    public static final ResourceLocation ITEM_ENTRY_DISPLAY_RESOURCE = ResourceLocation.m_339182_((String)"endless_inventory", (String)"textures/gui/item_entry.png");

    private static ResourceLocation getContainerTexture() {
        return ClientModInfo.getClientConfig().textureMode().get() == TextureMode.DEDICATED_LOCATION ? DEDICATED_CONTAINER_TEXTURE : CONTAINER_TEXTURE_RESOURCE;
    }

    private static ResourceLocation getTabsTexture(TabType type) {
        return ClientModInfo.getClientConfig().textureMode().get() == TextureMode.DEDICATED_LOCATION ? type.dedicatedLocation : type.vanillaTexture;
    }

    public FromResource(ScreenFramework frameWork) {
        super(frameWork);
    }

    @Override
    public Optional<SFBgRenderer.PageBgRender> getDefaultPageBgRenderer() {
        return Optional.of(new PagePainter(this){

            @Override
            public ResourceLocation texture() {
                return FromResource.getContainerTexture();
            }
        });
    }

    public PagePainter dedicatePageBgRender(final ResourceLocation texture) {
        return new PagePainter(this){

            @Override
            public ResourceLocation texture() {
                return texture;
            }
        };
    }

    @Override
    public void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int pageX = this.pageSwitchTabParam.XPos();
        int pageY = this.pageSwitchTabParam.YPos();
        int selectedPageIndex = this.frameWork.getDisplayingPageIndex();
        for (int i = this.frameWork.firstPageIndex; i < this.frameWork.firstPageIndex + this.frameWork.pageBarCount; ++i) {
            if (i == selectedPageIndex) {
                if (i == 0) {
                    guiGraphics.m_292816_(FromResource.getTabsTexture(TabType.TOP), pageX, pageY, 32, 28);
                } else if (i == this.frameWork.firstPageIndex + this.frameWork.pageBarCount - 1) {
                    guiGraphics.m_292816_(FromResource.getTabsTexture(TabType.BOTTOM), pageX, pageY, 32, 28);
                } else {
                    guiGraphics.m_292816_(FromResource.getTabsTexture(TabType.MIDDLE), pageX, pageY, 32, 28);
                }
            } else {
                guiGraphics.m_292816_(FromResource.getTabsTexture(TabType.UNSELECTED), pageX + 4, pageY, 32, 28);
            }
            pageY += 28;
        }
        this.renderPageBarContent(guiGraphics, partialTick, mouseX, mouseY);
    }

    public static enum TabType {
        UNSELECTED(TAB_LEFT_MIDDLE_SPRITE, TAB_UNSELECTED),
        TOP(TAB_LEFT_TOP_SELECTED, TAB_TOP),
        MIDDLE(TAB_LEFT_MIDDLE_SELECTED, TAB_MIDDLE),
        BOTTOM(TAB_LEFT_BOTTOM_SELECTED, TAB_BOTTOM);

        final ResourceLocation vanillaTexture;
        final ResourceLocation dedicatedLocation;

        private TabType(ResourceLocation vanillaTexture, ResourceLocation dedicatedLocation) {
            this.vanillaTexture = vanillaTexture;
            this.dedicatedLocation = dedicatedLocation;
        }
    }

    public abstract class PagePainter
    implements SFBgRenderer.PageBgRender {
        public abstract ResourceLocation texture();

        @Override
        public void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
            int startX = FromResource.this.pageLeft;
            int startY = FromResource.this.pageTop;
            if (FromResource.this.columns != 9) {
                this.renderSpecialBg(guiGraphics, partialTick, mouseX, mouseY, startX, startY);
            } else {
                guiGraphics.m_280163_(this.texture(), startX, startY, 0.0f, 0.0f, FromResource.this.imageWidth, 17, 256, 256);
                startY += 17;
                int rowsToRender = FromResource.this.rows;
                while (rowsToRender > 0) {
                    int height = 18 * Math.min(rowsToRender, 6);
                    guiGraphics.m_280163_(this.texture(), startX, startY, 0.0f, 17.0f, FromResource.this.imageWidth, height, 256, 256);
                    rowsToRender -= 6;
                    startY += height;
                }
                guiGraphics.m_280163_(this.texture(), startX, FromResource.this.pageTop + 17 + 18 * FromResource.this.rows, 0.0f, 124.0f, FromResource.this.imageWidth, 12, 256, 256);
            }
        }

        private void renderSpecialBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY, int startX, int startY) {
            int width;
            int columnsToRender;
            int initialX = startX;
            guiGraphics.m_280163_(this.texture(), startX, startY, 0.0f, 0.0f, 7, 17, 256, 256);
            startX += 7;
            for (columnsToRender = FromResource.this.columns; columnsToRender > 0; columnsToRender -= 9) {
                width = 18 * Math.min(9, columnsToRender);
                guiGraphics.m_280163_(this.texture(), startX, startY, 7.0f, 0.0f, width, 17, 256, 256);
                startX += width;
            }
            guiGraphics.m_280163_(this.texture(), startX, startY, 168.0f, 0.0f, 8, 17, 256, 256);
            startX = initialX;
            startY += 17;
            for (int rowsToRender = FromResource.this.rows; rowsToRender > 0; rowsToRender -= 6) {
                int height = 18 * Math.min(rowsToRender, 6);
                guiGraphics.m_280163_(this.texture(), startX, startY, 0.0f, 17.0f, 7, height, 256, 256);
                startX += 7;
                for (int columnsToRender2 = FromResource.this.columns; columnsToRender2 > 0; columnsToRender2 -= 9) {
                    int width2 = 18 * Math.min(9, columnsToRender2);
                    guiGraphics.m_280163_(this.texture(), startX, startY, 7.0f, 17.0f, width2, height, 256, 256);
                    startX += width2;
                }
                guiGraphics.m_280163_(this.texture(), startX, startY, 168.0f, 17.0f, 8, height, 256, 256);
                startX = initialX;
                startY += height;
            }
            guiGraphics.m_280163_(this.texture(), startX, startY, 0.0f, 124.0f, 7, 12, 256, 256);
            startX += 7;
            for (columnsToRender = FromResource.this.columns; columnsToRender > 0; columnsToRender -= 9) {
                width = 18 * Math.min(9, columnsToRender);
                guiGraphics.m_280163_(this.texture(), startX, startY, 7.0f, 124.0f, width, 12, 256, 256);
                startX += width;
            }
            guiGraphics.m_280163_(this.texture(), startX, startY, 168.0f, 124.0f, 8, 12, 256, 256);
            startX = initialX;
        }
    }

    public static class LeftLayout
    extends FromResource {
        public LeftLayout(ScreenFramework frameWork, ScreenRectangleWidgetParam pageSwitchTabParam) {
            super(frameWork);
            this.pageSwitchTabParam = pageSwitchTabParam;
        }
    }

    public static class MenuMode
    extends FromResource {
        public MenuMode(ScreenFramework frameWork, ScreenRectangleWidgetParam pageSwitchTabParam) {
            super(frameWork);
            this.pageSwitchTabParam = pageSwitchTabParam;
        }

        @Override
        public void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
            int n;
            super.renderBg(guiGraphics, partialTick, mouseX, mouseY);
            AbstractContainerMenu abstractContainerMenu = this.frameWork.menu;
            if (abstractContainerMenu instanceof EndlessInventoryMenu) {
                EndlessInventoryMenu endless = (EndlessInventoryMenu)abstractContainerMenu;
                n = endless.getBaseRows();
            } else {
                n = this.rows;
            }
            int baseRows = n;
            int startY = this.menuTop + 17 + baseRows * 18;
            this.renderPlayerInv(guiGraphics, partialTick, mouseX, mouseY, this.menuLeft, startY);
        }

        private void renderPlayerInv(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY, int startX, int startY) {
            guiGraphics.m_280163_(FromResource.getContainerTexture(), startX, startY, 0.0f, 126.0f, this.imageWidth, 96, 256, 256);
        }
    }
}

