/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui.page;

import com.kwwsyk.endinv.common.client.CachedSrcInv;
import com.kwwsyk.endinv.common.client.gui.page.ItemDisplay;
import com.kwwsyk.endinv.common.client.gui.page.manager.PageManager;
import com.kwwsyk.endinv.common.client.option.CachedConfig;
import com.kwwsyk.endinv.common.menu.page.PageType;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class SegClassifyItemDisplay
extends ItemDisplay {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<Predicate<ItemStack>> subClassifies;
    private final boolean includeRemainItems;
    private final boolean keepClassifiedItemInNextSeg;
    private final List<ItemStack> segmentedView = new ArrayList<ItemStack>();
    private final List<Integer> segmentStartSlots = new ArrayList<Integer>();
    private final List<Integer> pageSeparatorRows = new ArrayList<Integer>();

    public SegClassifyItemDisplay(PageType pageType, PageManager metaDataManager, List<Predicate<ItemStack>> subClassifies, boolean includeRemainItems, boolean keepClassifiedItemInNextSeg) {
        super(pageType, metaDataManager);
        this.subClassifies = subClassifies == null ? List.of() : List.copyOf(subClassifies);
        this.includeRemainItems = includeRemainItems;
        this.keepClassifiedItemInNextSeg = keepClassifiedItemInNextSeg;
    }

    @Override
    public void readCachedItems() {
        List<ItemStack> source = CachedSrcInv.INSTANCE.getSortedAndFilteredItemView(0, Integer.MAX_VALUE, CachedConfig.sortType(), CachedConfig.reverseSort(), this.getClassify(), CachedConfig.searching());
        this.buildContentsWith(source);
    }

    @Override
    public void buildContentsWith(@NotNull List<ItemStack> stacks) {
        if (this.holdOn) {
            this.inQueueStacks = stacks;
            return;
        }
        this.rebuildSegments(stacks);
    }

    private void buildContentDirectly(List<ItemStack> stacks) {
        for (int i = 0; i < this.length; ++i) {
            if (i < stacks.size() && stacks.get(i) != null) {
                this.items.set(i, (Object)stacks.get(i).m_41777_());
                continue;
            }
            this.items.set(i, (Object)ItemStack.f_41583_);
        }
    }

    @Override
    public void renderPage(GuiGraphics guiGraphics) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        int rowIndex = 0;
        int columnIndex = 0;
        int columns = this.meta.columns();
        for (ItemStack item : this.items) {
            if (columnIndex == 0 && this.pageSeparatorRows.contains(rowIndex)) {
                int y = this.topPos + rowIndex * 18;
                guiGraphics.m_280509_(this.leftPos, y, this.leftPos + columns * 18 - 2, y + 1, -10855846);
            }
            if (item.m_41619_() && !item.m_150930_(Items.f_41852_)) {
                this.renderEmpty(guiGraphics, this.leftPos + columnIndex * 18, this.topPos + rowIndex * 18 + 1, item);
            }
            guiGraphics.m_280256_(item, this.leftPos + columnIndex * 18, this.topPos + rowIndex * 18 + 1, columnIndex + rowIndex * 180);
            if (!this.isHiddenBySortBox(rowIndex, columnIndex)) {
                guiGraphics.m_280302_(Minecraft.m_91087_().f_91062_, item, this.leftPos + columnIndex * 18, this.topPos + rowIndex * 18 + 1, this.getDisplayAmount(item));
            }
            if (++columnIndex < columns) continue;
            columnIndex = 0;
            ++rowIndex;
        }
        guiGraphics.m_280168_().m_85849_();
    }

    @Override
    public ItemStack takeItem(ItemStack itemStack, int count) {
        this.setChanged();
        ItemStack result = this.srcInv.takeItem(itemStack, count);
        this.readCachedItems();
        return result;
    }

    @Override
    public ItemStack takeItem(int index, int count) {
        int viewIndex = this.startIndex + index;
        if (viewIndex < 0 || viewIndex >= this.segmentedView.size()) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = this.segmentedView.get(viewIndex);
        if (itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.setChanged();
        ItemStack result = this.srcInv.takeItem(itemStack, count);
        this.readCachedItems();
        return result;
    }

    @Override
    public ItemStack addItem(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.setChanged();
        ItemStack remain = this.srcInv.addItem(itemStack.m_41777_());
        this.readCachedItems();
        return remain;
    }

    private void rebuildSegments(List<ItemStack> source) {
        this.segmentedView.clear();
        this.segmentStartSlots.clear();
        this.pageSeparatorRows.clear();
        ArrayList<ItemStack> filtered = new ArrayList<ItemStack>();
        for (ItemStack stack : source) {
            if (stack == null || stack.m_41619_()) continue;
            filtered.add(stack.m_41777_());
        }
        if (filtered.isEmpty()) {
            this.buildContentDirectly(List.of());
            return;
        }
        boolean[] consumed = new boolean[filtered.size()];
        boolean[] matchedAtLeastOnce = new boolean[filtered.size()];
        for (Predicate<ItemStack> classifier : this.subClassifies) {
            if (classifier == null) continue;
            int start = this.segmentedView.size();
            ArrayList<ItemStack> segment = new ArrayList<ItemStack>();
            for (int i = 0; i < filtered.size(); ++i) {
                ItemStack stack;
                if (!this.keepClassifiedItemInNextSeg && consumed[i] || !classifier.test(stack = (ItemStack)filtered.get(i))) continue;
                segment.add(stack.m_41777_());
                matchedAtLeastOnce[i] = true;
                if (this.keepClassifiedItemInNextSeg) continue;
                consumed[i] = true;
            }
            if (segment.isEmpty()) continue;
            this.segmentStartSlots.add(start);
            this.appendSegment(this.segmentedView, segment);
        }
        if (this.includeRemainItems) {
            ArrayList<ItemStack> remain = new ArrayList<ItemStack>();
            for (int i = 0; i < filtered.size(); ++i) {
                boolean consumedFlag;
                boolean matched = matchedAtLeastOnce[i];
                boolean bl = consumedFlag = this.keepClassifiedItemInNextSeg ? matched : consumed[i];
                if (consumedFlag) continue;
                remain.add(((ItemStack)filtered.get(i)).m_41777_());
            }
            if (!remain.isEmpty()) {
                this.segmentStartSlots.add(this.segmentedView.size());
                this.appendSegment(this.segmentedView, remain);
            }
        }
        this.updateDisplayedSlice();
    }

    private void appendSegment(List<ItemStack> target, List<ItemStack> segment) {
        if (segment.isEmpty()) {
            return;
        }
        target.addAll(segment);
        int columns = this.meta.columns();
        if (columns <= 0) {
            return;
        }
        int remainder = segment.size() % columns;
        if (remainder == 0) {
            return;
        }
        int filler = columns - remainder;
        for (int i = 0; i < filler; ++i) {
            target.add(ItemStack.f_41583_);
        }
    }

    private void updateDisplayedSlice() {
        int columns = Math.max(1, this.meta.columns());
        int fromIndex = Math.min(this.startIndex, this.segmentedView.size());
        int toIndex = Math.min(fromIndex + this.length, this.segmentedView.size());
        List<ItemStack> slice = this.segmentedView.subList(fromIndex, toIndex);
        this.buildContentDirectly(slice);
        this.pageSeparatorRows.clear();
        if (!this.segmentStartSlots.isEmpty()) {
            int firstRow = fromIndex / columns;
            int rowEndExclusive = Mth.m_184652_((int)Math.max(toIndex, fromIndex), (int)columns);
            for (Integer start : this.segmentStartSlots) {
                int relative;
                int row;
                if (start == null || (row = start / columns) <= firstRow || row >= rowEndExclusive || this.pageSeparatorRows.contains(relative = row - firstRow)) continue;
                this.pageSeparatorRows.add(relative);
            }
            if (!this.pageSeparatorRows.isEmpty()) {
                this.pageSeparatorRows.sort(Integer::compareTo);
            }
        }
    }
}

