/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.data;

import com.kwwsyk.endinv.common.EndInvAffinities;
import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.util.Accessibility;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public interface EndInvCodecStrategy {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String ITEM_ID_KEY = "id";
    public static final String ITEM_COUNT_KEY = "count";
    public static final String DEPRECATED_COUNT_KEY = "Count";
    public static final String COMPONENTS_KEY = "components";
    public static final String END_INV_LIST_KEY = "endless_inventories";
    public static final String ITEM_LIST_KEY = "Items";
    public static final String SIZE_INT_KEY = "Size";
    public static final String LAST_MOD_TIME_LONG_KEY = "modState";
    public static final String UUID_KEY = "uuid";
    public static final String MAX_STACK_SIZE_INT_KEY = "maxItemStackSize";
    public static final String INFINITY_BOOL_KEY = "Infinity";
    public static final String AFFINITY_KEY = "Affinities";
    public static final String BOOKMARK_LIST_KEY = "starred_items";
    public static final String OWNER_UUID_KEY = "Owner";
    public static final String WHITE_LIST_KEY = "white_list";
    public static final String ACCESSIBILITY_KEY = "Accessibility";
    public static final Codec<ItemStack> ITEM_STACK_CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.f_303113_.fieldOf(ITEM_ID_KEY).forGetter(ItemStack::m_220173_), (App)Codec.INT.fieldOf(ITEM_COUNT_KEY).orElse((Object)1).forGetter(ItemStack::m_41613_), (App)DataComponentPatch.f_315187_.optionalFieldOf(COMPONENTS_KEY, (Object)DataComponentPatch.f_315512_).forGetter(ItemStack::m_324277_)).apply((Applicative)instance, ItemStack::new)));

    default public EndlessInventory deserializeEndInv(CompoundTag invTag, HolderLookup.Provider provider) {
        EndlessInventory endlessInventory = new EndlessInventory(invTag.m_128342_(UUID_KEY));
        this.deserializeItems(endlessInventory, invTag, provider);
        this.decodeAffinities(endlessInventory, (CompoundTag)invTag.m_128423_(AFFINITY_KEY), provider);
        if (invTag.m_128441_(OWNER_UUID_KEY)) {
            endlessInventory.setOwner(invTag.m_128342_(OWNER_UUID_KEY));
        }
        if (invTag.m_128441_(WHITE_LIST_KEY)) {
            endlessInventory.white_list.addAll(invTag.m_128437_(WHITE_LIST_KEY, 11).stream().map(NbtUtils::m_129233_).toList());
        }
        if (invTag.m_128441_(ACCESSIBILITY_KEY)) {
            endlessInventory.setAccessibility(Accessibility.valueOf(invTag.m_128461_(ACCESSIBILITY_KEY)));
        }
        if (invTag.m_128441_(MAX_STACK_SIZE_INT_KEY)) {
            endlessInventory.setMaxItemStackSize(invTag.m_128451_(MAX_STACK_SIZE_INT_KEY));
        }
        if (invTag.m_128441_(INFINITY_BOOL_KEY)) {
            endlessInventory.setInfinityMode(invTag.m_128471_(INFINITY_BOOL_KEY));
        }
        return endlessInventory;
    }

    default public CompoundTag serializeEndInv(EndlessInventory endInv, HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        CompoundTag itemData = this.serializeItems(endInv, provider);
        nbt.m_128391_(itemData);
        CompoundTag affTag = this.encodeAffinities(endInv.affinities, provider);
        nbt.m_128365_(AFFINITY_KEY, (Tag)affTag);
        nbt.m_128362_(UUID_KEY, endInv.getUuid());
        if (endInv.getOwnerUUID() != null) {
            nbt.m_128362_(OWNER_UUID_KEY, endInv.getOwnerUUID());
        }
        ListTag whiteList = new ListTag();
        for (UUID uuid : endInv.white_list) {
            whiteList.add((Object)NbtUtils.m_129226_((UUID)uuid));
        }
        nbt.m_128365_(WHITE_LIST_KEY, (Tag)whiteList);
        nbt.m_128359_(ACCESSIBILITY_KEY, endInv.getAccessibility().name());
        nbt.m_128405_(MAX_STACK_SIZE_INT_KEY, endInv.getMaxItemStackSize());
        nbt.m_128379_(INFINITY_BOOL_KEY, endInv.isInfinityMode());
        return nbt;
    }

    public void deserializeItems(EndlessInventory var1, CompoundTag var2, HolderLookup.Provider var3);

    public CompoundTag serializeItems(EndlessInventory var1, HolderLookup.Provider var2);

    public boolean canHandle(CompoundTag var1);

    default public CompoundTag encodeAffinities(EndInvAffinities affinities, HolderLookup.Provider provider) {
        CompoundTag ret = new CompoundTag();
        ListTag nbtTagList = new ListTag();
        List<ItemStack> items = affinities.starredItems;
        for (ItemStack itemStack : items) {
            if (itemStack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            nbtTagList.add((Object)EndInvCodecStrategy.saveItem(itemStack.m_255036_(1), itemTag, provider));
        }
        ret.m_128365_(BOOKMARK_LIST_KEY, (Tag)nbtTagList);
        return ret;
    }

    default public void decodeAffinities(EndlessInventory endlessInventory, @Nullable CompoundTag nbt, HolderLookup.Provider provider) {
        EndInvAffinities aff = endlessInventory.affinities;
        if (nbt == null) {
            return;
        }
        ListTag tagList = nbt.m_128437_(BOOKMARK_LIST_KEY, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTag = tagList.m_128728_(i);
            EndInvCodecStrategy.parse((Tag)itemTag, provider).filter(it -> !it.m_41619_()).ifPresent(aff::addStarredItem);
        }
    }

    public static Optional<ItemStack> parse(Tag tag, HolderLookup.Provider provider) {
        if (!(tag instanceof CompoundTag)) {
            return Optional.empty();
        }
        CompoundTag compound = (CompoundTag)tag;
        try {
            return Optional.of(EndInvCodecStrategy.loadItem(compound, provider));
        }
        catch (Exception e) {
            LOGGER.error("Tried to load invalid item: '{}'", (Object)compound, (Object)e);
            return Optional.empty();
        }
    }

    public static Tag saveItem(ItemStack itemStack, CompoundTag outputTag, HolderLookup.Provider provider) {
        if (itemStack.m_41619_()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return EndInvCodecStrategy.save(itemStack, outputTag, provider);
    }

    public static CompoundTag save(ItemStack stack, CompoundTag compoundTag, HolderLookup.Provider provider) {
        return (CompoundTag)ITEM_STACK_CODEC.encode((Object)stack, (DynamicOps)provider.m_318927_((DynamicOps)NbtOps.f_128958_), (Object)compoundTag).getOrThrow();
    }

    public static ItemStack loadItem(CompoundTag compoundTag, HolderLookup.Provider provider) {
        try {
            if (compoundTag.m_128441_(DEPRECATED_COUNT_KEY)) {
                ItemStack ret = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(ResourceLocation.m_338530_((String)compoundTag.m_128461_(ITEM_ID_KEY))), compoundTag.m_128451_(DEPRECATED_COUNT_KEY));
                if (compoundTag.m_128441_(COMPONENTS_KEY)) {
                    DataComponentPatch patch = (DataComponentPatch)DataComponentPatch.f_315187_.parse((DynamicOps)provider.m_318927_((DynamicOps)NbtOps.f_128958_), (Object)compoundTag).getOrThrow();
                    ret.m_319238_(patch);
                }
                return ret;
            }
            return (ItemStack)ITEM_STACK_CODEC.parse((DynamicOps)provider.m_318927_((DynamicOps)NbtOps.f_128958_), (Object)compoundTag).getOrThrow();
        }
        catch (RuntimeException runtimeexception) {
            LOGGER.debug("Tried to load invalid item: {}", (Object)compoundTag, (Object)runtimeexception);
            return ItemStack.f_41583_;
        }
    }
}

