/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.data;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.data.EndInvCodecStrategy;
import com.kwwsyk.endinv.common.data.FullCodecStrategy;
import com.kwwsyk.endinv.common.data.SortedSaveStrategy;
import com.mojang.logging.LogUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.LevelResource;
import org.slf4j.Logger;

public class EndlessInventoryData
extends SavedData {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final List<EndlessInventory> levelEndInvs = new ArrayList<EndlessInventory>();
    public static EndInvCodecStrategy LoadStrategy = new FullCodecStrategy();
    public static EndInvCodecStrategy SaveStrategy = new FullCodecStrategy();

    private EndlessInventoryData() {
    }

    public static void init(ServerLevel level) {
        if (!level.m_46472_().equals((Object)Level.f_46428_)) {
            return;
        }
        SavedData.Factory factory = new SavedData.Factory(EndlessInventoryData::create, EndlessInventoryData::load, DataFixTypes.CHUNK);
        ServerLevelEndInv.levelEndInvData = (EndlessInventoryData)level.m_8895_().m_164861_(factory, "endless_inventories");
        LOGGER.info("Initialized EndlessInventoryData in {} with {} inventories", (Object)level.m_46472_().m_135782_(), (Object)ServerLevelEndInv.levelEndInvData.levelEndInvs.size());
    }

    public static BackupResult backup(ServerLevel level) {
        try {
            Path worldDir = level.m_7654_().m_129843_(LevelResource.f_78182_).normalize();
            Path dataFile = worldDir.resolve("data/endless_inventories.dat");
            if (!Files.exists(dataFile, new LinkOption[0])) {
                throw new FileNotFoundException("Cannot find data file: " + String.valueOf(dataFile));
            }
            Path backupDir = worldDir.resolve("endinv_backup");
            Files.createDirectories(backupDir, new FileAttribute[0]);
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss"));
            Path backupFile = backupDir.resolve("endless_inventories_" + timestamp + ".dat");
            Files.copy(dataFile, backupFile, StandardCopyOption.REPLACE_EXISTING);
            return new BackupResult(true, backupFile.toString());
        }
        catch (IOException e) {
            return new BackupResult(false, e.getMessage());
        }
        catch (Exception e) {
            return new BackupResult(false, "Unexpected exception");
        }
    }

    public static EndlessInventoryData create() {
        return new EndlessInventoryData();
    }

    public void addEndInvToLevel(EndlessInventory endlessInventory) {
        this.levelEndInvs.add(endlessInventory);
        this.m_77762_();
    }

    public void byIndexRemove(int index) {
        if (index < 0 || index >= this.levelEndInvs.size()) {
            return;
        }
        this.levelEndInvs.remove(index);
    }

    public EndlessInventory fromUUID(UUID uuid) {
        for (EndlessInventory endlessInventory : this.levelEndInvs) {
            if (!Objects.equals(endlessInventory.getUuid(), uuid)) continue;
            return endlessInventory;
        }
        return null;
    }

    @Nullable
    public EndlessInventory fromIndex(int index) {
        if (index < 0 || index >= this.levelEndInvs.size()) {
            return null;
        }
        return this.levelEndInvs.get(index);
    }

    public int getIndex(EndlessInventory endlessInventory) {
        int index = 0;
        for (EndlessInventory endinv : this.levelEndInvs) {
            if (Objects.equals(endlessInventory, endinv)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static EndlessInventoryData load(CompoundTag tag, HolderLookup.Provider provider) {
        EndlessInventoryData data = EndlessInventoryData.create();
        ListTag listTag = tag.m_128437_("endless_inventories", 10);
        CompoundTag head = listTag.m_128728_(0);
        EndlessInventoryData.checkStrategy(head);
        listTag.iterator().forEachRemaining(t -> data.levelEndInvs.add(LoadStrategy.deserializeEndInv((CompoundTag)t, provider)));
        return data;
    }

    static void checkStrategy(CompoundTag tag) {
        boolean flag = LoadStrategy.canHandle(tag);
        if (!flag) {
            LoadStrategy = new SortedSaveStrategy();
            LOGGER.debug("EndInv load strategy changed to default as current strategy cannot handle.");
        }
    }

    public CompoundTag m_7176_(CompoundTag compoundTag, HolderLookup.Provider provider) {
        ListTag nbtTagList = new ListTag();
        for (EndlessInventory endlessInventory : this.levelEndInvs) {
            CompoundTag invTag = SaveStrategy.serializeEndInv(endlessInventory, provider);
            nbtTagList.add((Object)invTag);
        }
        CompoundTag saveTag = new CompoundTag();
        saveTag.m_128365_("endless_inventories", (Tag)nbtTagList);
        return saveTag;
    }

    public record BackupResult(boolean success, @Nullable String message) {
    }
}

